/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.EmbeddedId;
import jakarta.persistence.Id;
import jakarta.persistence.Lob;
import jakarta.persistence.Version;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.util.Map;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.annotations.AttributeBinderType;
import org.hibernate.annotations.EmbeddableInstantiator;
import org.hibernate.annotations.IdGeneratorType;
import org.hibernate.annotations.Immutable;
import org.hibernate.annotations.NaturalId;
import org.hibernate.annotations.OptimisticLock;
import org.hibernate.annotations.ValueGenerationType;
import org.hibernate.annotations.common.reflection.XAnnotatedElement;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.binder.AttributeBinder;
import org.hibernate.boot.model.internal.AnnotatedColumns;
import org.hibernate.boot.model.internal.AnnotationBinder;
import org.hibernate.boot.model.internal.BasicValueBinder;
import org.hibernate.boot.model.internal.BinderHelper;
import org.hibernate.boot.model.internal.EntityBinder;
import org.hibernate.boot.model.internal.HCANNHelper;
import org.hibernate.boot.model.internal.InheritanceState;
import org.hibernate.boot.model.internal.PropertyHolder;
import org.hibernate.boot.model.internal.PropertyPreloadedData;
import org.hibernate.boot.model.relational.ExportableProducer;
import org.hibernate.boot.spi.AccessType;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.generator.AnnotationBasedGenerator;
import org.hibernate.generator.BeforeExecutionGenerator;
import org.hibernate.generator.Generator;
import org.hibernate.generator.GeneratorCreationContext;
import org.hibernate.generator.OnExecutionGenerator;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.factory.spi.CustomIdGeneratorCreationContext;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.GeneratorCreator;
import org.hibernate.mapping.IdentifierGeneratorCreator;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.MappedSuperclass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.Value;
import org.hibernate.property.access.spi.PropertyAccessStrategy;
import org.jboss.logging.Logger;

public class PropertyBinder {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)PropertyBinder.class.getName());
    private MetadataBuildingContext buildingContext;
    private String name;
    private String returnedClassName;
    private boolean lazy;
    private String lazyGroup;
    private AccessType accessType;
    private AnnotatedColumns columns;
    private PropertyHolder holder;
    private Value value;
    private boolean insertable = true;
    private boolean updatable = true;
    private String cascade;
    private BasicValueBinder basicValueBinder;
    private XClass declaringClass;
    private boolean declaringClassSet;
    private boolean embedded;
    private EntityBinder entityBinder;
    private boolean isXToMany;
    private String referencedEntityName;
    private PropertyAccessStrategy propertyAccessStrategy;
    private XProperty property;
    private XClass returnedClass;
    private boolean isId;
    private Map<XClass, InheritanceState> inheritanceStatePerClass;

    public void setReferencedEntityName(String referencedEntityName) {
        this.referencedEntityName = referencedEntityName;
    }

    public void setEmbedded(boolean embedded) {
        this.embedded = embedded;
    }

    public void setEntityBinder(EntityBinder entityBinder) {
        this.entityBinder = entityBinder;
    }

    public void setInsertable(boolean insertable) {
        this.insertable = insertable;
    }

    public void setUpdatable(boolean updatable) {
        this.updatable = updatable;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setReturnedClassName(String returnedClassName) {
        this.returnedClassName = returnedClassName;
    }

    public void setLazy(boolean lazy) {
        this.lazy = lazy;
    }

    public void setLazyGroup(String lazyGroup) {
        this.lazyGroup = lazyGroup;
    }

    public void setAccessType(AccessType accessType) {
        this.accessType = accessType;
    }

    public void setColumns(AnnotatedColumns columns) {
        this.columns = columns;
    }

    public void setHolder(PropertyHolder holder) {
        this.holder = holder;
    }

    public void setValue(Value value) {
        this.value = value;
    }

    public void setCascade(String cascadeStrategy) {
        this.cascade = cascadeStrategy;
    }

    public void setBuildingContext(MetadataBuildingContext buildingContext) {
        this.buildingContext = buildingContext;
    }

    public void setPropertyAccessStrategy(PropertyAccessStrategy propertyAccessStrategy) {
        this.propertyAccessStrategy = propertyAccessStrategy;
    }

    public void setDeclaringClass(XClass declaringClass) {
        this.declaringClass = declaringClass;
        this.declaringClassSet = true;
    }

    private boolean isToOneValue(Value value) {
        return value instanceof ToOne;
    }

    public void setProperty(XProperty property) {
        this.property = property;
    }

    public void setReturnedClass(XClass returnedClass) {
        this.returnedClass = returnedClass;
    }

    public BasicValueBinder getBasicValueBinder() {
        return this.basicValueBinder;
    }

    public Value getValue() {
        return this.value;
    }

    public void setId(boolean id) {
        this.isId = id;
    }

    public boolean isId() {
        return this.isId;
    }

    public void setInheritanceStatePerClass(Map<XClass, InheritanceState> inheritanceStatePerClass) {
        this.inheritanceStatePerClass = inheritanceStatePerClass;
    }

    private void validateBind() {
        if (!this.declaringClassSet) {
            throw new AssertionFailure("declaringClass has not been set before a bind");
        }
    }

    private void validateMake() {
    }

    private Property makePropertyAndValue() {
        this.validateBind();
        LOG.debugf("MetadataSourceProcessor property %s with lazy=%s", this.name, this.lazy);
        String containerClassName = this.holder.getClassName();
        this.holder.startingProperty(this.property);
        this.basicValueBinder = new BasicValueBinder(BasicValueBinder.Kind.ATTRIBUTE, this.buildingContext);
        this.basicValueBinder.setPropertyName(this.name);
        this.basicValueBinder.setReturnedClassName(this.returnedClassName);
        this.basicValueBinder.setColumns(this.columns);
        this.basicValueBinder.setPersistentClassName(containerClassName);
        this.basicValueBinder.setType(this.property, this.returnedClass, containerClassName, this.holder.resolveAttributeConverterDescriptor(this.property));
        this.basicValueBinder.setReferencedEntityName(this.referencedEntityName);
        this.basicValueBinder.setAccessType(this.accessType);
        this.value = this.basicValueBinder.make();
        return this.makeProperty();
    }

    private void callAttributeBinders(Property prop) {
        Object containingAnnotation = HCANNHelper.findContainingAnnotation((XAnnotatedElement)this.property, AttributeBinderType.class);
        if (containingAnnotation != null) {
            AttributeBinderType binderType = containingAnnotation.annotationType().getAnnotation(AttributeBinderType.class);
            try {
                AttributeBinder<?> binder = binderType.binder().newInstance();
                binder.bind(containingAnnotation, this.buildingContext, this.entityBinder.getPersistentClass(), prop);
            }
            catch (Exception e) {
                throw new AnnotationException("error processing @AttributeBinderType annotation", e);
            }
        }
    }

    public Property makePropertyAndBind() {
        return this.bind(this.makeProperty());
    }

    public Property makePropertyValueAndBind() {
        return this.bind(this.makePropertyAndValue());
    }

    public void setXToMany(boolean xToMany) {
        this.isXToMany = xToMany;
    }

    private Property bind(Property property) {
        if (this.isId) {
            RootClass rootClass = (RootClass)this.holder.getPersistentClass();
            if (this.isXToMany || this.entityBinder.wrapIdsInEmbeddedComponents()) {
                Component identifier = (Component)rootClass.getIdentifier();
                if (identifier == null) {
                    identifier = AnnotationBinder.createComponent(this.holder, new PropertyPreloadedData(null, null, null), true, false, this.resolveCustomInstantiator(this.property, this.returnedClass), this.buildingContext);
                    rootClass.setIdentifier(identifier);
                    identifier.setNullValue("undefined");
                    rootClass.setEmbeddedIdentifier(true);
                    rootClass.setIdentifierMapper(identifier);
                }
                identifier.addProperty(property);
            } else {
                rootClass.setIdentifier((KeyValue)this.getValue());
                if (this.embedded) {
                    rootClass.setEmbeddedIdentifier(true);
                } else {
                    rootClass.setIdentifierProperty(property);
                    MappedSuperclass superclass = BinderHelper.getMappedSuperclassOrNull(this.declaringClass, this.inheritanceStatePerClass, this.buildingContext);
                    if (superclass != null) {
                        superclass.setDeclaredIdentifierProperty(property);
                    } else {
                        rootClass.setDeclaredIdentifierProperty(property);
                    }
                }
            }
        } else {
            this.holder.addProperty(property, this.columns, this.declaringClass);
        }
        if (this.buildingContext.getMetadataCollector().isInSecondPass()) {
            this.callAttributeBinders(property);
        } else {
            this.buildingContext.getMetadataCollector().addSecondPass(persistentClasses -> this.callAttributeBinders(property));
        }
        return property;
    }

    private Class<? extends org.hibernate.metamodel.spi.EmbeddableInstantiator> resolveCustomInstantiator(XProperty property, XClass embeddableClass) {
        EmbeddableInstantiator propertyAnnotation = (EmbeddableInstantiator)property.getAnnotation(EmbeddableInstantiator.class);
        if (propertyAnnotation != null) {
            return propertyAnnotation.value();
        }
        EmbeddableInstantiator classAnnotation = (EmbeddableInstantiator)embeddableClass.getAnnotation(EmbeddableInstantiator.class);
        if (classAnnotation != null) {
            return classAnnotation.value();
        }
        return null;
    }

    public Property makeProperty() {
        this.validateMake();
        LOG.debugf("Building property %s", this.name);
        Property property = new Property();
        property.setName(this.name);
        property.setValue(this.value);
        property.setLazy(this.lazy);
        property.setLazyGroup(this.lazyGroup);
        property.setCascade(this.cascade);
        property.setPropertyAccessorName(this.accessType.getType());
        property.setReturnedClassName(this.returnedClassName);
        if (this.property != null) {
            if (this.entityBinder != null) {
                this.handleNaturalId(property);
                property.setValueGeneratorCreator(this.getValueGenerationFromAnnotations(this.property));
            }
            property.setLob(this.property.isAnnotationPresent(Lob.class));
        }
        property.setPropertyAccessStrategy(this.propertyAccessStrategy);
        this.handleImmutable(property);
        this.inferOptimisticLocking(property);
        property.setInsertable(this.insertable);
        property.setUpdateable(this.updatable);
        LOG.tracev("Cascading {0} with {1}", this.name, this.cascade);
        return property;
    }

    private void handleImmutable(Property property) {
        if (this.property != null && this.property.isAnnotationPresent(Immutable.class)) {
            this.updatable = false;
        }
    }

    private void handleNaturalId(Property property) {
        NaturalId naturalId = (NaturalId)this.property.getAnnotation(NaturalId.class);
        if (naturalId != null) {
            if (!this.entityBinder.isRootEntity()) {
                throw new AnnotationException("Property '" + StringHelper.qualify(this.holder.getPath(), this.name) + "' belongs to an entity subclass and may not be annotated '@NaturalId' (only a property of a root '@Entity' or a '@MappedSuperclass' may be a '@NaturalId')");
            }
            if (!naturalId.mutable()) {
                this.updatable = false;
            }
            property.setNaturalIdentifier(true);
        }
    }

    private void inferOptimisticLocking(Property property) {
        if (this.value instanceof Collection) {
            property.setOptimisticLocked(((Collection)this.value).isOptimisticLocked());
        } else if (this.property != null && this.property.isAnnotationPresent(OptimisticLock.class)) {
            OptimisticLock optimisticLock = (OptimisticLock)this.property.getAnnotation(OptimisticLock.class);
            this.validateOptimisticLock(optimisticLock);
            property.setOptimisticLocked(!optimisticLock.excluded());
        } else {
            property.setOptimisticLocked(!this.isToOneValue(this.value) || this.insertable);
        }
    }

    private void validateOptimisticLock(OptimisticLock optimisticLock) {
        if (optimisticLock.excluded()) {
            if (this.property.isAnnotationPresent(Version.class)) {
                throw new AnnotationException("Property '" + StringHelper.qualify(this.holder.getPath(), this.name) + "' is annotated '@OptimisticLock(excluded=true)' and '@Version'");
            }
            if (this.property.isAnnotationPresent(Id.class)) {
                throw new AnnotationException("Property '" + StringHelper.qualify(this.holder.getPath(), this.name) + "' is annotated '@OptimisticLock(excluded=true)' and '@Id'");
            }
            if (this.property.isAnnotationPresent(EmbeddedId.class)) {
                throw new AnnotationException("Property '" + StringHelper.qualify(this.holder.getPath(), this.name) + "' is annotated '@OptimisticLock(excluded=true)' and '@EmbeddedId'");
            }
        }
    }

    private GeneratorCreator getValueGenerationFromAnnotations(XProperty property) {
        GeneratorCreator creator = null;
        for (Annotation annotation : property.getAnnotations()) {
            GeneratorCreator candidate = PropertyBinder.generatorCreator(property, annotation);
            if (candidate == null) continue;
            if (creator != null) {
                throw new AnnotationException("Property '" + StringHelper.qualify(this.holder.getPath(), this.name) + "' has multiple '@ValueGenerationType' annotations");
            }
            creator = candidate;
        }
        return creator;
    }

    private static void checkGeneratorClass(Class<? extends Generator> generatorClass) {
        if (!BeforeExecutionGenerator.class.isAssignableFrom(generatorClass) && !OnExecutionGenerator.class.isAssignableFrom(generatorClass)) {
            throw new MappingException("Generator class '" + generatorClass.getName() + "' must implement either 'BeforeExecutionGenerator' or 'OnExecutionGenerator'");
        }
    }

    private static void checkGeneratorInterfaces(Class<? extends Generator> generatorClass) {
        if (IdentifierGenerator.class.isAssignableFrom(generatorClass)) {
            throw new AnnotationException("Generator class '" + generatorClass.getName() + "' implements 'IdentifierGenerator' and may not be used with '@ValueGenerationType'");
        }
        if (ExportableProducer.class.isAssignableFrom(generatorClass)) {
            throw new AnnotationException("Generator class '" + generatorClass.getName() + "' implements 'ExportableProducer' and may not be used with '@ValueGenerationType'");
        }
    }

    public static GeneratorCreator generatorCreator(XProperty property, Annotation annotation) {
        Member member = HCANNHelper.getUnderlyingMember(property);
        Class<? extends Annotation> annotationType = annotation.annotationType();
        ValueGenerationType generatorAnnotation = annotationType.getAnnotation(ValueGenerationType.class);
        if (generatorAnnotation == null) {
            return null;
        }
        Class<? extends Generator> generatorClass = generatorAnnotation.generatedBy();
        PropertyBinder.checkGeneratorClass(generatorClass);
        PropertyBinder.checkGeneratorInterfaces(generatorClass);
        return creationContext -> {
            Object generator = PropertyBinder.instantiateGenerator(annotation, member, annotationType, creationContext, GeneratorCreationContext.class, generatorClass);
            PropertyBinder.callInitialize(annotation, member, creationContext, generator);
            PropertyBinder.checkVersionGenerationAlways(property, generator);
            return generator;
        };
    }

    public static IdentifierGeneratorCreator identifierGeneratorCreator(XProperty idProperty, Annotation annotation) {
        Member member = HCANNHelper.getUnderlyingMember(idProperty);
        Class<? extends Annotation> annotationType = annotation.annotationType();
        IdGeneratorType idGeneratorType = annotationType.getAnnotation(IdGeneratorType.class);
        assert (idGeneratorType != null);
        return creationContext -> {
            Class<? extends Generator> generatorClass = idGeneratorType.value();
            PropertyBinder.checkGeneratorClass(generatorClass);
            Generator generator = PropertyBinder.instantiateGenerator(annotation, member, annotationType, creationContext, CustomIdGeneratorCreationContext.class, generatorClass);
            PropertyBinder.callInitialize(annotation, member, creationContext, generator);
            PropertyBinder.checkIdGeneratorTiming(annotationType, generator);
            return generator;
        };
    }

    private static <C, G extends Generator> G instantiateGenerator(Annotation annotation, Member member, Class<? extends Annotation> annotationType, C creationContext, Class<C> contextClass, Class<? extends G> generatorClass) {
        try {
            try {
                return (G)((Generator)generatorClass.getConstructor(annotationType, Member.class, contextClass).newInstance(annotation, member, creationContext));
            }
            catch (NoSuchMethodException ignore) {
                try {
                    return (G)((Generator)generatorClass.getConstructor(annotationType).newInstance(annotation));
                }
                catch (NoSuchMethodException i) {
                    return (G)((Generator)generatorClass.newInstance());
                }
            }
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new HibernateException("Could not instantiate generator of type '" + generatorClass.getName() + "'", e);
        }
    }

    private static <A extends Annotation> void callInitialize(A annotation, Member member, GeneratorCreationContext creationContext, Generator generator) {
        if (generator instanceof AnnotationBasedGenerator) {
            AnnotationBasedGenerator generation = (AnnotationBasedGenerator)generator;
            generation.initialize(annotation, member, creationContext);
        }
    }

    private static void checkVersionGenerationAlways(XProperty property, Generator generator) {
        if (property.isAnnotationPresent(Version.class)) {
            if (!generator.generatesOnInsert()) {
                throw new AnnotationException("Property '" + property.getName() + "' is annotated '@Version' but has a 'Generator' which does not generate on inserts");
            }
            if (!generator.generatesOnUpdate()) {
                throw new AnnotationException("Property '" + property.getName() + "' is annotated '@Version' but has a 'Generator' which does not generate on updates");
            }
        }
    }

    private static void checkIdGeneratorTiming(Class<? extends Annotation> annotationType, Generator generator) {
        if (!generator.generatesOnInsert()) {
            throw new MappingException("Annotation '" + annotationType + "' is annotated 'IdGeneratorType' but the given 'Generator' does not generate on inserts");
        }
        if (generator.generatesOnUpdate()) {
            throw new MappingException("Annotation '" + annotationType + "' is annotated 'IdGeneratorType' but the given 'Generator' generates on updates (it must generate only on inserts)");
        }
    }
}

