/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.SqlResultSetMapping;
import java.util.Map;
import org.hibernate.MappingException;
import org.hibernate.boot.model.internal.QuerySecondPass;
import org.hibernate.boot.query.SqlResultSetMappingDescriptor;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.mapping.PersistentClass;

public class ResultSetMappingSecondPass
implements QuerySecondPass {
    private final SqlResultSetMapping ann;
    private final MetadataBuildingContext context;
    private final boolean isDefault;

    public ResultSetMappingSecondPass(SqlResultSetMapping ann, MetadataBuildingContext context, boolean isDefault) {
        this.ann = ann;
        this.context = context;
        this.isDefault = isDefault;
    }

    @Override
    public void doSecondPass(Map<String, PersistentClass> persistentClasses) throws MappingException {
        if (this.ann == null) {
            return;
        }
        SqlResultSetMappingDescriptor mappingDefinition = SqlResultSetMappingDescriptor.from(this.ann, this.context);
        if (this.isDefault) {
            this.context.getMetadataCollector().addDefaultResultSetMapping(mappingDefinition);
        } else {
            this.context.getMetadataCollector().addResultSetMapping(mappingDefinition);
        }
    }
}

