/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.process.spi;

import java.lang.reflect.Type;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.ResourceStreamLocator;
import org.hibernate.boot.internal.InFlightMetadataCollectorImpl;
import org.hibernate.boot.internal.MetadataBuildingContextRootImpl;
import org.hibernate.boot.jaxb.internal.MappingBinder;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.boot.model.TypeContributor;
import org.hibernate.boot.model.process.internal.ManagedResourcesImpl;
import org.hibernate.boot.model.process.internal.ScanningCoordinator;
import org.hibernate.boot.model.process.spi.ManagedResources;
import org.hibernate.boot.model.process.spi.NoOpMetadataSourceProcessorImpl;
import org.hibernate.boot.model.source.internal.annotations.AnnotationMetadataSourceProcessorImpl;
import org.hibernate.boot.model.source.internal.hbm.EntityHierarchyBuilder;
import org.hibernate.boot.model.source.internal.hbm.EntityHierarchySourceImpl;
import org.hibernate.boot.model.source.internal.hbm.HbmMetadataSourceProcessorImpl;
import org.hibernate.boot.model.source.internal.hbm.MappingDocument;
import org.hibernate.boot.model.source.internal.hbm.ModelBinder;
import org.hibernate.boot.model.source.spi.MetadataSourceProcessor;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.spi.AdditionalJaxbMappingProducer;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.MetadataBuildingOptions;
import org.hibernate.boot.spi.MetadataContributor;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.cfg.MetadataSourceType;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.config.spi.StandardConverters;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.type.BasicTypeRegistry;
import org.hibernate.type.descriptor.java.spi.JavaTypeRegistry;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JsonJdbcType;
import org.hibernate.type.descriptor.jdbc.XmlAsStringJdbcType;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;
import org.hibernate.type.descriptor.sql.DdlType;
import org.hibernate.type.descriptor.sql.internal.DdlTypeImpl;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;
import org.hibernate.type.internal.NamedBasicTypeImpl;
import org.hibernate.type.spi.TypeConfiguration;
import org.jboss.jandex.IndexView;
import org.jboss.logging.Logger;

public class MetadataBuildingProcess {
    private static final Logger log = Logger.getLogger(MetadataBuildingProcess.class);

    public static MetadataImplementor build(MetadataSources sources, BootstrapContext bootstrapContext, MetadataBuildingOptions options) {
        return MetadataBuildingProcess.complete(MetadataBuildingProcess.prepare(sources, bootstrapContext), bootstrapContext, options);
    }

    public static ManagedResources prepare(MetadataSources sources, BootstrapContext bootstrapContext) {
        ManagedResourcesImpl managedResources = ManagedResourcesImpl.baseline(sources, bootstrapContext);
        ConfigurationService configService = bootstrapContext.getServiceRegistry().getService(ConfigurationService.class);
        boolean xmlMappingEnabled = configService.getSetting("hibernate.xml_mapping_enabled", StandardConverters.BOOLEAN, Boolean.valueOf(true));
        ScanningCoordinator.INSTANCE.coordinateScan(managedResources, bootstrapContext, xmlMappingEnabled ? sources.getXmlMappingBinderAccess() : null);
        return managedResources;
    }

    public static MetadataImplementor complete(final ManagedResources managedResources, BootstrapContext bootstrapContext, final MetadataBuildingOptions options) {
        Collection<AdditionalJaxbMappingProducer> producers;
        InFlightMetadataCollectorImpl metadataCollector = new InFlightMetadataCollectorImpl(bootstrapContext, options);
        MetadataBuildingProcess.handleTypes(bootstrapContext, options);
        ClassLoaderService classLoaderService = options.getServiceRegistry().getService(ClassLoaderService.class);
        final MetadataBuildingContextRootImpl rootMetadataBuildingContext = new MetadataBuildingContextRootImpl("orm", bootstrapContext, options, metadataCollector);
        managedResources.getAttributeConverterDescriptors().forEach(metadataCollector::addAttributeConverter);
        bootstrapContext.getTypeConfiguration().scope(rootMetadataBuildingContext);
        final IndexView jandexView = bootstrapContext.getJandexView();
        MetadataSourceProcessor processor = new MetadataSourceProcessor(){
            private final MetadataSourceProcessor hbmProcessor;
            private final AnnotationMetadataSourceProcessorImpl annotationProcessor;
            {
                this.hbmProcessor = options.isXmlMappingEnabled() ? new HbmMetadataSourceProcessorImpl(managedResources, (MetadataBuildingContext)rootMetadataBuildingContext) : new NoOpMetadataSourceProcessorImpl();
                this.annotationProcessor = new AnnotationMetadataSourceProcessorImpl(managedResources, rootMetadataBuildingContext, jandexView);
            }

            @Override
            public void prepare() {
                this.hbmProcessor.prepare();
                this.annotationProcessor.prepare();
            }

            @Override
            public void processTypeDefinitions() {
                this.hbmProcessor.processTypeDefinitions();
                this.annotationProcessor.processTypeDefinitions();
            }

            @Override
            public void processQueryRenames() {
                this.hbmProcessor.processQueryRenames();
                this.annotationProcessor.processQueryRenames();
            }

            @Override
            public void processNamedQueries() {
                this.hbmProcessor.processNamedQueries();
                this.annotationProcessor.processNamedQueries();
            }

            @Override
            public void processAuxiliaryDatabaseObjectDefinitions() {
                this.hbmProcessor.processAuxiliaryDatabaseObjectDefinitions();
                this.annotationProcessor.processAuxiliaryDatabaseObjectDefinitions();
            }

            @Override
            public void processIdentifierGenerators() {
                this.hbmProcessor.processIdentifierGenerators();
                this.annotationProcessor.processIdentifierGenerators();
            }

            @Override
            public void processFilterDefinitions() {
                this.hbmProcessor.processFilterDefinitions();
                this.annotationProcessor.processFilterDefinitions();
            }

            @Override
            public void processFetchProfiles() {
                this.hbmProcessor.processFetchProfiles();
                this.annotationProcessor.processFetchProfiles();
            }

            @Override
            public void prepareForEntityHierarchyProcessing() {
                for (MetadataSourceType metadataSourceType : options.getSourceProcessOrdering()) {
                    if (metadataSourceType == MetadataSourceType.HBM) {
                        this.hbmProcessor.prepareForEntityHierarchyProcessing();
                    }
                    if (metadataSourceType != MetadataSourceType.CLASS) continue;
                    this.annotationProcessor.prepareForEntityHierarchyProcessing();
                }
            }

            @Override
            public void processEntityHierarchies(Set<String> processedEntityNames) {
                for (MetadataSourceType metadataSourceType : options.getSourceProcessOrdering()) {
                    if (metadataSourceType == MetadataSourceType.HBM) {
                        this.hbmProcessor.processEntityHierarchies(processedEntityNames);
                    }
                    if (metadataSourceType != MetadataSourceType.CLASS) continue;
                    this.annotationProcessor.processEntityHierarchies(processedEntityNames);
                }
            }

            @Override
            public void postProcessEntityHierarchies() {
                for (MetadataSourceType metadataSourceType : options.getSourceProcessOrdering()) {
                    if (metadataSourceType == MetadataSourceType.HBM) {
                        this.hbmProcessor.postProcessEntityHierarchies();
                    }
                    if (metadataSourceType != MetadataSourceType.CLASS) continue;
                    this.annotationProcessor.postProcessEntityHierarchies();
                }
            }

            @Override
            public void processResultSetMappings() {
                this.hbmProcessor.processResultSetMappings();
                this.annotationProcessor.processResultSetMappings();
            }

            @Override
            public void finishUp() {
                this.hbmProcessor.finishUp();
                this.annotationProcessor.finishUp();
            }
        };
        processor.prepare();
        processor.processTypeDefinitions();
        processor.processQueryRenames();
        processor.processAuxiliaryDatabaseObjectDefinitions();
        processor.processIdentifierGenerators();
        processor.processFilterDefinitions();
        processor.processFetchProfiles();
        HashSet<String> processedEntityNames = new HashSet<String>();
        processor.prepareForEntityHierarchyProcessing();
        processor.processEntityHierarchies(processedEntityNames);
        processor.postProcessEntityHierarchies();
        processor.processResultSetMappings();
        for (MetadataContributor contributor : classLoaderService.loadJavaServices(MetadataContributor.class)) {
            log.tracef("Calling MetadataContributor : %s", (Object)contributor);
            contributor.contribute(metadataCollector, jandexView);
        }
        metadataCollector.processSecondPasses(rootMetadataBuildingContext);
        processor.processNamedQueries();
        processor.finishUp();
        if (options.isXmlMappingEnabled() && (producers = classLoaderService.loadJavaServices(AdditionalJaxbMappingProducer.class)) != null) {
            EntityHierarchyBuilder hierarchyBuilder = new EntityHierarchyBuilder();
            MappingBinder mappingBinder = new MappingBinder((ResourceStreamLocator)classLoaderService, new MappingBinder.Options(){

                @Override
                public boolean validateMappings() {
                    return false;
                }

                @Override
                public boolean transformHbmMappings() {
                    return false;
                }
            });
            for (AdditionalJaxbMappingProducer producer : producers) {
                log.tracef("Calling AdditionalJaxbMappingProducer : %s", (Object)producer);
                Collection<MappingDocument> additionalMappings = producer.produceAdditionalMappings(metadataCollector, jandexView, mappingBinder, rootMetadataBuildingContext);
                for (MappingDocument mappingDocument : additionalMappings) {
                    hierarchyBuilder.indexMappingDocument(mappingDocument);
                }
            }
            ModelBinder binder = ModelBinder.prepare(rootMetadataBuildingContext);
            for (EntityHierarchySourceImpl entityHierarchySource : hierarchyBuilder.buildHierarchies()) {
                binder.bindEntityHierarchy(entityHierarchySource);
            }
        }
        MetadataBuildingProcess.applyExtraQueryImports(managedResources, metadataCollector);
        return metadataCollector.buildMetadataInstance(rootMetadataBuildingContext);
    }

    private static void applyExtraQueryImports(ManagedResources managedResources, InFlightMetadataCollectorImpl metadataCollector) {
        Map<String, Class<?>> extraQueryImports = managedResources.getExtraQueryImports();
        if (extraQueryImports == null || extraQueryImports.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Class<?>> entry : extraQueryImports.entrySet()) {
            metadataCollector.addImport(entry.getKey(), entry.getValue().getName());
        }
    }

    private static void handleTypes(BootstrapContext bootstrapContext, MetadataBuildingOptions options) {
        int preferredSqlTypeCodeForInstant;
        ClassLoaderService classLoaderService = options.getServiceRegistry().getService(ClassLoaderService.class);
        TypeConfiguration typeConfiguration = bootstrapContext.getTypeConfiguration();
        StandardServiceRegistry serviceRegistry = bootstrapContext.getServiceRegistry();
        JdbcTypeRegistry jdbcTypeRegistry = typeConfiguration.getJdbcTypeRegistry();
        TypeContributions typeContributions = () -> typeConfiguration;
        Dialect dialect = options.getServiceRegistry().getService(JdbcServices.class).getDialect();
        dialect.contributeTypes(typeContributions, options.getServiceRegistry());
        JdbcType dialectUuidDescriptor = jdbcTypeRegistry.findDescriptor(3000);
        JdbcType dialectArrayDescriptor = jdbcTypeRegistry.findDescriptor(2003);
        JdbcType dialectIntervalDescriptor = jdbcTypeRegistry.findDescriptor(3100);
        for (TypeContributor contributor : classLoaderService.loadJavaServices(TypeContributor.class)) {
            contributor.contribute(typeContributions, options.getServiceRegistry());
        }
        int preferredSqlTypeCodeForUuid = ConfigurationHelper.getPreferredSqlTypeCodeForUuid(serviceRegistry);
        if (preferredSqlTypeCodeForUuid != 3000) {
            MetadataBuildingProcess.adaptToPreferredSqlTypeCode(jdbcTypeRegistry, dialectUuidDescriptor, 3000, preferredSqlTypeCodeForUuid);
        } else {
            MetadataBuildingProcess.addFallbackIfNecessary(jdbcTypeRegistry, 3000, -2);
        }
        int preferredSqlTypeCodeForArray = ConfigurationHelper.getPreferredSqlTypeCodeForArray(serviceRegistry);
        if (preferredSqlTypeCodeForArray != 2003) {
            MetadataBuildingProcess.adaptToPreferredSqlTypeCode(jdbcTypeRegistry, dialectArrayDescriptor, 2003, preferredSqlTypeCodeForArray);
        } else {
            MetadataBuildingProcess.addFallbackIfNecessary(jdbcTypeRegistry, 2003, -3);
        }
        int preferredSqlTypeCodeForDuration = ConfigurationHelper.getPreferredSqlTypeCodeForDuration(serviceRegistry);
        if (preferredSqlTypeCodeForDuration != 3100) {
            MetadataBuildingProcess.adaptToPreferredSqlTypeCode(jdbcTypeRegistry, dialectIntervalDescriptor, 3100, preferredSqlTypeCodeForDuration);
        } else {
            MetadataBuildingProcess.addFallbackIfNecessary(jdbcTypeRegistry, 3100, 2);
        }
        MetadataBuildingProcess.addFallbackIfNecessary(jdbcTypeRegistry, 3002, -3);
        MetadataBuildingProcess.addFallbackIfNecessary(jdbcTypeRegistry, 3200, -3);
        MetadataBuildingProcess.addFallbackIfNecessary(jdbcTypeRegistry, 3201, -3);
        MetadataBuildingProcess.addFallbackIfNecessary(jdbcTypeRegistry, 3250, 3200);
        jdbcTypeRegistry.addDescriptorIfAbsent(JsonJdbcType.INSTANCE);
        jdbcTypeRegistry.addDescriptorIfAbsent(XmlAsStringJdbcType.INSTANCE);
        MetadataBuildingProcess.addFallbackIfNecessary(jdbcTypeRegistry, 3004, 2004);
        MetadataBuildingProcess.addFallbackIfNecessary(jdbcTypeRegistry, 3005, 2005);
        MetadataBuildingProcess.addFallbackIfNecessary(jdbcTypeRegistry, 3006, 2011);
        DdlTypeRegistry ddlTypeRegistry = typeConfiguration.getDdlTypeRegistry();
        ddlTypeRegistry.addDescriptorIfAbsent(new DdlTypeImpl(3001, ddlTypeRegistry.getTypeName(12, null, null, null), dialect));
        ddlTypeRegistry.addDescriptorIfAbsent(new DdlTypeImpl(2009, ddlTypeRegistry.getTypeName(12, null, null, null), dialect));
        DdlType geometryType = ddlTypeRegistry.getDescriptor(3200);
        if (geometryType != null) {
            ddlTypeRegistry.addDescriptorIfAbsent(new DdlTypeImpl(3250, geometryType.getTypeName(null, null, null), dialect));
        }
        typeConfiguration.addBasicTypeRegistrationContributions(options.getBasicTypeRegistrations());
        JdbcType timestampWithTimeZoneOverride = MetadataBuildingProcess.getTimestampWithTimeZoneOverride(options, jdbcTypeRegistry);
        if (timestampWithTimeZoneOverride != null) {
            MetadataBuildingProcess.adaptToDefaultTimeZoneStorage(typeConfiguration, timestampWithTimeZoneOverride);
        }
        if ((preferredSqlTypeCodeForInstant = ConfigurationHelper.getPreferredSqlTypeCodeForInstant(serviceRegistry)) != 3003) {
            MetadataBuildingProcess.adaptToPreferredSqlTypeCodeForInstant(typeConfiguration, jdbcTypeRegistry, preferredSqlTypeCodeForInstant);
        }
    }

    private static void adaptToPreferredSqlTypeCode(JdbcTypeRegistry jdbcTypeRegistry, JdbcType dialectUuidDescriptor, int defaultSqlTypeCode, int preferredSqlTypeCode) {
        if (jdbcTypeRegistry.findDescriptor(defaultSqlTypeCode) == dialectUuidDescriptor) {
            jdbcTypeRegistry.addDescriptor(defaultSqlTypeCode, jdbcTypeRegistry.getDescriptor(preferredSqlTypeCode));
        }
    }

    private static void adaptToPreferredSqlTypeCodeForInstant(TypeConfiguration typeConfiguration, JdbcTypeRegistry jdbcTypeRegistry, int preferredSqlTypeCodeForInstant) {
        JavaTypeRegistry javaTypeRegistry = typeConfiguration.getJavaTypeRegistry();
        BasicTypeRegistry basicTypeRegistry = typeConfiguration.getBasicTypeRegistry();
        NamedBasicTypeImpl instantType = new NamedBasicTypeImpl(javaTypeRegistry.getDescriptor((Type)((Object)Instant.class)), jdbcTypeRegistry.getDescriptor(preferredSqlTypeCodeForInstant), "instant");
        basicTypeRegistry.register(instantType, "org.hibernate.type.InstantType", Instant.class.getSimpleName(), Instant.class.getName());
    }

    private static void adaptToDefaultTimeZoneStorage(TypeConfiguration typeConfiguration, JdbcType timestampWithTimeZoneOverride) {
        JavaTypeRegistry javaTypeRegistry = typeConfiguration.getJavaTypeRegistry();
        BasicTypeRegistry basicTypeRegistry = typeConfiguration.getBasicTypeRegistry();
        NamedBasicTypeImpl offsetDateTimeType = new NamedBasicTypeImpl(javaTypeRegistry.getDescriptor((Type)((Object)OffsetDateTime.class)), timestampWithTimeZoneOverride, "OffsetDateTime");
        NamedBasicTypeImpl zonedDateTimeType = new NamedBasicTypeImpl(javaTypeRegistry.getDescriptor((Type)((Object)ZonedDateTime.class)), timestampWithTimeZoneOverride, "ZonedDateTime");
        basicTypeRegistry.register(offsetDateTimeType, "org.hibernate.type.OffsetDateTimeType", OffsetDateTime.class.getSimpleName(), OffsetDateTime.class.getName());
        basicTypeRegistry.register(zonedDateTimeType, "org.hibernate.type.ZonedDateTimeType", ZonedDateTime.class.getSimpleName(), ZonedDateTime.class.getName());
    }

    private static JdbcType getTimestampWithTimeZoneOverride(MetadataBuildingOptions options, JdbcTypeRegistry jdbcTypeRegistry) {
        switch (options.getDefaultTimeZoneStorage()) {
            case NORMALIZE: {
                return jdbcTypeRegistry.getDescriptor(93);
            }
            case NORMALIZE_UTC: {
                return jdbcTypeRegistry.getDescriptor(3003);
            }
        }
        return null;
    }

    private static void addFallbackIfNecessary(JdbcTypeRegistry jdbcTypeRegistry, int typeCode, int fallbackTypeCode) {
        if (!jdbcTypeRegistry.hasRegisteredDescriptor(typeCode)) {
            jdbcTypeRegistry.addDescriptor(typeCode, jdbcTypeRegistry.getDescriptor(fallbackTypeCode));
        }
    }
}

