/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.spi;

public enum AccessType {
    DEFAULT("property"),
    PROPERTY("property"),
    FIELD("field"),
    RECORD("record");

    private final String accessType;

    private AccessType(String type) {
        this.accessType = type;
    }

    public String getType() {
        return this.accessType;
    }

    public static AccessType getAccessStrategy(String externalName) {
        if (externalName == null) {
            return DEFAULT;
        }
        if (FIELD.getType().equals(externalName)) {
            return FIELD;
        }
        if (PROPERTY.getType().equals(externalName)) {
            return PROPERTY;
        }
        if (RECORD.getType().equals(externalName)) {
            return RECORD;
        }
        return DEFAULT;
    }

    public static AccessType getAccessStrategy(jakarta.persistence.AccessType type) {
        if (jakarta.persistence.AccessType.PROPERTY.equals((Object)type)) {
            return PROPERTY;
        }
        if (jakarta.persistence.AccessType.FIELD.equals((Object)type)) {
            return FIELD;
        }
        return DEFAULT;
    }
}

