/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.dialect.identity.H2IdentityColumnSupport;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.cte.CteContainer;
import org.hibernate.sql.ast.tree.cte.CteTableGroup;
import org.hibernate.sql.ast.tree.expression.BinaryArithmeticExpression;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.expression.SqlTupleContainer;
import org.hibernate.sql.ast.tree.expression.Summarization;
import org.hibernate.sql.ast.tree.from.QueryPartTableReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.BooleanExpressionPredicate;
import org.hibernate.sql.ast.tree.predicate.InSubQueryPredicate;
import org.hibernate.sql.ast.tree.predicate.LikePredicate;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.SelectClause;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.sql.model.internal.TableInsertStandard;

public class H2SqlAstTranslator<T extends JdbcOperation>
extends AbstractSqlAstTranslator<T> {
    private boolean renderAsArray;

    public H2SqlAstTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
        super(sessionFactory, statement);
    }

    @Override
    public void visitStandardTableInsert(TableInsertStandard tableInsert) {
        if (CollectionHelper.isNotEmpty(tableInsert.getReturningColumns())) {
            this.visitReturningInsertStatement(tableInsert);
        } else {
            super.visitStandardTableInsert(tableInsert);
        }
    }

    public void visitReturningInsertStatement(TableInsertStandard tableInsert) {
        assert (tableInsert.getReturningColumns() != null && !tableInsert.getReturningColumns().isEmpty());
        H2IdentityColumnSupport identitySupport = (H2IdentityColumnSupport)this.getSessionFactory().getJdbcServices().getDialect().getIdentityColumnSupport();
        identitySupport.render(tableInsert, this::appendSql, columnReference -> columnReference.accept(this), () -> super.visitStandardTableInsert(tableInsert), this.getSessionFactory());
    }

    @Override
    protected void visitReturningColumns(List<ColumnReference> returningColumns) {
    }

    @Override
    public void visitCteContainer(CteContainer cteContainer) {
        this.withParameterRenderingMode(SqlAstNodeRenderingMode.INLINE_PARAMETERS, () -> super.visitCteContainer(cteContainer));
    }

    @Override
    protected boolean needsCteInlining() {
        return true;
    }

    @Override
    protected boolean shouldInlineCte(TableGroup tableGroup) {
        return tableGroup instanceof CteTableGroup && !this.getCteStatement(tableGroup.getPrimaryTableReference().getTableId()).isRecursive();
    }

    @Override
    protected boolean supportsWithClauseInSubquery() {
        return false;
    }

    @Override
    protected boolean supportsRowConstructor() {
        return this.getDialect().getVersion().isSameOrAfter(2);
    }

    @Override
    protected boolean supportsArrayConstructor() {
        return this.getDialect().getVersion().isSameOrAfter(2);
    }

    @Override
    protected String getArrayContainsFunction() {
        return "array_contains";
    }

    @Override
    protected void renderExpressionAsClauseItem(Expression expression) {
        expression.accept(this);
    }

    @Override
    public void visitBooleanExpressionPredicate(BooleanExpressionPredicate booleanExpressionPredicate) {
        boolean isNegated = booleanExpressionPredicate.isNegated();
        if (isNegated) {
            this.appendSql("not(");
        }
        booleanExpressionPredicate.getExpression().accept(this);
        if (isNegated) {
            this.appendSql(')');
        }
    }

    @Override
    public void visitOffsetFetchClause(QueryPart queryPart) {
        if (this.isRowsOnlyFetchClauseType(queryPart)) {
            if (this.supportsOffsetFetchClause()) {
                this.renderOffsetFetchClause(queryPart, true);
            } else {
                this.renderLimitOffsetClause(queryPart);
            }
        } else if (this.supportsOffsetFetchClausePercentWithTies()) {
            this.renderOffsetFetchClause(queryPart, true);
        } else {
            throw new IllegalArgumentException("Can't emulate fetch clause type: " + queryPart.getFetchClauseType());
        }
    }

    @Override
    protected void renderSelectTupleComparison(List<SqlSelection> lhsExpressions, SqlTuple tuple, ComparisonOperator operator) {
        this.emulateSelectTupleComparison(lhsExpressions, tuple.getExpressions(), operator, true);
    }

    @Override
    public void visitInSubQueryPredicate(InSubQueryPredicate inSubQueryPredicate) {
        SqlTuple lhsTuple;
        if (this.getDialect().getVersion().isBefore(1, 4, 200) && (lhsTuple = SqlTupleContainer.getSqlTuple(inSubQueryPredicate.getTestExpression())) != null && lhsTuple.getExpressions().size() != 1) {
            inSubQueryPredicate.getTestExpression().accept(this);
            if (inSubQueryPredicate.isNegated()) {
                this.appendSql(" not");
            }
            this.appendSql(" in");
            boolean renderAsArray = this.renderAsArray;
            this.renderAsArray = true;
            inSubQueryPredicate.getSubQuery().accept(this);
            this.renderAsArray = renderAsArray;
        } else {
            super.visitInSubQueryPredicate(inSubQueryPredicate);
        }
    }

    @Override
    protected void visitSqlSelections(SelectClause selectClause) {
        boolean renderAsArray = this.renderAsArray;
        this.renderAsArray = false;
        if (renderAsArray) {
            this.append('(');
        }
        super.visitSqlSelections(selectClause);
        if (renderAsArray) {
            this.append(')');
        }
    }

    @Override
    protected void renderPartitionItem(Expression expression) {
        if (expression instanceof Literal) {
            this.appendSql("'0' || '0'");
        } else {
            if (expression instanceof Summarization) {
                throw new UnsupportedOperationException("Summarization is not supported by DBMS");
            }
            expression.accept(this);
        }
    }

    @Override
    public void visitBinaryArithmeticExpression(BinaryArithmeticExpression arithmeticExpression) {
        this.appendSql('(');
        this.render(arithmeticExpression.getLeftHandOperand(), SqlAstNodeRenderingMode.NO_PLAIN_PARAMETER);
        this.appendSql(arithmeticExpression.getOperator().getOperatorSqlTextString());
        this.render(arithmeticExpression.getRightHandOperand(), SqlAstNodeRenderingMode.NO_PLAIN_PARAMETER);
        this.appendSql(')');
    }

    @Override
    protected boolean renderPrimaryTableReference(TableGroup tableGroup, LockMode lockMode) {
        TableReference tableRef = tableGroup.getPrimaryTableReference();
        if (tableRef instanceof QueryPartTableReference || tableRef.getTableId().startsWith("(select")) {
            boolean realTableGroup;
            boolean bl = realTableGroup = tableGroup.isRealTableGroup() && (CollectionHelper.isNotEmpty(tableGroup.getTableReferenceJoins()) || this.hasNestedTableGroupsToRender(tableGroup.getNestedTableGroupJoins()));
            if (realTableGroup) {
                this.appendSql("dual cross join ");
            }
        }
        return super.renderPrimaryTableReference(tableGroup, lockMode);
    }

    @Override
    public void visitLikePredicate(LikePredicate likePredicate) {
        super.visitLikePredicate(likePredicate);
        if (likePredicate.getEscapeCharacter() == null) {
            this.appendSql(" escape ''");
        }
    }

    @Override
    protected boolean supportsRowValueConstructorSyntax() {
        return true;
    }

    @Override
    protected boolean supportsRowValueConstructorSyntaxInInList() {
        return true;
    }

    @Override
    protected boolean supportsRowValueConstructorSyntaxInQuantifiedPredicates() {
        return true;
    }

    @Override
    protected boolean supportsRowValueConstructorDistinctFromSyntax() {
        return this.getDialect().getVersion().isSameOrAfter(1, 4, 200);
    }

    @Override
    protected boolean supportsNullPrecedence() {
        return this.getClauseStack().getCurrent() != Clause.WITHIN_GROUP || this.getDialect().getVersion().isSameOrAfter(2);
    }

    @Override
    protected String getFromDual() {
        return " from dual";
    }

    private boolean supportsOffsetFetchClause() {
        return true;
    }

    private boolean supportsOffsetFetchClausePercentWithTies() {
        return this.getDialect().getVersion().isSameOrAfter(1, 4, 198);
    }
}

