/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.sql.SQLException;
import org.hibernate.Internal;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.AggregateJdbcType;

@Internal
public class StructHelper {
    public static Object[] getAttributeValues(EmbeddableMappingType embeddableMappingType, Object[] rawJdbcValues, WrapperOptions options) throws SQLException {
        int numberOfAttributeMappings = embeddableMappingType.getNumberOfAttributeMappings();
        Object[] attributeValues = numberOfAttributeMappings != rawJdbcValues.length ? new Object[numberOfAttributeMappings] : rawJdbcValues;
        int jdbcIndex = 0;
        for (int i = 0; i < numberOfAttributeMappings; ++i) {
            AttributeMapping attributeMapping = embeddableMappingType.getAttributeMapping(i);
            jdbcIndex += StructHelper.injectAttributeValue(attributeMapping, attributeValues, i, rawJdbcValues, jdbcIndex, options);
        }
        return attributeValues;
    }

    private static int injectAttributeValue(AttributeMapping attributeMapping, Object[] attributeValues, int attributeIndex, Object[] rawJdbcValues, int jdbcIndex, WrapperOptions options) throws SQLException {
        int jdbcValueCount;
        MappingType mappedType = attributeMapping.getMappedType();
        Object rawJdbcValue = rawJdbcValues[jdbcIndex];
        if (mappedType instanceof EmbeddableMappingType) {
            EmbeddableMappingType embeddableMappingType = (EmbeddableMappingType)mappedType;
            if (embeddableMappingType.getAggregateMapping() != null) {
                jdbcValueCount = 1;
                attributeValues[attributeIndex] = rawJdbcValue;
            } else {
                jdbcValueCount = embeddableMappingType.getJdbcValueCount();
                Object[] subJdbcValues = new Object[jdbcValueCount];
                System.arraycopy(rawJdbcValues, jdbcIndex, subJdbcValues, 0, subJdbcValues.length);
                Object[] subValues = StructHelper.getAttributeValues(embeddableMappingType, subJdbcValues, options);
                attributeValues[attributeIndex] = embeddableMappingType.getRepresentationStrategy().getInstantiator().instantiate(() -> subValues, embeddableMappingType.findContainingEntityMapping().getEntityPersister().getFactory());
            }
        } else {
            assert (attributeMapping.getJdbcTypeCount() == 1);
            jdbcValueCount = 1;
            JdbcMapping jdbcMapping = attributeMapping.getJdbcMappings().get(0);
            Object jdbcValue = jdbcMapping.getJdbcJavaType().wrap(rawJdbcValue, options);
            attributeValues[attributeIndex] = jdbcMapping.convertToDomainValue(jdbcValue);
        }
        return jdbcValueCount;
    }

    public static Object[] getJdbcValues(EmbeddableMappingType embeddableMappingType, int[] orderMapping, Object[] attributeValues, WrapperOptions options) throws SQLException {
        int jdbcValueCount = embeddableMappingType.getJdbcValueCount();
        Object[] jdbcValues = jdbcValueCount != attributeValues.length || orderMapping != null ? new Object[jdbcValueCount] : attributeValues;
        int jdbcIndex = 0;
        for (int i = 0; i < attributeValues.length; ++i) {
            int attributeIndex = orderMapping == null ? i : orderMapping[i];
            jdbcIndex += StructHelper.injectJdbcValue(embeddableMappingType.getAttributeMapping(attributeIndex), attributeValues, attributeIndex, jdbcValues, jdbcIndex, options);
        }
        assert (jdbcIndex == jdbcValueCount);
        return jdbcValues;
    }

    private static int injectJdbcValue(AttributeMapping attributeMapping, Object[] attributeValues, int attributeIndex, Object[] jdbcValues, int jdbcIndex, WrapperOptions options) throws SQLException {
        int jdbcValueCount;
        MappingType mappedType = attributeMapping.getMappedType();
        if (mappedType instanceof EmbeddableMappingType) {
            EmbeddableMappingType embeddableMappingType = (EmbeddableMappingType)mappedType;
            if (embeddableMappingType.getAggregateMapping() != null) {
                AggregateJdbcType aggregateJdbcType = (AggregateJdbcType)embeddableMappingType.getAggregateMapping().getJdbcMapping().getJdbcType();
                jdbcValueCount = 1;
                jdbcValues[jdbcIndex] = aggregateJdbcType.createJdbcValue(attributeValues[attributeIndex], options);
            } else {
                jdbcValueCount = embeddableMappingType.getJdbcValueCount();
                int numberOfAttributeMappings = embeddableMappingType.getNumberOfAttributeMappings();
                Object[] subValues = embeddableMappingType.getValues(attributeValues[attributeIndex]);
                int offset = 0;
                for (int i = 0; i < numberOfAttributeMappings; ++i) {
                    offset += StructHelper.injectJdbcValue(embeddableMappingType.getAttributeMapping(i), subValues, i, jdbcValues, jdbcIndex + offset, options);
                }
                assert (offset == jdbcValueCount);
            }
        } else {
            assert (attributeMapping.getJdbcTypeCount() == 1);
            jdbcValueCount = 1;
            JdbcMapping jdbcMapping = attributeMapping.getJdbcMappings().get(0);
            JavaType<Object> relationalJavaType = jdbcMapping.getValueConverter() == null ? jdbcMapping.getJdbcJavaType() : jdbcMapping.getValueConverter().getRelationalJavaType();
            Class<?> preferredJavaTypeClass = jdbcMapping.getJdbcType().getPreferredJavaTypeClass(options);
            jdbcValues[jdbcIndex] = preferredJavaTypeClass == null ? relationalJavaType.wrap(jdbcMapping.convertToRelationalValue(attributeValues[attributeIndex]), options) : relationalJavaType.unwrap(jdbcMapping.convertToRelationalValue(attributeValues[attributeIndex]), preferredJavaTypeClass, options);
        }
        return jdbcValueCount;
    }

    public static void orderJdbcValues(EmbeddableMappingType embeddableMappingType, int[] inverseMapping, Object[] sourceJdbcValues, Object[] targetJdbcValues) {
        int numberOfAttributeMappings = embeddableMappingType.getNumberOfAttributeMappings();
        int targetJdbcOffset = 0;
        for (int i = 0; i < numberOfAttributeMappings; ++i) {
            int j;
            AttributeMapping attributeMapping = embeddableMappingType.getAttributeMapping(i);
            MappingType mappedType = attributeMapping.getMappedType();
            int jdbcValueCount = StructHelper.getJdbcValueCount(mappedType);
            int attributeIndex = inverseMapping[i];
            int sourceJdbcIndex = 0;
            for (j = 0; j < attributeIndex; ++j) {
                sourceJdbcIndex += StructHelper.getJdbcValueCount(embeddableMappingType.getAttributeMapping(j).getMappedType());
            }
            for (j = 0; j < jdbcValueCount; ++j) {
                targetJdbcValues[targetJdbcOffset++] = sourceJdbcValues[sourceJdbcIndex + j];
            }
        }
    }

    public static int getJdbcValueCount(MappingType mappedType) {
        EmbeddableMappingType subMappingType;
        int jdbcValueCount = mappedType instanceof EmbeddableMappingType ? ((subMappingType = (EmbeddableMappingType)mappedType).getAggregateMapping() != null ? 1 : subMappingType.getJdbcValueCount()) : 1;
        return jdbcValueCount;
    }
}

