/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.util.List;
import java.util.Locale;
import org.hibernate.QueryException;
import org.hibernate.query.sqm.function.AbstractSqmSelfRenderingFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.ArgumentTypesValidator;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionArgumentTypeResolvers;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.expression.SqmLiteral;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.QueryLiteral;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.spi.TypeConfiguration;

public class ChrLiteralEmulation
extends AbstractSqmSelfRenderingFunctionDescriptor {
    public ChrLiteralEmulation(TypeConfiguration typeConfiguration) {
        super("chr", new ArgumentTypesValidator(StandardArgumentsValidators.composite(StandardArgumentsValidators.exactly(1), (arguments, functionName, queryEngine) -> {
            if (!(arguments.get(0) instanceof SqmLiteral)) {
                throw new QueryException(String.format(Locale.ROOT, "Emulation of function chr() supports only integer literals, but %s argument given", ((SqmTypedNode)arguments.get(0)).getClass().getName()));
            }
        }), FunctionParameterType.INTEGER), StandardFunctionReturnTypeResolvers.invariant(typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.CHARACTER)), StandardFunctionArgumentTypeResolvers.invariant(typeConfiguration, FunctionParameterType.INTEGER));
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> arguments, SqlAstTranslator<?> walker) {
        QueryLiteral literal = (QueryLiteral)arguments.get(0);
        sqlAppender.appendSql('\'');
        sqlAppender.appendSql((char)((Number)literal.getLiteralValue()).intValue());
        sqlAppender.appendSql('\'');
    }
}

