/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.mutation.internal;

import java.sql.SQLException;
import org.hibernate.engine.jdbc.mutation.JdbcValueBindings;
import org.hibernate.engine.jdbc.mutation.MutationExecutor;
import org.hibernate.engine.jdbc.mutation.OperationResultChecker;
import org.hibernate.engine.jdbc.mutation.TableInclusionChecker;
import org.hibernate.engine.jdbc.mutation.group.PreparedStatementDetails;
import org.hibernate.engine.jdbc.mutation.internal.ModelMutationHelper;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.sql.model.ModelMutationLogging;
import org.hibernate.sql.model.TableMapping;
import org.hibernate.sql.model.ValuesAnalysis;

public abstract class AbstractMutationExecutor
implements MutationExecutor {
    @Override
    public final Object execute(Object modelReference, ValuesAnalysis valuesAnalysis, TableInclusionChecker inclusionChecker, OperationResultChecker resultChecker, SharedSessionContractImplementor session) {
        this.performNonBatchedOperations(valuesAnalysis, inclusionChecker, resultChecker, session);
        this.performSelfExecutingOperations(valuesAnalysis, inclusionChecker, session);
        this.performBatchedOperations(valuesAnalysis, inclusionChecker);
        return null;
    }

    protected void performNonBatchedOperations(ValuesAnalysis valuesAnalysis, TableInclusionChecker inclusionChecker, OperationResultChecker resultChecker, SharedSessionContractImplementor session) {
    }

    protected void performSelfExecutingOperations(ValuesAnalysis valuesAnalysis, TableInclusionChecker inclusionChecker, SharedSessionContractImplementor session) {
    }

    protected void performBatchedOperations(ValuesAnalysis valuesAnalysis, TableInclusionChecker inclusionChecker) {
    }

    protected void performNonBatchedMutation(PreparedStatementDetails statementDetails, JdbcValueBindings valueBindings, TableInclusionChecker inclusionChecker, OperationResultChecker resultChecker, SharedSessionContractImplementor session) {
        if (statementDetails == null) {
            return;
        }
        TableMapping tableDetails = statementDetails.getMutatingTableDetails();
        if (inclusionChecker != null && !inclusionChecker.include(tableDetails)) {
            if (ModelMutationLogging.MODEL_MUTATION_LOGGER_TRACE_ENABLED) {
                ModelMutationLogging.MODEL_MUTATION_LOGGER.tracef("Skipping execution of secondary insert : %s", (Object)tableDetails.getTableName());
            }
            return;
        }
        session.getJdbcServices().getSqlStatementLogger().logStatement(statementDetails.getSqlString());
        valueBindings.beforeStatement(statementDetails, session);
        try {
            int affectedRowCount = session.getJdbcCoordinator().getResultSetReturn().executeUpdate(statementDetails.getStatement(), statementDetails.getSqlString());
            if (affectedRowCount == 0 && tableDetails.isOptional()) {
                return;
            }
            ModelMutationHelper.checkResults(resultChecker, statementDetails, affectedRowCount, -1);
        }
        catch (SQLException e) {
            throw session.getJdbcServices().getSqlExceptionHelper().convert(e, String.format("Unable to execute mutation PreparedStatement against table `%s`", tableDetails.getTableName()), statementDetails.getSqlString());
        }
        finally {
            if (statementDetails.getStatement() != null) {
                statementDetails.releaseStatement(session);
            }
            valueBindings.afterStatement(tableDetails, session);
        }
    }
}

