/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.mutation.internal;

import java.util.Locale;
import org.hibernate.engine.jdbc.mutation.JdbcValueBindings;
import org.hibernate.engine.jdbc.mutation.ParameterUsage;
import org.hibernate.engine.jdbc.mutation.group.PreparedStatementDetails;
import org.hibernate.engine.jdbc.mutation.internal.AbstractMutationExecutor;
import org.hibernate.engine.jdbc.mutation.internal.JdbcValueBindingsImpl;
import org.hibernate.engine.jdbc.mutation.internal.PreparedStatementGroupSingleTable;
import org.hibernate.sql.model.PreparableMutationOperation;
import org.hibernate.sql.model.jdbc.JdbcValueDescriptor;

public abstract class AbstractSingleMutationExecutor
extends AbstractMutationExecutor {
    private final PreparableMutationOperation mutationOperation;
    private final JdbcValueBindingsImpl valueBindings;

    public AbstractSingleMutationExecutor(PreparableMutationOperation mutationOperation) {
        this.mutationOperation = mutationOperation;
        this.valueBindings = new JdbcValueBindingsImpl(mutationOperation.getMutationType(), mutationOperation.getMutationTarget(), this::findJdbcValueDescriptor);
    }

    protected PreparableMutationOperation getMutationOperation() {
        return this.mutationOperation;
    }

    protected abstract PreparedStatementGroupSingleTable getStatementGroup();

    @Override
    public PreparedStatementDetails getPreparedStatementDetails(String tableName) {
        PreparedStatementDetails statementDetails = this.getStatementGroup().getSingleStatementDetails();
        assert (statementDetails.getMutatingTableDetails().getTableName().equals(tableName));
        return statementDetails;
    }

    private JdbcValueDescriptor findJdbcValueDescriptor(String tableName, String columnName, ParameterUsage usage) {
        assert (this.mutationOperation.getTableDetails().getTableName().equals(tableName)) : String.format(Locale.ROOT, "table names did not match : `%s` & `%s`", tableName, this.mutationOperation.getTableDetails().getTableName());
        return this.mutationOperation.findValueDescriptor(columnName, usage);
    }

    @Override
    public JdbcValueBindings getJdbcValueBindings() {
        return this.valueBindings;
    }
}

