/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.mutation.internal;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.hibernate.engine.jdbc.mutation.JdbcValueBindings;
import org.hibernate.engine.jdbc.mutation.MutationExecutor;
import org.hibernate.engine.jdbc.mutation.OperationResultChecker;
import org.hibernate.engine.jdbc.mutation.ParameterUsage;
import org.hibernate.engine.jdbc.mutation.TableInclusionChecker;
import org.hibernate.engine.jdbc.mutation.group.PreparedStatementDetails;
import org.hibernate.engine.jdbc.mutation.group.PreparedStatementGroup;
import org.hibernate.engine.jdbc.mutation.internal.JdbcValueBindingsImpl;
import org.hibernate.engine.jdbc.mutation.internal.ModelMutationHelper;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.id.insert.InsertGeneratedIdentifierDelegate;
import org.hibernate.persister.entity.mutation.EntityMutationTarget;
import org.hibernate.persister.entity.mutation.EntityTableMapping;
import org.hibernate.sql.model.ModelMutationLogging;
import org.hibernate.sql.model.MutationOperation;
import org.hibernate.sql.model.MutationOperationGroup;
import org.hibernate.sql.model.MutationType;
import org.hibernate.sql.model.PreparableMutationOperation;
import org.hibernate.sql.model.SelfExecutingUpdateOperation;
import org.hibernate.sql.model.ValuesAnalysis;
import org.hibernate.sql.model.jdbc.JdbcValueDescriptor;

public class MutationExecutorPostInsert
implements MutationExecutor {
    private final EntityMutationTarget mutationTarget;
    private final MutationOperationGroup mutationOperationGroup;
    private final PreparedStatementDetails identityInsertStatementDetails;
    private final PreparedStatementGroup secondaryTablesStatementGroup;
    private final JdbcValueBindingsImpl valueBindings;

    public MutationExecutorPostInsert(MutationOperationGroup mutationOperationGroup, SharedSessionContractImplementor session) {
        this.mutationTarget = (EntityMutationTarget)mutationOperationGroup.getMutationTarget();
        this.valueBindings = new JdbcValueBindingsImpl(MutationType.INSERT, this.mutationTarget, this::findJdbcValueDescriptor);
        this.mutationOperationGroup = mutationOperationGroup;
        PreparableMutationOperation identityInsertOperation = (PreparableMutationOperation)mutationOperationGroup.getOperation(this.mutationTarget.getIdentifierTableName());
        this.identityInsertStatementDetails = ModelMutationHelper.identityPreparation(identityInsertOperation, session);
        ArrayList<PreparableMutationOperation> secondaryTableMutations = null;
        List operations = mutationOperationGroup.getOperations();
        for (int i = 0; i < operations.size(); ++i) {
            MutationOperation operation = (MutationOperation)operations.get(i);
            if (operation.getTableDetails().isIdentifierTable()) continue;
            assert (!(operation instanceof SelfExecutingUpdateOperation));
            PreparableMutationOperation preparableMutationOperation = (PreparableMutationOperation)operation;
            if (secondaryTableMutations == null) {
                secondaryTableMutations = new ArrayList<PreparableMutationOperation>();
            }
            secondaryTableMutations.add(preparableMutationOperation);
        }
        this.secondaryTablesStatementGroup = ModelMutationHelper.toPreparedStatementGroup(MutationType.INSERT, this.mutationTarget, secondaryTableMutations, session);
    }

    @Override
    public JdbcValueBindings getJdbcValueBindings() {
        return this.valueBindings;
    }

    private JdbcValueDescriptor findJdbcValueDescriptor(String tableName, String columnName, ParameterUsage usage) {
        Object operation = this.mutationOperationGroup.getOperation(tableName);
        if (operation == null) {
            return null;
        }
        return operation.getJdbcValueDescriptor(columnName, usage);
    }

    @Override
    public PreparedStatementDetails getPreparedStatementDetails(String tableName) {
        if (this.mutationTarget.getIdentifierTableName().equals(tableName)) {
            return this.identityInsertStatementDetails;
        }
        return this.secondaryTablesStatementGroup.getPreparedStatementDetails(tableName);
    }

    @Override
    public Object execute(Object modelReference, ValuesAnalysis valuesAnalysis, TableInclusionChecker inclusionChecker, OperationResultChecker resultChecker, SharedSessionContractImplementor session) {
        InsertGeneratedIdentifierDelegate identityHandler = this.mutationTarget.getIdentityInsertDelegate();
        Object id = identityHandler.performInsert(this.identityInsertStatementDetails, this.valueBindings, modelReference, session);
        if (ModelMutationLogging.MODEL_MUTATION_LOGGER_TRACE_ENABLED) {
            ModelMutationLogging.MODEL_MUTATION_LOGGER.tracef("Post-insert generated value : `%s` (%s)", id, (Object)this.mutationTarget.getNavigableRole().getFullPath());
        }
        if (this.secondaryTablesStatementGroup != null) {
            this.secondaryTablesStatementGroup.forEachStatement((tableName, statementDetails) -> this.executeWithId(id, (String)tableName, (PreparedStatementDetails)statementDetails, inclusionChecker, resultChecker, session));
        }
        return id;
    }

    private void executeWithId(Object id, String tableName, PreparedStatementDetails statementDetails, TableInclusionChecker inclusionChecker, OperationResultChecker resultChecker, SharedSessionContractImplementor session) {
        if (statementDetails == null) {
            return;
        }
        EntityTableMapping tableDetails = (EntityTableMapping)statementDetails.getMutatingTableDetails();
        assert (!tableDetails.isIdentifierTable());
        if (inclusionChecker != null && !inclusionChecker.include(tableDetails)) {
            if (ModelMutationLogging.MODEL_MUTATION_LOGGER_TRACE_ENABLED) {
                ModelMutationLogging.MODEL_MUTATION_LOGGER.tracef("Skipping execution of secondary insert : %s", (Object)tableDetails.getTableName());
            }
            return;
        }
        statementDetails.resolveStatement();
        tableDetails.getKeyMapping().breakDownKeyJdbcValues(id, (jdbcValue, columnMapping) -> this.valueBindings.bindValue(jdbcValue, tableName, columnMapping.getColumnName(), ParameterUsage.SET, session), session);
        session.getJdbcServices().getSqlStatementLogger().logStatement(statementDetails.getSqlString());
        this.valueBindings.beforeStatement(statementDetails, session);
        try {
            int affectedRowCount = session.getJdbcCoordinator().getResultSetReturn().executeUpdate(statementDetails.getStatement(), statementDetails.getSqlString());
            ModelMutationHelper.checkResults(resultChecker, statementDetails, affectedRowCount, -1);
        }
        catch (SQLException e) {
            throw session.getJdbcServices().getSqlExceptionHelper().convert(e, "Unable to execute mutation PreparedStatement against table `" + tableName + "`", statementDetails.getSqlString());
        }
    }

    @Override
    public void release() {
        this.secondaryTablesStatementGroup.release();
    }

    public String toString() {
        return String.format(Locale.ROOT, "MutationExecutorPostInsert(`%s`)", this.mutationTarget.getNavigableRole().getFullPath());
    }
}

