/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.mutation.internal;

import org.hibernate.engine.jdbc.batch.spi.Batch;
import org.hibernate.engine.jdbc.batch.spi.BatchKey;
import org.hibernate.engine.jdbc.mutation.TableInclusionChecker;
import org.hibernate.engine.jdbc.mutation.internal.AbstractSingleMutationExecutor;
import org.hibernate.engine.jdbc.mutation.internal.PreparedStatementGroupSingleTable;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.sql.model.PreparableMutationOperation;
import org.hibernate.sql.model.ValuesAnalysis;

public class MutationExecutorSingleBatched
extends AbstractSingleMutationExecutor {
    private final int batchSize;
    private final SharedSessionContractImplementor session;
    private final BatchKey batchKey;
    private Batch batch;

    public MutationExecutorSingleBatched(PreparableMutationOperation mutationOperation, BatchKey batchKey, int batchSize, SharedSessionContractImplementor session) {
        super(mutationOperation);
        this.batchSize = batchSize;
        this.session = session;
        this.batchKey = batchKey;
    }

    @Override
    protected PreparedStatementGroupSingleTable getStatementGroup() {
        return (PreparedStatementGroupSingleTable)this.resolveBatch().getStatementGroup();
    }

    private Batch resolveBatch() {
        if (this.batch == null) {
            this.batch = this.session.getJdbcCoordinator().getBatch(this.batchKey, this.batchSize, () -> new PreparedStatementGroupSingleTable(this.getMutationOperation(), this.session));
            assert (this.batch != null);
        }
        return this.batch;
    }

    @Override
    protected void performBatchedOperations(ValuesAnalysis valuesAnalysis, TableInclusionChecker inclusionChecker) {
        this.resolveBatch().addToBatch(this.getJdbcValueBindings(), inclusionChecker);
    }

    @Override
    public void release() {
    }
}

