/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.spi;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.engine.spi.BatchFetchQueue;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.entity.LoadingEntityEntry;

public class SubselectFetch {
    private final EntityValuedModelPart entityModelPart;
    private final QuerySpec loadingSqlAst;
    private final TableGroup ownerTableGroup;
    private final List<JdbcParameter> loadingJdbcParameters;
    private final JdbcParameterBindings loadingJdbcParameterBindings;
    private final Set<EntityKey> resultingEntityKeys;
    private static final RegistrationHandler NO_OP_REG_HANDLER = new RegistrationHandler(){

        @Override
        public void addKey(EntityKey key, LoadingEntityEntry entry) {
        }
    };

    public SubselectFetch(EntityValuedModelPart entityModelPart, QuerySpec loadingSqlAst, TableGroup ownerTableGroup, List<JdbcParameter> loadingJdbcParameters, JdbcParameterBindings loadingJdbcParameterBindings, Set<EntityKey> resultingEntityKeys) {
        this.entityModelPart = entityModelPart;
        this.loadingSqlAst = loadingSqlAst;
        this.ownerTableGroup = ownerTableGroup;
        this.loadingJdbcParameters = loadingJdbcParameters;
        this.loadingJdbcParameterBindings = loadingJdbcParameterBindings;
        this.resultingEntityKeys = resultingEntityKeys;
    }

    public EntityValuedModelPart getEntityModelPart() {
        return this.entityModelPart;
    }

    public List<JdbcParameter> getLoadingJdbcParameters() {
        return this.loadingJdbcParameters;
    }

    public QuerySpec getLoadingSqlAst() {
        return this.loadingSqlAst;
    }

    public TableGroup getOwnerTableGroup() {
        return this.ownerTableGroup;
    }

    public JdbcParameterBindings getLoadingJdbcParameterBindings() {
        return this.loadingJdbcParameterBindings;
    }

    public Set<EntityKey> getResultingEntityKeys() {
        return this.resultingEntityKeys;
    }

    public String toString() {
        return "SubselectFetch(" + this.entityModelPart.getEntityMappingType().getEntityName() + ")";
    }

    public static RegistrationHandler createRegistrationHandler(BatchFetchQueue batchFetchQueue, SelectStatement sqlAst, TableGroup tableGroup, List<JdbcParameter> jdbcParameters, JdbcParameterBindings jdbcParameterBindings) {
        return new StandardRegistrationHandler(batchFetchQueue, sqlAst, tableGroup, jdbcParameters, jdbcParameterBindings);
    }

    public static RegistrationHandler createRegistrationHandler(BatchFetchQueue batchFetchQueue, SelectStatement sqlAst, List<JdbcParameter> jdbcParameters, JdbcParameterBindings jdbcParameterBindings) {
        List<TableGroup> roots = sqlAst.getQuerySpec().getFromClause().getRoots();
        if (roots.isEmpty()) {
            return NO_OP_REG_HANDLER;
        }
        return SubselectFetch.createRegistrationHandler(batchFetchQueue, sqlAst, roots.get(0), jdbcParameters, jdbcParameterBindings);
    }

    public static class StandardRegistrationHandler
    implements RegistrationHandler {
        private final BatchFetchQueue batchFetchQueue;
        private final SelectStatement loadingSqlAst;
        private final TableGroup ownerTableGroup;
        private final List<JdbcParameter> loadingJdbcParameters;
        private final JdbcParameterBindings loadingJdbcParameterBindings;
        private final Map<NavigablePath, SubselectFetch> subselectFetches = new HashMap<NavigablePath, SubselectFetch>();

        private StandardRegistrationHandler(BatchFetchQueue batchFetchQueue, SelectStatement loadingSqlAst, TableGroup ownerTableGroup, List<JdbcParameter> loadingJdbcParameters, JdbcParameterBindings loadingJdbcParameterBindings) {
            this.batchFetchQueue = batchFetchQueue;
            this.loadingSqlAst = loadingSqlAst;
            this.ownerTableGroup = ownerTableGroup;
            this.loadingJdbcParameters = loadingJdbcParameters;
            this.loadingJdbcParameterBindings = loadingJdbcParameterBindings;
        }

        @Override
        public void addKey(EntityKey key, LoadingEntityEntry entry) {
            if (!entry.getDescriptor().hasSubselectLoadableCollections()) {
                return;
            }
            if (this.shouldAddSubselectFetch(entry)) {
                SubselectFetch subselectFetch = this.subselectFetches.computeIfAbsent(entry.getEntityInitializer().getNavigablePath(), navigablePath -> new SubselectFetch(null, this.loadingSqlAst.getQuerySpec(), this.ownerTableGroup, this.loadingJdbcParameters, this.loadingJdbcParameterBindings, new HashSet<EntityKey>()));
                subselectFetch.resultingEntityKeys.add(key);
                this.batchFetchQueue.addSubselect(key, subselectFetch);
            }
        }

        private boolean shouldAddSubselectFetch(LoadingEntityEntry entry) {
            if (entry.getEntityInitializer().isEntityResultInitializer()) {
                return true;
            }
            NavigablePath entityInitializerParent = entry.getEntityInitializer().getNavigablePath().getParent();
            for (DomainResult<?> domainResult : this.loadingSqlAst.getDomainResultDescriptors()) {
                if (!domainResult.getNavigablePath().equals(entityInitializerParent)) continue;
                return true;
            }
            return false;
        }
    }

    public static interface RegistrationHandler {
        public void addKey(EntityKey var1, LoadingEntityEntry var2);
    }
}

