/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.insert;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import org.hibernate.MappingException;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.mutation.JdbcValueBindings;
import org.hibernate.engine.jdbc.mutation.group.PreparedStatementDetails;
import org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.jdbc.spi.MutationStatementPreparer;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.generator.OnExecutionGenerator;
import org.hibernate.id.IdentifierGeneratorHelper;
import org.hibernate.id.PostInsertIdentityPersister;
import org.hibernate.id.insert.AbstractReturningDelegate;
import org.hibernate.id.insert.IdentifierGeneratingInsert;
import org.hibernate.jdbc.Expectation;
import org.hibernate.metamodel.mapping.BasicEntityIdentifierMapping;
import org.hibernate.sql.model.ast.builder.TableInsertBuilder;
import org.hibernate.sql.model.ast.builder.TableInsertBuilderStandard;

public class GetGeneratedKeysDelegate
extends AbstractReturningDelegate {
    private final PostInsertIdentityPersister persister;
    private final Dialect dialect;
    private final boolean inferredKeys;

    public GetGeneratedKeysDelegate(PostInsertIdentityPersister persister, Dialect dialect, boolean inferredKeys) {
        super(persister);
        this.persister = persister;
        this.dialect = dialect;
        this.inferredKeys = inferredKeys;
    }

    @Override
    @Deprecated
    public IdentifierGeneratingInsert prepareIdentifierGeneratingInsert(SqlStringGenerationContext context) {
        IdentifierGeneratingInsert insert = new IdentifierGeneratingInsert(this.dialect);
        insert.addGeneratedColumns(this.persister.getRootTableKeyColumnNames(), (OnExecutionGenerator)this.persister.getGenerator());
        return insert;
    }

    @Override
    public TableInsertBuilder createTableInsertBuilder(BasicEntityIdentifierMapping identifierMapping, Expectation expectation, SessionFactoryImplementor factory) {
        TableInsertBuilderStandard builder = new TableInsertBuilderStandard(this.persister, this.persister.getIdentifierTableMapping(), factory);
        OnExecutionGenerator generator = (OnExecutionGenerator)this.persister.getGenerator();
        if (generator.referenceColumnsInSql(this.dialect)) {
            String[] columnNames = this.persister.getRootTableKeyColumnNames();
            String[] columnValues = generator.getReferencedColumnValues(this.dialect);
            if (columnValues.length != columnNames.length) {
                throw new MappingException("wrong number of generated columns");
            }
            for (int i = 0; i < columnValues.length; ++i) {
                builder.addKeyColumn(columnNames[i], columnValues[i], identifierMapping.getJdbcMapping());
            }
        }
        return builder;
    }

    @Override
    public PreparedStatement prepareStatement(String insertSql, SharedSessionContractImplementor session) {
        MutationStatementPreparer preparer = session.getJdbcCoordinator().getMutationStatementPreparer();
        return this.inferredKeys ? preparer.prepareStatement(insertSql, 1) : preparer.prepareStatement(insertSql, this.persister.getRootTableKeyColumnNames());
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object performInsert(PreparedStatementDetails insertStatementDetails, JdbcValueBindings jdbcValueBindings, Object entity, SharedSessionContractImplementor session) {
        JdbcServices jdbcServices = session.getJdbcServices();
        JdbcCoordinator jdbcCoordinator = session.getJdbcCoordinator();
        String insertSql = insertStatementDetails.getSqlString();
        jdbcServices.getSqlStatementLogger().logStatement(insertSql);
        PreparedStatement insertStatement = insertStatementDetails.resolveStatement();
        jdbcValueBindings.beforeStatement(insertStatementDetails, session);
        try {
            jdbcCoordinator.getResultSetReturn().executeUpdate(insertStatement, insertSql);
            try {
                ResultSet resultSet = insertStatement.getGeneratedKeys();
                try {
                    Object object = IdentifierGeneratorHelper.getGeneratedIdentity(this.persister.getNavigableRole().getFullPath(), resultSet, this.persister, session);
                    return object;
                }
                catch (SQLException e) {
                    throw jdbcServices.getSqlExceptionHelper().convert(e, () -> String.format(Locale.ROOT, "Unable to extract generated key from generated-key for `%s`", this.persister.getNavigableRole().getFullPath()), insertSql);
                }
                finally {
                    if (resultSet != null) {
                        jdbcCoordinator.getLogicalConnection().getResourceRegistry().release(resultSet, insertStatement);
                    }
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                jdbcCoordinator.getLogicalConnection().getResourceRegistry().release(insertStatement);
            }
        }
        catch (SQLException e) {
            throw jdbcServices.getSqlExceptionHelper().convert(e, "Unable to extract generated-keys ResultSet", insertSql);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object executeAndExtract(String insertSql, PreparedStatement insertStatement, SharedSessionContractImplementor session) {
        JdbcCoordinator jdbcCoordinator = session.getJdbcCoordinator();
        JdbcServices jdbcServices = session.getJdbcServices();
        jdbcCoordinator.getResultSetReturn().executeUpdate(insertStatement, insertSql);
        try {
            ResultSet resultSet = insertStatement.getGeneratedKeys();
            try {
                Object object = IdentifierGeneratorHelper.getGeneratedIdentity(this.persister.getNavigableRole().getFullPath(), resultSet, this.persister, session);
                return object;
            }
            catch (SQLException e) {
                throw jdbcServices.getSqlExceptionHelper().convert(e, "Unable to extract generated key(s) from generated-keys ResultSet", insertSql);
            }
            finally {
                if (resultSet != null) {
                    jdbcCoordinator.getLogicalConnection().getResourceRegistry().release(resultSet, insertStatement);
                }
            }
        }
        catch (SQLException e) {
            throw jdbcServices.getSqlExceptionHelper().convert(e, "Unable to extract generated-keys ResultSet", insertSql);
        }
    }
}

