/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import jakarta.persistence.FlushModeType;
import jakarta.persistence.NamedNativeQuery;
import jakarta.persistence.TransactionRequiredException;
import jakarta.persistence.Tuple;
import jakarta.persistence.criteria.CriteriaDelete;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.CriteriaUpdate;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;
import java.util.function.Function;
import org.hibernate.CacheMode;
import org.hibernate.EntityNameResolver;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.LockMode;
import org.hibernate.SessionEventListener;
import org.hibernate.SessionException;
import org.hibernate.Transaction;
import org.hibernate.UnknownEntityTypeException;
import org.hibernate.cache.spi.CacheTransactionSynchronization;
import org.hibernate.engine.internal.SessionEventListenerManagerImpl;
import org.hibernate.engine.jdbc.LobCreationContext;
import org.hibernate.engine.jdbc.LobCreator;
import org.hibernate.engine.jdbc.connections.spi.JdbcConnectionAccess;
import org.hibernate.engine.jdbc.internal.JdbcCoordinatorImpl;
import org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.ExceptionConverter;
import org.hibernate.engine.spi.SessionEventListenerManager;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.transaction.internal.TransactionImpl;
import org.hibernate.engine.transaction.spi.TransactionImplementor;
import org.hibernate.id.uuid.StandardRandomStrategy;
import org.hibernate.internal.ContextualJdbcConnectionAccess;
import org.hibernate.internal.CoordinatingEntityNameResolver;
import org.hibernate.internal.EmptyInterceptor;
import org.hibernate.internal.EntityManagerMessageLogger;
import org.hibernate.internal.ExceptionConverterImpl;
import org.hibernate.internal.FastSessionServices;
import org.hibernate.internal.HEMLogging;
import org.hibernate.internal.JdbcSessionContextImpl;
import org.hibernate.internal.NonContextualJdbcConnectionAccess;
import org.hibernate.internal.SessionCreationOptions;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.internal.SessionImpl;
import org.hibernate.internal.SharedSessionCreationOptions;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.jdbc.ReturningWork;
import org.hibernate.jdbc.Work;
import org.hibernate.jdbc.WorkExecutorVisitable;
import org.hibernate.jpa.internal.util.FlushModeTypeHelper;
import org.hibernate.jpa.spi.NativeQueryTupleTransformer;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.procedure.ProcedureCall;
import org.hibernate.procedure.internal.ProcedureCallImpl;
import org.hibernate.procedure.spi.NamedCallableQueryMemento;
import org.hibernate.query.IllegalMutationQueryException;
import org.hibernate.query.IllegalNamedQueryOptionsException;
import org.hibernate.query.IllegalSelectQueryException;
import org.hibernate.query.MutationQuery;
import org.hibernate.query.Query;
import org.hibernate.query.QueryTypeMismatchException;
import org.hibernate.query.SelectionQuery;
import org.hibernate.query.TupleTransformer;
import org.hibernate.query.UnknownNamedQueryException;
import org.hibernate.query.criteria.HibernateCriteriaBuilder;
import org.hibernate.query.criteria.JpaCriteriaInsertSelect;
import org.hibernate.query.criteria.JpaQueryStructure;
import org.hibernate.query.hql.spi.SqmQueryImplementor;
import org.hibernate.query.named.NamedObjectRepository;
import org.hibernate.query.named.NamedResultSetMappingMemento;
import org.hibernate.query.spi.HqlInterpretation;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.spi.QueryImplementor;
import org.hibernate.query.spi.QueryInterpretationCache;
import org.hibernate.query.sql.internal.NativeQueryImpl;
import org.hibernate.query.sql.spi.NamedNativeQueryMemento;
import org.hibernate.query.sql.spi.NativeQueryImplementor;
import org.hibernate.query.sqm.SqmSelectionQuery;
import org.hibernate.query.sqm.internal.QuerySqmImpl;
import org.hibernate.query.sqm.internal.SqmSelectionQueryImpl;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.spi.NamedSqmQueryMemento;
import org.hibernate.query.sqm.tree.SqmDmlStatement;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.insert.SqmInsertSelectStatement;
import org.hibernate.query.sqm.tree.select.SqmQueryGroup;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.query.sqm.tree.select.SqmSelectableNode;
import org.hibernate.query.sqm.tree.update.SqmUpdateStatement;
import org.hibernate.resource.jdbc.internal.EmptyStatementInspector;
import org.hibernate.resource.jdbc.spi.JdbcSessionContext;
import org.hibernate.resource.jdbc.spi.PhysicalConnectionHandlingMode;
import org.hibernate.resource.jdbc.spi.StatementInspector;
import org.hibernate.resource.transaction.backend.jta.internal.JtaTransactionCoordinatorImpl;
import org.hibernate.resource.transaction.spi.TransactionCoordinator;
import org.hibernate.resource.transaction.spi.TransactionCoordinatorBuilder;

public abstract class AbstractSharedSessionContract
implements SharedSessionContractImplementor {
    private static final EntityManagerMessageLogger log = HEMLogging.messageLogger(SessionImpl.class);
    private transient SessionFactoryImpl factory;
    private final String tenantIdentifier;
    protected transient FastSessionServices fastSessionServices;
    private UUID sessionIdentifier;
    private Object sessionToken;
    private transient JdbcConnectionAccess jdbcConnectionAccess;
    private transient JdbcSessionContext jdbcSessionContext;
    private transient JdbcCoordinator jdbcCoordinator;
    private transient TransactionImplementor currentHibernateTransaction;
    private transient TransactionCoordinator transactionCoordinator;
    private transient CacheTransactionSynchronization cacheTransactionSync;
    private final boolean isTransactionCoordinatorShared;
    private final Interceptor interceptor;
    private final TimeZone jdbcTimeZone;
    private FlushMode flushMode;
    private boolean autoJoinTransactions;
    private final PhysicalConnectionHandlingMode connectionHandlingMode;
    private CacheMode cacheMode;
    private boolean criteriaCopyTreeEnabled;
    protected boolean closed;
    protected boolean waitingForAutoClose;
    private transient SessionEventListenerManagerImpl sessionEventsManager;
    private transient EntityNameResolver entityNameResolver;
    private Integer jdbcBatchSize;
    private transient ExceptionConverter exceptionConverter;

    public AbstractSharedSessionContract(SessionFactoryImpl factory, SessionCreationOptions options) {
        this.factory = factory;
        this.fastSessionServices = factory.getFastSessionServices();
        this.cacheTransactionSync = factory.getCache().getRegionFactory().createTransactionContext(this);
        this.setCriteriaCopyTreeEnabled(factory.getSessionFactoryOptions().isCriteriaCopyTreeEnabled());
        this.flushMode = options.getInitialSessionFlushMode();
        this.tenantIdentifier = options.getTenantIdentifier();
        if (factory.getSessionFactoryOptions().isMultiTenancyEnabled() && this.tenantIdentifier == null) {
            throw new HibernateException("SessionFactory configured for multi-tenancy, but no tenant identifier specified");
        }
        this.interceptor = this.interpret(options.getInterceptor());
        this.jdbcTimeZone = options.getJdbcTimeZone();
        List<SessionEventListener> customSessionEventListener = options.getCustomSessionEventListener();
        this.sessionEventsManager = customSessionEventListener == null ? new SessionEventListenerManagerImpl(this.fastSessionServices.defaultSessionEventListeners.buildBaseline()) : new SessionEventListenerManagerImpl(customSessionEventListener.toArray(new SessionEventListener[0]));
        this.entityNameResolver = new CoordinatingEntityNameResolver(factory, this.interceptor);
        StatementInspector statementInspector = this.interpret(options.getStatementInspector());
        if (options instanceof SharedSessionCreationOptions && ((SharedSessionCreationOptions)options).isTransactionCoordinatorShared()) {
            if (options.getConnection() != null) {
                throw new SessionException("Cannot simultaneously share transaction context and specify connection");
            }
            this.isTransactionCoordinatorShared = true;
            SharedSessionCreationOptions sharedOptions = (SharedSessionCreationOptions)options;
            this.transactionCoordinator = sharedOptions.getTransactionCoordinator();
            this.jdbcCoordinator = sharedOptions.getJdbcCoordinator();
            this.currentHibernateTransaction = sharedOptions.getTransaction();
            if (sharedOptions.shouldAutoJoinTransactions()) {
                log.debug("Session creation specified 'autoJoinTransactions', which is invalid in conjunction with sharing JDBC connection between sessions; ignoring");
                this.autoJoinTransactions = false;
            }
            this.connectionHandlingMode = this.jdbcCoordinator.getLogicalConnection().getConnectionHandlingMode();
            if (sharedOptions.getPhysicalConnectionHandlingMode() != this.connectionHandlingMode) {
                log.debug("Session creation specified 'PhysicalConnectionHandlingMode' which is invalid in conjunction with sharing JDBC connection between sessions; ignoring");
            }
            this.jdbcSessionContext = new JdbcSessionContextImpl(this, statementInspector, this.connectionHandlingMode, this.fastSessionServices);
            this.addSharedSessionTransactionObserver(this.transactionCoordinator);
        } else {
            this.isTransactionCoordinatorShared = false;
            this.autoJoinTransactions = options.shouldAutoJoinTransactions();
            this.connectionHandlingMode = options.getPhysicalConnectionHandlingMode();
            this.jdbcSessionContext = new JdbcSessionContextImpl(this, statementInspector, this.connectionHandlingMode, this.fastSessionServices);
            this.jdbcCoordinator = new JdbcCoordinatorImpl(options.getConnection(), this, this.fastSessionServices.jdbcServices);
            this.transactionCoordinator = this.fastSessionServices.transactionCoordinatorBuilder.buildTransactionCoordinator(this.jdbcCoordinator, this);
        }
    }

    @Override
    public Integer getConfiguredJdbcBatchSize() {
        Integer sessionJdbcBatchSize = this.jdbcBatchSize;
        return sessionJdbcBatchSize == null ? this.fastSessionServices.defaultJdbcBatchSize : sessionJdbcBatchSize;
    }

    protected void addSharedSessionTransactionObserver(TransactionCoordinator transactionCoordinator) {
    }

    protected void removeSharedSessionTransactionObserver(TransactionCoordinator transactionCoordinator) {
        transactionCoordinator.invalidate();
    }

    protected void prepareForAutoClose() {
        this.waitingForAutoClose = true;
        this.closed = true;
        if (!this.isTransactionCoordinatorShared) {
            this.addSharedSessionTransactionObserver(this.transactionCoordinator);
        }
    }

    @Override
    public boolean shouldAutoJoinTransaction() {
        return this.autoJoinTransactions;
    }

    private Interceptor interpret(Interceptor interceptor) {
        return interceptor == null ? EmptyInterceptor.INSTANCE : interceptor;
    }

    private StatementInspector interpret(StatementInspector statementInspector) {
        return statementInspector == null ? EmptyStatementInspector.INSTANCE : statementInspector;
    }

    @Override
    public SessionFactoryImplementor getFactory() {
        return this.factory;
    }

    @Override
    public Interceptor getInterceptor() {
        return this.interceptor;
    }

    @Override
    public JdbcCoordinator getJdbcCoordinator() {
        return this.jdbcCoordinator;
    }

    @Override
    public TransactionCoordinator getTransactionCoordinator() {
        return this.transactionCoordinator;
    }

    @Override
    public JdbcSessionContext getJdbcSessionContext() {
        return this.jdbcSessionContext;
    }

    public EntityNameResolver getEntityNameResolver() {
        return this.entityNameResolver;
    }

    @Override
    public SessionEventListenerManager getEventListenerManager() {
        return this.sessionEventsManager;
    }

    @Override
    public UUID getSessionIdentifier() {
        if (this.sessionIdentifier == null) {
            this.sessionIdentifier = StandardRandomStrategy.INSTANCE.generateUUID(null);
        }
        return this.sessionIdentifier;
    }

    @Override
    public Object getSessionToken() {
        if (this.sessionToken == null) {
            this.sessionToken = new Object();
        }
        return this.sessionToken;
    }

    @Override
    public String getTenantIdentifier() {
        return this.tenantIdentifier;
    }

    @Override
    public boolean isOpen() {
        return !this.isClosed();
    }

    @Override
    public boolean isClosed() {
        return this.closed || this.factory.isClosed();
    }

    @Override
    public void close() {
        if (this.closed && !this.waitingForAutoClose) {
            return;
        }
        try {
            this.delayedAfterCompletion();
        }
        catch (HibernateException e) {
            if (this.getFactory().getSessionFactoryOptions().isJpaBootstrap()) {
                throw this.getExceptionConverter().convert(e);
            }
            throw e;
        }
        if (this.sessionEventsManager != null) {
            this.sessionEventsManager.end();
        }
        if (this.transactionCoordinator != null) {
            this.removeSharedSessionTransactionObserver(this.transactionCoordinator);
        }
        try {
            if (this.shouldCloseJdbcCoordinatorOnClose(this.isTransactionCoordinatorShared)) {
                this.jdbcCoordinator.close();
            }
        }
        finally {
            this.setClosed();
        }
    }

    protected void setClosed() {
        this.closed = true;
        this.waitingForAutoClose = false;
        this.cleanupOnClose();
    }

    protected boolean shouldCloseJdbcCoordinatorOnClose(boolean isTransactionCoordinatorShared) {
        return true;
    }

    protected void cleanupOnClose() {
    }

    @Override
    public boolean isOpenOrWaitingForAutoClose() {
        return !this.isClosed() || this.waitingForAutoClose;
    }

    @Override
    public void checkOpen(boolean markForRollbackIfClosed) {
        if (this.isClosed()) {
            if (markForRollbackIfClosed && this.transactionCoordinator.isTransactionActive()) {
                this.markForRollbackOnly();
            }
            throw new IllegalStateException("Session/EntityManager is closed");
        }
    }

    @Override
    public void prepareForQueryExecution(boolean requiresTxn) {
        this.checkOpen();
        this.checkTransactionSynchStatus();
        if (requiresTxn && !this.isTransactionInProgress()) {
            throw new TransactionRequiredException("Query requires transaction be in progress, but no transaction is known to be in progress");
        }
    }

    protected void checkOpenOrWaitingForAutoClose() {
        if (!this.waitingForAutoClose) {
            this.checkOpen();
        }
    }

    @Override
    public void markForRollbackOnly() {
        try {
            this.accessTransaction().markRollbackOnly();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean isTransactionInProgress() {
        if (this.waitingForAutoClose) {
            return this.factory.isOpen() && this.transactionCoordinator.isTransactionActive();
        }
        return !this.isClosed() && this.transactionCoordinator.isTransactionActive();
    }

    @Override
    public void checkTransactionNeededForUpdateOperation(String exceptionMessage) {
        if (this.fastSessionServices.disallowOutOfTransactionUpdateOperations && !this.isTransactionInProgress()) {
            throw new TransactionRequiredException(exceptionMessage);
        }
    }

    @Override
    public Transaction getTransaction() throws HibernateException {
        if (!this.fastSessionServices.isJtaTransactionAccessible) {
            throw new IllegalStateException("Transaction is not accessible when using JTA with JPA-compliant transaction access enabled");
        }
        return this.accessTransaction();
    }

    @Override
    public Transaction accessTransaction() {
        if (this.currentHibernateTransaction == null) {
            this.currentHibernateTransaction = new TransactionImpl(this.getTransactionCoordinator(), this);
        }
        if (!this.isClosed() || this.waitingForAutoClose && this.factory.isOpen()) {
            this.getTransactionCoordinator().pulse();
        }
        return this.currentHibernateTransaction;
    }

    @Override
    public void startTransactionBoundary() {
        this.getCacheTransactionSynchronization().transactionJoined();
    }

    @Override
    public void beforeTransactionCompletion() {
        this.getCacheTransactionSynchronization().transactionCompleting();
    }

    @Override
    public void afterTransactionCompletion(boolean successful, boolean delayed) {
        this.getCacheTransactionSynchronization().transactionCompleted(successful);
    }

    @Override
    public CacheTransactionSynchronization getCacheTransactionSynchronization() {
        return this.cacheTransactionSync;
    }

    @Override
    public Transaction beginTransaction() {
        this.checkOpen();
        Transaction result = this.getTransaction();
        result.begin();
        return result;
    }

    protected void checkTransactionSynchStatus() {
        this.pulseTransactionCoordinator();
        this.delayedAfterCompletion();
    }

    protected void pulseTransactionCoordinator() {
        if (!this.isClosed()) {
            try {
                this.transactionCoordinator.pulse();
            }
            catch (HibernateException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new HibernateException("Exception pulsing TransactionCoordinator", e);
            }
        }
    }

    protected void delayedAfterCompletion() {
        if (this.transactionCoordinator instanceof JtaTransactionCoordinatorImpl) {
            ((JtaTransactionCoordinatorImpl)this.transactionCoordinator).getSynchronizationCallbackCoordinator().processAnyDelayedAfterCompletion();
        }
    }

    protected TransactionImplementor getCurrentTransaction() {
        return this.currentHibernateTransaction;
    }

    @Override
    public boolean isConnected() {
        this.pulseTransactionCoordinator();
        return this.jdbcCoordinator.getLogicalConnection().isOpen();
    }

    @Override
    public JdbcConnectionAccess getJdbcConnectionAccess() {
        if (this.jdbcConnectionAccess == null) {
            this.jdbcConnectionAccess = !this.fastSessionServices.requiresMultiTenantConnectionProvider ? new NonContextualJdbcConnectionAccess(this.getEventListenerManager(), this.fastSessionServices.connectionProvider) : new ContextualJdbcConnectionAccess(this.getTenantIdentifier(), this.getEventListenerManager(), this.fastSessionServices.multiTenantConnectionProvider);
        }
        return this.jdbcConnectionAccess;
    }

    @Override
    public EntityKey generateEntityKey(Object id, EntityPersister persister) {
        return new EntityKey(id, persister);
    }

    @Override
    public boolean useStreamForLobBinding() {
        return this.fastSessionServices.useStreamForLobBinding;
    }

    @Override
    public int getPreferredSqlTypeCodeForBoolean() {
        return this.fastSessionServices.preferredSqlTypeCodeForBoolean;
    }

    @Override
    public LobCreator getLobCreator() {
        return this.getFactory().getFastSessionServices().jdbcServices.getLobCreator(this);
    }

    @Override
    public <T> T execute(LobCreationContext.Callback<T> callback) {
        return (T)this.getJdbcCoordinator().coordinateWork((workExecutor, connection) -> {
            try {
                return callback.executeOnConnection(connection);
            }
            catch (SQLException e) {
                throw this.getExceptionConverter().convert(e, "Error creating contextual LOB : " + e.getMessage());
            }
        });
    }

    @Override
    public TimeZone getJdbcTimeZone() {
        return this.jdbcTimeZone;
    }

    @Override
    public JdbcServices getJdbcServices() {
        return this.getFactory().getJdbcServices();
    }

    @Override
    public FlushModeType getFlushMode() {
        this.checkOpen();
        return FlushModeTypeHelper.getFlushModeType(this.flushMode);
    }

    @Override
    public void setHibernateFlushMode(FlushMode flushMode) {
        this.flushMode = flushMode;
    }

    @Override
    public FlushMode getHibernateFlushMode() {
        return this.flushMode;
    }

    @Override
    public CacheMode getCacheMode() {
        return this.cacheMode;
    }

    @Override
    public void setCacheMode(CacheMode cacheMode) {
        this.cacheMode = cacheMode;
    }

    @Override
    public void setCriteriaCopyTreeEnabled(boolean jpaCriteriaCopyComplianceEnabled) {
        this.criteriaCopyTreeEnabled = jpaCriteriaCopyComplianceEnabled;
    }

    @Override
    public boolean isCriteriaCopyTreeEnabled() {
        return this.criteriaCopyTreeEnabled;
    }

    @Override
    public QueryImplementor createQuery(String queryString) {
        return this.createQuery(queryString, (Class)null);
    }

    @Override
    public SelectionQuery<?> createSelectionQuery(String hqlString) {
        return this.internalCreateSelectionQuery(hqlString, null);
    }

    private <R> SelectionQuery<R> internalCreateSelectionQuery(String hqlString, Class<R> expectedResultType) {
        this.checkOpen();
        this.pulseTransactionCoordinator();
        this.delayedAfterCompletion();
        try {
            Class<R> resultType;
            QueryEngine queryEngine = this.getFactory().getQueryEngine();
            QueryInterpretationCache interpretationCache = queryEngine.getInterpretationCache();
            HqlInterpretation hqlInterpretation = interpretationCache.resolveHqlInterpretation(hqlString, expectedResultType, s -> queryEngine.getHqlTranslator().translate(hqlString, expectedResultType));
            if (!(hqlInterpretation.getSqmStatement() instanceof SqmSelectStatement)) {
                throw new IllegalSelectQueryException("Expecting a selection query, but found `" + hqlString + "`", hqlString);
            }
            SqmSelectionQueryImpl<R> query = new SqmSelectionQueryImpl<R>(hqlString, hqlInterpretation, expectedResultType, this);
            if (expectedResultType != null && !expectedResultType.isAssignableFrom(resultType = query.getResultType())) {
                throw new QueryTypeMismatchException(String.format(Locale.ROOT, "Query result-type error - expecting `%s`, but found `%s`", expectedResultType.getName(), resultType.getName()));
            }
            query.setComment(hqlString);
            this.applyQuerySettingsAndHints(query);
            return query;
        }
        catch (RuntimeException e) {
            this.markForRollbackOnly();
            throw e;
        }
    }

    @Override
    public <R> SelectionQuery<R> createSelectionQuery(String hqlString, Class<R> expectedResultType) {
        return this.internalCreateSelectionQuery(hqlString, expectedResultType);
    }

    @Override
    public <R> SelectionQuery<R> createSelectionQuery(CriteriaQuery<R> criteria) {
        SqmUtil.verifyIsSelectStatement((SqmStatement)criteria, null);
        return new SqmSelectionQueryImpl((SqmSelectStatement)criteria, criteria.getResultType(), (SharedSessionContractImplementor)this);
    }

    public <T> QueryImplementor<T> createQuery(String queryString, Class<T> expectedResultType) {
        this.checkOpen();
        this.pulseTransactionCoordinator();
        this.delayedAfterCompletion();
        try {
            QueryEngine queryEngine = this.getFactory().getQueryEngine();
            QueryInterpretationCache interpretationCache = queryEngine.getInterpretationCache();
            QuerySqmImpl<T> query = new QuerySqmImpl<T>(queryString, interpretationCache.resolveHqlInterpretation(queryString, expectedResultType, s -> queryEngine.getHqlTranslator().translate(queryString, expectedResultType)), expectedResultType, this);
            this.applyQuerySettingsAndHints((Query<?>)query);
            query.setComment(queryString);
            return query;
        }
        catch (RuntimeException e) {
            this.markForRollbackOnly();
            throw this.getExceptionConverter().convert(e);
        }
    }

    @Override
    public NativeQueryImpl createNativeQuery(String sqlString) {
        this.checkOpen();
        this.pulseTransactionCoordinator();
        this.delayedAfterCompletion();
        try {
            NativeQueryImpl query = new NativeQueryImpl(sqlString, (SharedSessionContractImplementor)this);
            if (StringHelper.isEmpty(query.getComment())) {
                query.setComment("dynamic native SQL query");
            }
            this.applyQuerySettingsAndHints(query);
            return query;
        }
        catch (RuntimeException he) {
            throw this.getExceptionConverter().convert(he);
        }
    }

    @Override
    public NativeQueryImplementor createNativeQuery(String sqlString, String resultSetMappingName) {
        this.checkOpen();
        this.pulseTransactionCoordinator();
        this.delayedAfterCompletion();
        try {
            if (StringHelper.isNotEmpty(resultSetMappingName)) {
                NamedResultSetMappingMemento resultSetMappingMemento = this.getFactory().getQueryEngine().getNamedObjectRepository().getResultSetMappingMemento(resultSetMappingName);
                if (resultSetMappingMemento == null) {
                    throw new HibernateException("Could not resolve specified result-set mapping name : " + resultSetMappingName);
                }
                return new NativeQueryImpl(sqlString, resultSetMappingMemento, this);
            }
            return new NativeQueryImpl(sqlString, (SharedSessionContractImplementor)this);
        }
        catch (RuntimeException he) {
            throw this.getExceptionConverter().convert(he);
        }
    }

    @Override
    public NativeQueryImplementor createNativeQuery(String sqlString, Class resultClass) {
        NativeQueryImpl query = this.createNativeQuery(sqlString);
        if (Tuple.class.equals((Object)resultClass)) {
            query.setTupleTransformer((TupleTransformer)new NativeQueryTupleTransformer());
        } else if (this.getFactory().getMappingMetamodel().isEntityClass(resultClass)) {
            query.addEntity("alias1", resultClass.getName(), LockMode.READ);
        } else if (resultClass != Object.class && resultClass != Object[].class) {
            query.addScalar(1, resultClass);
        }
        return query;
    }

    public <T> NativeQueryImplementor<T> createNativeQuery(String sqlString, Class<T> resultClass, String tableAlias) {
        NativeQueryImpl query = this.createNativeQuery(sqlString);
        if (!this.getFactory().getMappingMetamodel().isEntityClass(resultClass)) {
            throw new UnknownEntityTypeException("unable to locate persister: " + resultClass.getName());
        }
        query.addEntity(tableAlias, resultClass.getName(), LockMode.READ);
        return query;
    }

    public <T> NativeQueryImplementor<T> createNativeQuery(String sqlString, String resultSetMappingName, Class<T> resultClass) {
        NativeQueryImplementor query = this.createNativeQuery(sqlString, resultSetMappingName);
        if (Tuple.class.equals(resultClass)) {
            query.setTupleTransformer((TupleTransformer)new NativeQueryTupleTransformer());
        }
        return query;
    }

    @Override
    public QueryImplementor getNamedQuery(String queryName) {
        return this.buildNamedQuery(queryName, null);
    }

    @Override
    public QueryImplementor createNamedQuery(String name) {
        return this.buildNamedQuery(name, null);
    }

    @Override
    public <R> QueryImplementor<R> createNamedQuery(String name, Class<R> resultClass) {
        return this.buildNamedQuery(name, resultClass);
    }

    @Override
    public SelectionQuery<?> createNamedSelectionQuery(String queryName) {
        return this.createNamedSelectionQuery(queryName, null);
    }

    @Override
    public <R> SelectionQuery<R> createNamedSelectionQuery(String queryName, Class<R> expectedResultType) {
        this.checkOpen();
        this.pulseTransactionCoordinator();
        this.delayedAfterCompletion();
        NamedSqmQueryMemento namedHqlDescriptor = this.getFactory().getQueryEngine().getNamedObjectRepository().getSqmQueryMemento(queryName);
        if (namedHqlDescriptor != null) {
            return this.createNamedSqmSelectionQuery(namedHqlDescriptor, expectedResultType);
        }
        NamedNativeQueryMemento namedNativeDescriptor = this.getFactory().getQueryEngine().getNamedObjectRepository().getNativeQueryMemento(queryName);
        if (namedNativeDescriptor != null) {
            return this.createNamedNativeSelectionQuery(namedNativeDescriptor, expectedResultType);
        }
        throw new UnknownNamedQueryException(queryName);
    }

    private <R> SelectionQuery<R> createNamedNativeSelectionQuery(NamedNativeQueryMemento memento, Class<R> expectedResultType) {
        throw new UnsupportedOperationException(String.format(Locale.ROOT, "Support for `@%s` + `%s` is not (yet) implemented", NamedNativeQuery.class.getName(), SelectionQuery.class.getName()));
    }

    private <R> SqmSelectionQuery<R> createNamedSqmSelectionQuery(NamedSqmQueryMemento memento, Class<R> expectedResultType) {
        SqmSelectionQuery<R> selectionQuery = memento.toSelectionQuery(expectedResultType, this);
        if (StringHelper.isEmpty(memento.getComment())) {
            selectionQuery.setComment("Named query : " + memento.getRegistrationName());
        } else {
            selectionQuery.setComment(memento.getComment());
        }
        this.applyQuerySettingsAndHints(selectionQuery);
        if (memento.getLockOptions() != null) {
            selectionQuery.getLockOptions().overlay(memento.getLockOptions());
        }
        return selectionQuery;
    }

    @Override
    public void doWork(Work work) throws HibernateException {
        WorkExecutorVisitable<Void> realWork = (workExecutor, connection) -> {
            workExecutor.executeWork(work, connection);
            return null;
        };
        this.doWork(realWork);
    }

    @Override
    public <T> T doReturningWork(ReturningWork<T> work) throws HibernateException {
        WorkExecutorVisitable<Object> realWork = (workExecutor, connection) -> workExecutor.executeReturningWork(work, connection);
        return (T)this.doWork(realWork);
    }

    private <T> T doWork(WorkExecutorVisitable<T> work) throws HibernateException {
        return this.getJdbcCoordinator().coordinateWork(work);
    }

    protected <T> QueryImplementor<T> buildNamedQuery(String queryName, Class<T> resultType) {
        try {
            return this.buildNamedQuery(queryName, memento -> {
                QueryImplementor query = memento.toQuery((SharedSessionContractImplementor)this, resultType);
                if (StringHelper.isEmpty(query.getComment())) {
                    query.setComment("dynamic query");
                }
                this.applyQuerySettingsAndHints(query);
                if (memento.getLockOptions() != null) {
                    query.setLockOptions(memento.getLockOptions());
                }
                return query;
            }, memento -> {
                QueryImplementor query = resultType == null ? memento.toQuery(this) : memento.toQuery((SharedSessionContractImplementor)this, resultType);
                if (StringHelper.isEmpty(query.getComment())) {
                    query.setComment("dynamic native-SQL query");
                }
                this.applyQuerySettingsAndHints(query);
                return query;
            });
        }
        catch (UnknownNamedQueryException e) {
            this.transactionCoordinator.getTransactionDriverControl().markRollbackOnly();
            throw new IllegalArgumentException(e.getMessage(), (Throwable)((Object)e));
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw this.getExceptionConverter().convert(e);
        }
    }

    protected QueryImplementor buildNamedQuery(String queryName, Function<NamedSqmQueryMemento, SqmQueryImplementor> namedSqmHandler, Function<NamedNativeQueryMemento, NativeQueryImplementor> namedNativeHandler) {
        this.checkOpen();
        this.pulseTransactionCoordinator();
        this.delayedAfterCompletion();
        NamedObjectRepository namedObjectRepository = this.getFactory().getQueryEngine().getNamedObjectRepository();
        NamedSqmQueryMemento namedSqmQueryMemento = namedObjectRepository.getSqmQueryMemento(queryName);
        if (namedSqmQueryMemento != null) {
            return namedSqmHandler.apply(namedSqmQueryMemento);
        }
        NamedNativeQueryMemento namedNativeDescriptor = namedObjectRepository.getNativeQueryMemento(queryName);
        if (namedNativeDescriptor != null) {
            return namedNativeHandler.apply(namedNativeDescriptor);
        }
        throw new UnknownNamedQueryException(queryName);
    }

    protected void applyQuerySettingsAndHints(SelectionQuery<?> query) {
    }

    protected void applyQuerySettingsAndHints(Query<?> query) {
    }

    @Override
    public NativeQueryImplementor getNamedNativeQuery(String queryName) {
        NamedNativeQueryMemento namedNativeDescriptor = this.getFactory().getQueryEngine().getNamedObjectRepository().getNativeQueryMemento(queryName);
        if (namedNativeDescriptor != null) {
            return namedNativeDescriptor.toQuery(this);
        }
        throw this.getExceptionConverter().convert(new IllegalArgumentException("No query defined for that name [" + queryName + "]"));
    }

    @Override
    public NativeQueryImplementor getNamedNativeQuery(String queryName, String resultSetMapping) {
        NamedNativeQueryMemento namedNativeDescriptor = this.getFactory().getQueryEngine().getNamedObjectRepository().getNativeQueryMemento(queryName);
        if (namedNativeDescriptor != null) {
            return namedNativeDescriptor.toQuery((SharedSessionContractImplementor)this, resultSetMapping);
        }
        throw this.getExceptionConverter().convert(new IllegalArgumentException("No query defined for that name [" + queryName + "]"));
    }

    @Override
    public MutationQuery createMutationQuery(String hqlString) {
        QueryImplementor query = this.createQuery(hqlString);
        SqmStatement sqmStatement = ((SqmQueryImplementor)query).getSqmStatement();
        if (!(sqmStatement instanceof SqmDmlStatement)) {
            throw new IllegalMutationQueryException("Expecting a mutation query, but found `" + hqlString + "`");
        }
        return query;
    }

    @Override
    public MutationQuery createNativeMutationQuery(String sqlString) {
        NativeQueryImpl query = this.createNativeQuery(sqlString);
        if (query.isSelectQuery() == Boolean.TRUE) {
            throw new IllegalMutationQueryException("Expecting a native mutation query, but found `" + sqlString + "`");
        }
        return query;
    }

    @Override
    public MutationQuery createNamedMutationQuery(String queryName) {
        return this.buildNamedQuery(queryName, sqmMemento -> {
            QueryImplementor query = sqmMemento.toQuery(this);
            SqmStatement sqmStatement = query.getSqmStatement();
            if (!(sqmStatement instanceof SqmDmlStatement)) {
                throw new IllegalMutationQueryException("Expecting a named mutation query (" + queryName + "), but found a select statement");
            }
            if (sqmMemento.getLockOptions() != null && !sqmMemento.getLockOptions().isEmpty()) {
                throw new IllegalNamedQueryOptionsException("Named mutation query `" + queryName + "` specified lock-options");
            }
            if (StringHelper.isEmpty(query.getComment())) {
                query.setComment("dynamic HQL query");
            }
            this.applyQuerySettingsAndHints(query);
            return query;
        }, nativeMemento -> {
            QueryImplementor query = nativeMemento.toQuery(this);
            Boolean isUnequivocallySelect = query.isSelectQuery();
            if (isUnequivocallySelect == Boolean.TRUE) {
                throw new IllegalMutationQueryException("Expecting named native query (" + queryName + ") to be a mutation query, but found `" + nativeMemento.getSqlString() + "`");
            }
            if (StringHelper.isEmpty(query.getComment())) {
                query.setComment("dynamic native-SQL query");
            }
            this.applyQuerySettingsAndHints(query);
            return query;
        });
    }

    @Override
    public MutationQuery createMutationQuery(CriteriaUpdate updateQuery) {
        this.checkOpen();
        try {
            return new QuerySqmImpl((SqmUpdateStatement)updateQuery, null, (SharedSessionContractImplementor)this);
        }
        catch (RuntimeException e) {
            throw this.getExceptionConverter().convert(e);
        }
    }

    @Override
    public MutationQuery createMutationQuery(CriteriaDelete deleteQuery) {
        this.checkOpen();
        try {
            return new QuerySqmImpl((SqmDeleteStatement)deleteQuery, null, (SharedSessionContractImplementor)this);
        }
        catch (RuntimeException e) {
            throw this.getExceptionConverter().convert(e);
        }
    }

    @Override
    public MutationQuery createMutationQuery(JpaCriteriaInsertSelect insertSelect) {
        this.checkOpen();
        try {
            return new QuerySqmImpl((SqmInsertSelectStatement)insertSelect, null, (SharedSessionContractImplementor)this);
        }
        catch (RuntimeException e) {
            throw this.getExceptionConverter().convert(e);
        }
    }

    @Override
    public ProcedureCall getNamedProcedureCall(String name) {
        this.checkOpen();
        NamedCallableQueryMemento memento = this.factory.getQueryEngine().getNamedObjectRepository().getCallableQueryMemento(name);
        if (memento == null) {
            throw new IllegalArgumentException("Could not find named stored procedure call with that registration name : " + name);
        }
        ProcedureCall procedureCall = memento.makeProcedureCall(this);
        return procedureCall;
    }

    @Override
    public ProcedureCall createNamedStoredProcedureQuery(String name) {
        return this.getNamedProcedureCall(name);
    }

    @Override
    public ProcedureCall createStoredProcedureCall(String procedureName) {
        this.checkOpen();
        ProcedureCallImpl procedureCall = new ProcedureCallImpl((SharedSessionContractImplementor)this, procedureName);
        return procedureCall;
    }

    @Override
    public ProcedureCall createStoredProcedureCall(String procedureName, Class<?> ... resultClasses) {
        this.checkOpen();
        ProcedureCallImpl procedureCall = new ProcedureCallImpl((SharedSessionContractImplementor)this, procedureName, resultClasses);
        return procedureCall;
    }

    @Override
    public ProcedureCall createStoredProcedureCall(String procedureName, String ... resultSetMappings) {
        this.checkOpen();
        ProcedureCallImpl procedureCall = new ProcedureCallImpl((SharedSessionContractImplementor)this, procedureName, resultSetMappings);
        return procedureCall;
    }

    @Override
    public ProcedureCall createStoredProcedureQuery(String procedureName) {
        this.checkOpen();
        ProcedureCallImpl procedureCall = new ProcedureCallImpl((SharedSessionContractImplementor)this, procedureName);
        return procedureCall;
    }

    @Override
    public ProcedureCall createStoredProcedureQuery(String procedureName, Class<?> ... resultClasses) {
        this.checkOpen();
        ProcedureCallImpl procedureCall = new ProcedureCallImpl((SharedSessionContractImplementor)this, procedureName, resultClasses);
        return procedureCall;
    }

    @Override
    public ProcedureCall createStoredProcedureQuery(String procedureName, String ... resultSetMappings) {
        this.checkOpen();
        ProcedureCallImpl procedureCall = new ProcedureCallImpl((SharedSessionContractImplementor)this, procedureName, resultSetMappings);
        return procedureCall;
    }

    protected abstract Object load(String var1, Object var2);

    @Override
    public ExceptionConverter getExceptionConverter() {
        if (this.exceptionConverter == null) {
            this.exceptionConverter = new ExceptionConverterImpl(this);
        }
        return this.exceptionConverter;
    }

    @Override
    public Integer getJdbcBatchSize() {
        return this.jdbcBatchSize;
    }

    @Override
    public void setJdbcBatchSize(Integer jdbcBatchSize) {
        this.jdbcBatchSize = jdbcBatchSize;
    }

    @Override
    public HibernateCriteriaBuilder getCriteriaBuilder() {
        this.checkOpen();
        return this.getFactory().getCriteriaBuilder();
    }

    public <T> QueryImplementor<T> createQuery(CriteriaQuery<T> criteriaQuery) {
        this.checkOpen();
        try {
            JpaQueryStructure querySpec;
            SqmSelectStatement selectStatement = (SqmSelectStatement)criteriaQuery;
            if (!(selectStatement.getQueryPart() instanceof SqmQueryGroup) && ((SqmQuerySpec)(querySpec = selectStatement.getQuerySpec())).getSelectClause().getSelections().isEmpty() && ((SqmQuerySpec)querySpec).getFromClause().getRoots().size() == 1) {
                ((SqmQuerySpec)querySpec).getSelectClause().setSelection((SqmSelectableNode)((SqmQuerySpec)querySpec).getFromClause().getRoots().get(0));
            }
            return new QuerySqmImpl(selectStatement, criteriaQuery.getResultType(), (SharedSessionContractImplementor)this);
        }
        catch (RuntimeException e) {
            if (this.getSessionFactory().getJpaMetamodel().getJpaCompliance().isJpaTransactionComplianceEnabled()) {
                this.markForRollbackOnly();
            }
            throw this.getExceptionConverter().convert(e);
        }
    }

    @Override
    public QueryImplementor createQuery(CriteriaUpdate criteriaUpdate) {
        this.checkOpen();
        try {
            return new QuerySqmImpl((SqmUpdateStatement)criteriaUpdate, null, (SharedSessionContractImplementor)this);
        }
        catch (RuntimeException e) {
            if (this.getSessionFactory().getJpaMetamodel().getJpaCompliance().isJpaTransactionComplianceEnabled()) {
                this.markForRollbackOnly();
            }
            throw this.getExceptionConverter().convert(e);
        }
    }

    @Override
    public QueryImplementor createQuery(CriteriaDelete criteriaDelete) {
        this.checkOpen();
        try {
            return new QuerySqmImpl((SqmDeleteStatement)criteriaDelete, null, (SharedSessionContractImplementor)this);
        }
        catch (RuntimeException e) {
            if (this.getSessionFactory().getJpaMetamodel().getJpaCompliance().isJpaTransactionComplianceEnabled()) {
                this.markForRollbackOnly();
            }
            throw this.getExceptionConverter().convert(e);
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace("Serializing " + this.getClass().getSimpleName() + " [");
        }
        if (!this.jdbcCoordinator.isReadyForSerialization()) {
            throw new IllegalStateException("Cannot serialize " + this.getClass().getSimpleName() + " [" + this.getSessionIdentifier() + "] while connected");
        }
        if (this.isTransactionCoordinatorShared) {
            throw new IllegalStateException("Cannot serialize " + this.getClass().getSimpleName() + " [" + this.getSessionIdentifier() + "] as it has a shared TransactionCoordinator");
        }
        oos.defaultWriteObject();
        this.factory.serialize(oos);
        oos.writeObject(this.jdbcSessionContext.getStatementInspector());
        this.jdbcCoordinator.serialize(oos);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException, SQLException {
        if (log.isTraceEnabled()) {
            log.trace("Deserializing " + this.getClass().getSimpleName());
        }
        ois.defaultReadObject();
        this.factory = SessionFactoryImpl.deserialize(ois);
        this.fastSessionServices = this.factory.getFastSessionServices();
        this.sessionEventsManager = new SessionEventListenerManagerImpl(this.fastSessionServices.defaultSessionEventListeners.buildBaseline());
        this.jdbcSessionContext = new JdbcSessionContextImpl(this, (StatementInspector)ois.readObject(), this.connectionHandlingMode, this.fastSessionServices);
        this.jdbcCoordinator = JdbcCoordinatorImpl.deserialize(ois, this);
        this.cacheTransactionSync = this.factory.getCache().getRegionFactory().createTransactionContext(this);
        this.transactionCoordinator = this.factory.getServiceRegistry().getService(TransactionCoordinatorBuilder.class).buildTransactionCoordinator(this.jdbcCoordinator, this);
        this.entityNameResolver = new CoordinatingEntityNameResolver(this.factory, this.interceptor);
    }
}

