/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.internal;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.hibernate.HibernateException;
import org.hibernate.LockOptions;
import org.hibernate.SimpleNaturalIdLoadAccess;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.loader.LoaderLogging;
import org.hibernate.loader.internal.BaseNaturalIdLoadAccessImpl;
import org.hibernate.loader.internal.LoadAccessContext;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.internal.SimpleNaturalIdMapping;

public class SimpleNaturalIdLoadAccessImpl<T>
extends BaseNaturalIdLoadAccessImpl<T>
implements SimpleNaturalIdLoadAccess<T> {
    private final boolean hasSimpleNaturalId;

    public SimpleNaturalIdLoadAccessImpl(LoadAccessContext context, EntityMappingType entityDescriptor) {
        super(context, entityDescriptor);
        this.hasSimpleNaturalId = entityDescriptor.getNaturalIdMapping() instanceof SimpleNaturalIdMapping;
        if (!this.hasSimpleNaturalId) {
            LoaderLogging.LOADER_LOGGER.debugf("Entity [%s] did not define a simple natural id", (Object)entityDescriptor.getEntityName());
        }
    }

    @Override
    public LockOptions getLockOptions() {
        return super.getLockOptions();
    }

    @Override
    public boolean isSynchronizationEnabled() {
        return super.isSynchronizationEnabled();
    }

    @Override
    public final SimpleNaturalIdLoadAccessImpl<T> with(LockOptions lockOptions) {
        return (SimpleNaturalIdLoadAccessImpl)super.with(lockOptions);
    }

    @Override
    public SimpleNaturalIdLoadAccessImpl<T> setSynchronizationEnabled(boolean synchronizationEnabled) {
        super.synchronizationEnabled(synchronizationEnabled);
        return this;
    }

    @Override
    public T getReference(Object naturalIdValue) {
        this.verifySimplicity(naturalIdValue);
        SessionImplementor session = this.getContext().getSession();
        Object normalizedNaturalIdValue = this.entityPersister().getNaturalIdMapping().normalizeInput(naturalIdValue, session);
        return this.doGetReference(normalizedNaturalIdValue);
    }

    @Override
    public T load(Object naturalIdValue) {
        this.verifySimplicity(naturalIdValue);
        SessionImplementor session = this.getContext().getSession();
        Object normalizedNaturalIdValue = this.entityPersister().getNaturalIdMapping().normalizeInput(naturalIdValue, session);
        return this.doLoad(normalizedNaturalIdValue);
    }

    private void verifySimplicity(Object naturalIdValue) {
        assert (naturalIdValue != null);
        if (this.hasSimpleNaturalId) {
            return;
        }
        if (naturalIdValue.getClass().isArray()) {
            return;
        }
        if (naturalIdValue instanceof List || naturalIdValue instanceof Map) {
            return;
        }
        throw new HibernateException(String.format(Locale.ROOT, "Cannot interpret natural-id value [%s] for compound natural-id: %s", naturalIdValue, this.entityPersister().getEntityName()));
    }

    @Override
    public Optional<T> loadOptional(Object naturalIdValue) {
        return Optional.ofNullable(this.load(naturalIdValue));
    }
}

