/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import org.hibernate.dialect.Dialect;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.metamodel.mapping.SelectablePath;

public class AggregateColumn
extends Column {
    private final Component component;

    public AggregateColumn(Column column, Component component) {
        this.setLength(column.getLength());
        this.setPrecision(column.getPrecision());
        this.setScale(column.getScale());
        this.setValue(column.getValue());
        this.setTypeIndex(column.getTypeIndex());
        this.setName(column.getQuotedName());
        this.setNullable(column.isNullable());
        this.setUnique(column.isUnique());
        this.setSqlType(column.getSqlType());
        this.setSqlTypeCode(column.getSqlTypeCode());
        this.uniqueInteger = column.uniqueInteger;
        this.setCheckConstraint(column.getCheckConstraint());
        this.setComment(column.getComment());
        this.setDefaultValue(column.getDefaultValue());
        this.setGeneratedAs(column.getGeneratedAs());
        this.setAssignmentExpression(column.getAssignmentExpression());
        this.setCustomRead(column.getCustomRead());
        this.setCustomWrite(column.getCustomWrite());
        this.component = component;
    }

    public Component getComponent() {
        return this.component;
    }

    public SelectablePath getSelectablePath() {
        return AggregateColumn.getSelectablePath(this.component);
    }

    private static SelectablePath getSelectablePath(Component component) {
        AggregateColumn aggregateColumn = component.getAggregateColumn();
        AggregateColumn parentAggregateColumn = component.getParentAggregateColumn();
        String simpleAggregateName = aggregateColumn.getQuotedName();
        if (parentAggregateColumn == null) {
            return new SelectablePath(simpleAggregateName);
        }
        return AggregateColumn.getSelectablePath(parentAggregateColumn.getComponent()).append(simpleAggregateName);
    }

    public String getAggregateReadExpressionTemplate(Dialect dialect) {
        return AggregateColumn.getAggregateReadExpressionTemplate(dialect, this.component);
    }

    private static String getAggregateReadExpressionTemplate(Dialect dialect, Component component) {
        AggregateColumn aggregateColumn = component.getAggregateColumn();
        AggregateColumn parentAggregateColumn = component.getParentAggregateColumn();
        String simpleAggregateName = aggregateColumn.getQuotedName(dialect);
        Object aggregateSelectableExpression = parentAggregateColumn == null ? "$PlaceHolder$." + simpleAggregateName : dialect.getAggregateSupport().aggregateComponentCustomReadExpression("", "", AggregateColumn.getAggregateReadExpressionTemplate(dialect, parentAggregateColumn.getComponent()), simpleAggregateName, parentAggregateColumn, aggregateColumn);
        return aggregateSelectableExpression;
    }

    public String getAggregateAssignmentExpressionTemplate(Dialect dialect) {
        return AggregateColumn.getAggregateAssignmentExpressionTemplate(dialect, this.component);
    }

    private static String getAggregateAssignmentExpressionTemplate(Dialect dialect, Component component) {
        AggregateColumn aggregateColumn = component.getAggregateColumn();
        AggregateColumn parentAggregateColumn = component.getParentAggregateColumn();
        String simpleAggregateName = aggregateColumn.getQuotedName(dialect);
        Object aggregateSelectableExpression = parentAggregateColumn == null ? "$PlaceHolder$." + simpleAggregateName : dialect.getAggregateSupport().aggregateComponentAssignmentExpression(AggregateColumn.getAggregateAssignmentExpressionTemplate(dialect, parentAggregateColumn.getComponent()), simpleAggregateName, parentAggregateColumn, aggregateColumn);
        return aggregateSelectableExpression;
    }

    @Override
    public AggregateColumn clone() {
        return new AggregateColumn(this, this.component);
    }
}

