/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.io.Serializable;
import java.util.Locale;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.model.TruthValue;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.loader.internal.AliasConstantsHelper;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.query.sqm.function.SqmFunctionRegistry;
import org.hibernate.sql.Template;
import org.hibernate.tool.schema.extract.spi.ColumnTypeInformation;
import org.hibernate.type.BasicPluralType;
import org.hibernate.type.BasicType;
import org.hibernate.type.ComponentType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.ArrayJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.spi.TypeConfiguration;

public class Column
implements Selectable,
Serializable,
Cloneable,
ColumnTypeInformation {
    private Long length;
    private Integer precision;
    private Integer scale;
    private Value value;
    private int typeIndex;
    private String name;
    private boolean nullable = true;
    private boolean unique;
    private String sqlType;
    private Integer sqlTypeCode;
    private boolean quoted;
    int uniqueInteger;
    private String checkConstraint;
    private String comment;
    private String defaultValue;
    private String generatedAs;
    private String assignmentExpression;
    private String customWrite;
    private String customRead;
    private Size columnSize;
    private String specializedTypeDeclaration;

    public Column() {
    }

    public Column(String columnName) {
        this.setName(columnName);
    }

    public Long getLength() {
        return this.length;
    }

    public void setLength(Long length) {
        this.length = length;
    }

    public void setLength(Integer length) {
        this.length = length.longValue();
    }

    public Value getValue() {
        return this.value;
    }

    public void setValue(Value value) {
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (StringHelper.isNotEmpty(name) && "`\"[".indexOf(name.charAt(0)) > -1) {
            this.quoted = true;
            this.name = name.substring(1, name.length() - 1);
        } else {
            this.name = name;
        }
    }

    public String getQuotedName() {
        return StringHelper.safeInterning((String)(this.quoted ? "`" + this.name + "`" : this.name));
    }

    public String getQuotedName(Dialect d) {
        return StringHelper.safeInterning((String)(this.quoted ? d.openQuote() + this.name + d.closeQuote() : this.name));
    }

    @Override
    public String getAlias(Dialect dialect) {
        boolean useRawName;
        int lastLetter = StringHelper.lastIndexOfLetter(this.name);
        String suffix = AliasConstantsHelper.get(this.uniqueInteger);
        String alias = this.name.toLowerCase(Locale.ROOT);
        if (lastLetter == -1) {
            alias = "column";
        } else if (alias.length() > lastLetter + 1) {
            alias = alias.substring(0, lastLetter + 1);
        }
        boolean bl = useRawName = this.name.length() + suffix.length() <= dialect.getMaxAliasLength() && !this.quoted && !this.name.toLowerCase(Locale.ROOT).equals("rowid");
        if (!useRawName) {
            if (suffix.length() >= dialect.getMaxAliasLength()) {
                throw new MappingException(String.format("Unique suffix [%s] length must be less than maximum [%d]", suffix, dialect.getMaxAliasLength()));
            }
            if (alias.length() + suffix.length() > dialect.getMaxAliasLength()) {
                alias = alias.substring(0, dialect.getMaxAliasLength() - suffix.length());
            }
        }
        return alias + suffix;
    }

    @Override
    public String getAlias(Dialect dialect, Table table) {
        return StringHelper.safeInterning(this.getAlias(dialect) + AliasConstantsHelper.get(table.getUniqueInteger()));
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public int getTypeIndex() {
        return this.typeIndex;
    }

    public void setTypeIndex(int typeIndex) {
        this.typeIndex = typeIndex;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public int hashCode() {
        return this.isQuoted() ? this.name.hashCode() : this.name.toLowerCase(Locale.ROOT).hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof Column && this.equals((Column)object);
    }

    public boolean equals(Column column) {
        return column != null && (this == column || this.isQuoted() ? this.name.equals(column.name) : this.name.equalsIgnoreCase(column.name));
    }

    public int getSqlTypeCode(Mapping mapping) throws MappingException {
        if (this.sqlTypeCode == null) {
            Type type = this.getValue().getType();
            try {
                int sqlTypeCode = type.getSqlTypeCodes(mapping)[this.getTypeIndex()];
                if (this.getSqlTypeCode() != null && this.getSqlTypeCode() != sqlTypeCode) {
                    throw new MappingException("SQL type codes do not match, mapped as " + sqlTypeCode + " but is " + this.getSqlTypeCode());
                }
                this.sqlTypeCode = sqlTypeCode;
                return this.sqlTypeCode;
            }
            catch (MappingException me) {
                throw me;
            }
            catch (Exception e) {
                throw new MappingException("Could not determine type for column " + this.name + " of type " + type.getClass().getName() + ": " + e.getClass().getName(), e);
            }
        }
        return this.sqlTypeCode;
    }

    private String getSqlTypeName(TypeConfiguration typeConfiguration, Dialect dialect, Mapping mapping) {
        Type type = this.getValue().getType();
        if (type instanceof BasicPluralType && ((BasicType)type).getJdbcType() instanceof ArrayJdbcType) {
            int sqlTypeCode;
            BasicPluralType containerType = (BasicPluralType)type;
            BasicType elementType = containerType.getElementType();
            try {
                sqlTypeCode = elementType.getJdbcType().getDdlTypeCode();
            }
            catch (Exception e) {
                throw new MappingException("Could not determine type for column " + this.name + " of type " + type.getClass().getName() + ": " + e.getClass().getName(), e);
            }
            String elementTypeName = typeConfiguration.getDdlTypeRegistry().getTypeName(sqlTypeCode, dialect.getSizeStrategy().resolveSize(elementType.getJdbcMapping().getJdbcType(), elementType.getJavaTypeDescriptor(), this.precision, this.scale, this.length));
            return dialect.getArrayTypeName(elementTypeName);
        }
        return typeConfiguration.getDdlTypeRegistry().getTypeName(this.getSqlTypeCode(mapping), this.getColumnSize(dialect, mapping));
    }

    public Integer getSqlTypeCode() {
        return this.sqlTypeCode;
    }

    public void setSqlTypeCode(Integer typeCode) {
        this.sqlTypeCode = typeCode;
    }

    public String getSqlType(Metadata mapping) throws HibernateException {
        return this.getSqlType(mapping.getDatabase().getTypeConfiguration(), mapping.getDatabase().getDialect(), mapping);
    }

    @Deprecated(since="6.2")
    public String getSqlType(TypeConfiguration typeConfiguration, Dialect dialect, Mapping mapping) throws HibernateException {
        if (this.sqlType == null) {
            try {
                this.sqlType = this.getSqlTypeName(typeConfiguration, dialect, mapping);
            }
            catch (HibernateException cause) {
                throw new HibernateException(String.format(Locale.ROOT, "Unable to resolve JDBC type code for column `%s.%s`", this.getValue().getTable().getName(), this.getName()), (Throwable)((Object)cause));
            }
        }
        return this.sqlType;
    }

    @Override
    public String getTypeName() {
        return this.sqlType;
    }

    @Override
    public TruthValue getNullable() {
        return this.nullable ? TruthValue.TRUE : TruthValue.FALSE;
    }

    @Override
    public int getTypeCode() {
        return this.sqlTypeCode == null ? 1111 : this.sqlTypeCode;
    }

    @Override
    public int getColumnSize() {
        if (this.length == null) {
            return this.precision == null ? 0 : this.precision;
        }
        return this.length.intValue();
    }

    @Override
    public int getDecimalDigits() {
        return this.scale == null ? 0 : this.scale;
    }

    public Size getColumnSize(Dialect dialect, Mapping mapping) {
        if (this.columnSize != null) {
            return this.columnSize;
        }
        Type type = this.getValue().getType();
        if (type instanceof EntityType) {
            type = this.getTypeForEntityValue(mapping, type, this.getTypeIndex());
        }
        if (type instanceof ComponentType) {
            type = this.getTypeForComponentValue(mapping, type, this.getTypeIndex());
        }
        JdbcMapping jdbcMapping = (JdbcMapping)((Object)type);
        JdbcType jdbcType = jdbcMapping.getJdbcType();
        JavaType<?> javaType = jdbcMapping.getJdbcJavaType();
        this.columnSize = dialect.getSizeStrategy().resolveSize(jdbcType, javaType, this.precision, this.scale, this.length);
        return this.columnSize;
    }

    private Type getTypeForComponentValue(Mapping mapping, Type type, int typeIndex) {
        Type[] subtypes = ((ComponentType)type).getSubtypes();
        int typeStartIndex = 0;
        for (int i = 0; i <= subtypes.length; ++i) {
            Type subtype = subtypes[i];
            int columnSpan = subtype.getColumnSpan(mapping);
            if (typeStartIndex + columnSpan > typeIndex) {
                int subtypeIndex = typeIndex - typeStartIndex;
                if (subtype instanceof EntityType) {
                    return this.getTypeForEntityValue(mapping, subtype, subtypeIndex);
                }
                if (subtype instanceof ComponentType) {
                    return this.getTypeForComponentValue(mapping, subtype, subtypeIndex);
                }
                if (subtypeIndex != 0) break;
                return subtype;
            }
            typeStartIndex += columnSpan;
        }
        throw new HibernateException(String.format(Locale.ROOT, "Unable to resolve org.hibernate.type.Type for column `%s.%s`", this.getValue().getTable().getName(), this.getName()));
    }

    private Type getTypeForEntityValue(Mapping mapping, Type type, int typeIndex) {
        int index = 0;
        if (type instanceof EntityType) {
            EntityType entityType = (EntityType)type;
            return this.getTypeForEntityValue(mapping, entityType.getIdentifierOrUniqueKeyType(mapping), typeIndex);
        }
        if (type instanceof ComponentType) {
            for (Type subtype : ((ComponentType)type).getSubtypes()) {
                Type result = this.getTypeForEntityValue(mapping, subtype, typeIndex - index);
                if (result != null) {
                    return result;
                }
                index += subtype.getColumnSpan(mapping);
            }
            return null;
        }
        if (typeIndex == 0) {
            return type;
        }
        return null;
    }

    public String getSqlType() {
        return this.sqlType;
    }

    public void setSqlType(String sqlType) {
        this.sqlType = sqlType;
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    public boolean isQuoted() {
        return this.quoted;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getName() + ")";
    }

    public void setSpecializedTypeDeclaration(String specializedTypeDeclaration) {
        this.specializedTypeDeclaration = specializedTypeDeclaration;
    }

    public String getSpecializedTypeDeclaration() {
        return this.specializedTypeDeclaration;
    }

    public boolean hasSpecializedTypeDeclaration() {
        return this.specializedTypeDeclaration != null;
    }

    public String getCheckConstraint() {
        return this.checkConstraint;
    }

    public void setCheckConstraint(String checkConstraint) {
        this.checkConstraint = checkConstraint;
    }

    public boolean hasCheckConstraint() {
        return this.checkConstraint != null;
    }

    public String checkConstraint() {
        if (this.checkConstraint == null) {
            return null;
        }
        return " check (" + this.checkConstraint + ")";
    }

    @Override
    public String getTemplate(Dialect dialect, TypeConfiguration typeConfiguration, SqmFunctionRegistry functionRegistry) {
        return StringHelper.safeInterning((String)(this.hasCustomRead() ? Template.renderTransformerReadFragment(this.customRead, this.getQuotedName(dialect)) : "$PlaceHolder$." + this.getQuotedName(dialect)));
    }

    public boolean hasCustomRead() {
        return this.customRead != null;
    }

    public String getReadExpr(Dialect dialect) {
        return this.hasCustomRead() ? this.customRead : this.getQuotedName(dialect);
    }

    public String getWriteExpr() {
        return this.customWrite != null && this.customWrite.length() > 0 ? this.customWrite : "?";
    }

    @Override
    public boolean isFormula() {
        return false;
    }

    @Override
    public String getText(Dialect d) {
        return this.assignmentExpression != null ? this.assignmentExpression : this.getQuotedName(d);
    }

    @Override
    public String getText() {
        return this.assignmentExpression != null ? this.assignmentExpression : this.getName();
    }

    @Override
    public String getCustomReadExpression() {
        return this.customRead;
    }

    @Override
    public String getCustomWriteExpression() {
        return this.customWrite;
    }

    public Integer getPrecision() {
        return this.precision;
    }

    public void setPrecision(Integer precision) {
        this.precision = precision;
    }

    public Integer getScale() {
        return this.scale;
    }

    public void setScale(Integer scale) {
        this.scale = scale;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getGeneratedAs() {
        return this.generatedAs;
    }

    public void setGeneratedAs(String generatedAs) {
        this.generatedAs = generatedAs;
    }

    public String getAssignmentExpression() {
        return this.assignmentExpression;
    }

    public void setAssignmentExpression(String assignmentExpression) {
        this.assignmentExpression = assignmentExpression;
    }

    public String getCustomWrite() {
        return this.customWrite;
    }

    public void setCustomWrite(String customWrite) {
        this.customWrite = StringHelper.safeInterning(customWrite);
    }

    public String getCustomRead() {
        return this.customRead;
    }

    public void setResolvedCustomRead(String customRead) {
        assert (customRead == null || !StringHelper.isEmpty(customRead.trim()));
        this.customRead = StringHelper.safeInterning(customRead);
    }

    public void setCustomRead(String customRead) {
        this.customRead = StringHelper.safeInterning(StringHelper.nullIfEmpty(customRead));
    }

    public String getCanonicalName() {
        return this.quoted ? this.name : this.name.toLowerCase(Locale.ROOT);
    }

    public Column clone() {
        Column copy = new Column();
        copy.setLength(this.length);
        copy.setScale(this.scale);
        copy.setValue(this.value);
        copy.setTypeIndex(this.typeIndex);
        copy.setName(this.getQuotedName());
        copy.setNullable(this.nullable);
        copy.setPrecision(this.precision);
        copy.setUnique(this.unique);
        copy.setSqlType(this.sqlType);
        copy.setSqlTypeCode(this.sqlTypeCode);
        copy.uniqueInteger = this.uniqueInteger;
        copy.setCheckConstraint(this.checkConstraint);
        copy.setComment(this.comment);
        copy.setDefaultValue(this.defaultValue);
        copy.setGeneratedAs(this.generatedAs);
        copy.setAssignmentExpression(this.assignmentExpression);
        copy.setCustomRead(this.customRead);
        copy.setCustomWrite(this.customWrite);
        return copy;
    }
}

