/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.io.Serializable;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.Remove;
import org.hibernate.boot.model.relational.Exportable;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;

public abstract class Constraint
implements Exportable,
Serializable {
    private String name;
    private final ArrayList<Column> columns = new ArrayList();
    private Table table;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static String generateName(String prefix, Table table, Column ... columns) {
        StringBuilder sb = new StringBuilder("table`" + table.getName() + "`");
        Column[] alphabeticalColumns = (Column[])columns.clone();
        Arrays.sort(alphabeticalColumns, Comparator.comparing(Column::getName));
        for (Column column : alphabeticalColumns) {
            String columnName = column == null ? "" : column.getName();
            sb.append("column`").append(columnName).append("`");
        }
        return prefix + Constraint.hashedName(sb.toString());
    }

    public static String generateName(String prefix, Table table, List<Column> columns) {
        Column[] defensive = (Column[])columns.stream().filter(thing -> thing instanceof Column).toArray(Column[]::new);
        return Constraint.generateName(prefix, table, defensive);
    }

    public static String hashedName(String name) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.reset();
            md.update(name.getBytes());
            byte[] digest = md.digest();
            BigInteger bigInt = new BigInteger(1, digest);
            return bigInt.toString(35);
        }
        catch (NoSuchAlgorithmException e) {
            throw new HibernateException("Unable to generate a hashed Constraint name", e);
        }
    }

    public void addColumn(Column column) {
        if (!this.columns.contains(column)) {
            this.columns.add(column);
        }
    }

    public void addColumns(Value value) {
        for (Selectable selectable : value.getSelectables()) {
            if (selectable.isFormula()) {
                throw new MappingException("constraint involves a formula: " + this.name);
            }
            this.addColumn((Column)selectable);
        }
    }

    public boolean containsColumn(Column column) {
        return this.columns.contains(column);
    }

    public int getColumnSpan() {
        return this.columns.size();
    }

    public Column getColumn(int i) {
        return this.columns.get(i);
    }

    @Deprecated(since="6.0")
    public Iterator<Column> getColumnIterator() {
        return this.getColumns().iterator();
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public boolean isGenerated(Dialect dialect) {
        return true;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    @Deprecated(since="6.2")
    @Remove
    public abstract String sqlConstraintString(SqlStringGenerationContext var1, String var2, String var3, String var4);

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getTable().getName() + this.getColumns() + ") as " + this.name;
    }

    public abstract String generatedConstraintNamePrefix();
}

