/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.hibernate.AssertionFailure;
import org.hibernate.FetchMode;
import org.hibernate.Internal;
import org.hibernate.MappingException;
import org.hibernate.Remove;
import org.hibernate.TimeZoneStorageStrategy;
import org.hibernate.annotations.OnDeleteAction;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.boot.model.convert.internal.ClassBasedConverterDescriptor;
import org.hibernate.boot.model.convert.spi.ConverterDescriptor;
import org.hibernate.boot.model.convert.spi.JpaAttributeConverterCreationContext;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.generator.Generator;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.IdentityGenerator;
import org.hibernate.id.factory.IdentifierGeneratorFactory;
import org.hibernate.id.factory.internal.IdentifierGeneratorUtil;
import org.hibernate.id.factory.spi.CustomIdGeneratorCreationContext;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Formula;
import org.hibernate.mapping.IdentifierGeneratorCreator;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;
import org.hibernate.mapping.ValueVisitor;
import org.hibernate.metamodel.model.convert.spi.JpaAttributeConverter;
import org.hibernate.resource.beans.spi.ManagedBeanRegistry;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.JdbcTypeNameMapper;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.descriptor.jdbc.LobTypeMappings;
import org.hibernate.type.descriptor.jdbc.NationalizedTypeMappings;
import org.hibernate.type.internal.ConvertedBasicTypeImpl;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.usertype.DynamicParameterizedType;

public abstract class SimpleValue
implements KeyValue {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(SimpleValue.class);
    public static final String DEFAULT_ID_GEN_STRATEGY = "assigned";
    private final MetadataBuildingContext buildingContext;
    private final MetadataImplementor metadata;
    private final List<Selectable> columns = new ArrayList<Selectable>();
    private final List<Boolean> insertability = new ArrayList<Boolean>();
    private final List<Boolean> updatability = new ArrayList<Boolean>();
    private boolean partitionKey;
    private String typeName;
    private Properties typeParameters;
    private boolean isVersion;
    private boolean isNationalized;
    private boolean isLob;
    private Map<String, Object> identifierGeneratorParameters;
    private String identifierGeneratorStrategy = "assigned";
    private String nullValue;
    private Table table;
    private String foreignKeyName;
    private String foreignKeyDefinition;
    private boolean alternateUniqueKey;
    private OnDeleteAction onDeleteAction;
    private boolean foreignKeyEnabled = true;
    private ConverterDescriptor attributeConverterDescriptor;
    private Type type;
    private IdentifierGeneratorCreator customIdGeneratorCreator;
    private Generator generator;

    public SimpleValue(MetadataBuildingContext buildingContext) {
        this.buildingContext = buildingContext;
        this.metadata = buildingContext.getMetadataCollector();
    }

    public SimpleValue(MetadataBuildingContext buildingContext, Table table) {
        this(buildingContext);
        this.table = table;
    }

    protected SimpleValue(SimpleValue original) {
        this.buildingContext = original.buildingContext;
        this.metadata = original.metadata;
        this.columns.addAll(original.columns);
        this.insertability.addAll(original.insertability);
        this.updatability.addAll(original.updatability);
        this.partitionKey = original.partitionKey;
        this.typeName = original.typeName;
        this.typeParameters = original.typeParameters == null ? null : new Properties(original.typeParameters);
        this.isVersion = original.isVersion;
        this.isNationalized = original.isNationalized;
        this.isLob = original.isLob;
        this.identifierGeneratorParameters = original.identifierGeneratorParameters;
        this.identifierGeneratorStrategy = original.identifierGeneratorStrategy;
        this.nullValue = original.nullValue;
        this.table = original.table;
        this.foreignKeyName = original.foreignKeyName;
        this.foreignKeyDefinition = original.foreignKeyDefinition;
        this.alternateUniqueKey = original.alternateUniqueKey;
        this.onDeleteAction = original.onDeleteAction;
        this.attributeConverterDescriptor = original.attributeConverterDescriptor;
        this.type = original.type;
        this.customIdGeneratorCreator = original.customIdGeneratorCreator;
        this.generator = original.generator;
    }

    public MetadataBuildingContext getBuildingContext() {
        return this.buildingContext;
    }

    public MetadataImplementor getMetadata() {
        return this.metadata;
    }

    @Override
    public ServiceRegistry getServiceRegistry() {
        return this.getMetadata().getMetadataBuildingOptions().getServiceRegistry();
    }

    public void setOnDeleteAction(OnDeleteAction onDeleteAction) {
        this.onDeleteAction = onDeleteAction;
    }

    public OnDeleteAction getOnDeleteAction() {
        return this.onDeleteAction;
    }

    @Override
    @Deprecated(since="6.2")
    public boolean isCascadeDeleteEnabled() {
        return this.onDeleteAction == OnDeleteAction.CASCADE;
    }

    @Deprecated(since="6.2")
    public void setCascadeDeleteEnabled(boolean cascadeDeleteEnabled) {
        this.onDeleteAction = cascadeDeleteEnabled ? OnDeleteAction.CASCADE : OnDeleteAction.NO_ACTION;
    }

    public void addColumn(Column column) {
        this.addColumn(column, true, true);
    }

    public void addColumn(Column column, boolean isInsertable, boolean isUpdatable) {
        this.justAddColumn(column, isInsertable, isUpdatable);
        column.setValue(this);
        column.setTypeIndex(this.columns.size() - 1);
    }

    public void addFormula(Formula formula) {
        this.justAddFormula(formula);
    }

    protected void justAddColumn(Column column) {
        this.justAddColumn(column, true, true);
    }

    protected void justAddColumn(Column column, boolean insertable, boolean updatable) {
        int index = this.columns.indexOf(column);
        if (index == -1) {
            this.columns.add(column);
            this.insertability.add(insertable);
            this.updatability.add(updatable);
        } else {
            if (this.insertability.get(index) != insertable) {
                throw new IllegalStateException("Same column is added more than once with different values for isInsertable");
            }
            if (this.updatability.get(index) != updatable) {
                throw new IllegalStateException("Same column is added more than once with different values for isUpdatable");
            }
        }
    }

    protected void justAddFormula(Formula formula) {
        this.columns.add(formula);
        this.insertability.add(false);
        this.updatability.add(false);
    }

    public void sortColumns(int[] originalOrder) {
        if (this.columns.size() > 1) {
            Selectable[] originalColumns = this.columns.toArray(new Selectable[0]);
            boolean[] originalInsertability = ArrayHelper.toBooleanArray(this.insertability);
            boolean[] originalUpdatability = ArrayHelper.toBooleanArray(this.updatability);
            for (int i = 0; i < originalOrder.length; ++i) {
                int originalIndex = originalOrder[i];
                Selectable selectable = originalColumns[i];
                if (selectable instanceof Column) {
                    ((Column)selectable).setTypeIndex(originalIndex);
                }
                this.columns.set(originalIndex, selectable);
                this.insertability.set(originalIndex, originalInsertability[i]);
                this.updatability.set(originalIndex, originalUpdatability[i]);
            }
        }
    }

    @Override
    public boolean hasFormula() {
        for (Selectable selectable : this.getSelectables()) {
            if (!(selectable instanceof Formula)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getColumnSpan() {
        return this.columns.size();
    }

    protected Selectable getColumn(int position) {
        return this.columns.get(position);
    }

    @Override
    @Deprecated
    public Iterator<Selectable> getColumnIterator() {
        return this.columns.iterator();
    }

    @Override
    public List<Selectable> getSelectables() {
        return this.columns;
    }

    @Override
    public List<Column> getColumns() {
        if (this.hasFormula()) {
            throw new AssertionFailure("value involves formulas");
        }
        return this.columns;
    }

    public Iterator<Selectable> getConstraintColumnIterator() {
        return this.getColumnIterator();
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        if (typeName != null && typeName.startsWith("converted::")) {
            String converterClassName = typeName.substring("converted::".length());
            ClassLoaderService cls = this.getMetadata().getMetadataBuildingOptions().getServiceRegistry().getService(ClassLoaderService.class);
            try {
                Class converterClass = cls.classForName(converterClassName);
                this.attributeConverterDescriptor = new ClassBasedConverterDescriptor(converterClass, false, ((InFlightMetadataCollector)this.getMetadata()).getBootstrapContext().getClassmateContext());
                return;
            }
            catch (Exception e) {
                log.logBadHbmAttributeConverterType(typeName, e.getMessage());
            }
        }
        this.typeName = typeName;
    }

    public void makeVersion() {
        this.isVersion = true;
    }

    public boolean isVersion() {
        return this.isVersion;
    }

    public void makeNationalized() {
        this.isNationalized = true;
    }

    public boolean isNationalized() {
        return this.isNationalized;
    }

    public void makeLob() {
        this.isLob = true;
    }

    public boolean isLob() {
        return this.isLob;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    @Override
    public void createForeignKey() throws MappingException {
    }

    @Override
    public ForeignKey createForeignKeyOfEntity(String entityName) {
        if (this.isConstrained()) {
            ForeignKey fk = this.table.createForeignKey(this.getForeignKeyName(), this.getConstraintColumns(), entityName, this.getForeignKeyDefinition());
            fk.setOnDeleteAction(this.onDeleteAction);
            return fk;
        }
        return null;
    }

    @Override
    public void createUniqueKey() {
        if (this.hasFormula()) {
            throw new MappingException("unique key constraint involves formulas");
        }
        this.getTable().createUniqueKey(this.getConstraintColumns());
    }

    @Deprecated(since="6.0")
    public IdentifierGenerator getIdentifierGenerator() {
        return (IdentifierGenerator)this.generator;
    }

    @Internal
    public void setCustomIdGeneratorCreator(IdentifierGeneratorCreator customIdGeneratorCreator) {
        this.customIdGeneratorCreator = customIdGeneratorCreator;
    }

    @Internal
    public IdentifierGeneratorCreator getCustomIdGeneratorCreator() {
        return this.customIdGeneratorCreator;
    }

    @Override
    public Generator createGenerator(IdentifierGeneratorFactory identifierGeneratorFactory, Dialect dialect, RootClass rootClass) throws MappingException {
        if (this.generator != null) {
            return this.generator;
        }
        if (this.customIdGeneratorCreator != null) {
            this.generator = this.customIdGeneratorCreator.createGenerator(new IdGeneratorCreationContext(identifierGeneratorFactory, null, null, rootClass));
            return this.generator;
        }
        this.generator = IdentifierGeneratorUtil.createLegacyIdentifierGenerator(this, identifierGeneratorFactory, dialect, null, null, rootClass);
        return this.generator;
    }

    @Override
    public boolean isUpdateable() {
        return true;
    }

    @Override
    public FetchMode getFetchMode() {
        return FetchMode.SELECT;
    }

    @Override
    public Table getTable() {
        return this.table;
    }

    public String getIdentifierGeneratorStrategy() {
        return this.identifierGeneratorStrategy;
    }

    public void setIdentifierGeneratorStrategy(String identifierGeneratorStrategy) {
        this.identifierGeneratorStrategy = identifierGeneratorStrategy;
    }

    @Override
    @Deprecated
    public boolean isIdentityColumn(IdentifierGeneratorFactory identifierGeneratorFactory, Dialect dialect) {
        return IdentityGenerator.class.isAssignableFrom(identifierGeneratorFactory.getIdentifierGeneratorClass(this.identifierGeneratorStrategy));
    }

    public Map<String, Object> getIdentifierGeneratorParameters() {
        return this.identifierGeneratorParameters;
    }

    public void setIdentifierGeneratorParameters(Map<String, Object> identifierGeneratorParameters) {
        this.identifierGeneratorParameters = identifierGeneratorParameters;
    }

    @Deprecated
    @Remove
    public Properties getIdentifierGeneratorProperties() {
        Properties properties = new Properties();
        properties.putAll(this.identifierGeneratorParameters);
        return properties;
    }

    @Deprecated
    @Remove
    public void setIdentifierGeneratorProperties(Properties identifierGeneratorProperties) {
        this.identifierGeneratorParameters = new HashMap<String, Object>();
        identifierGeneratorProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            if (key instanceof String) {
                this.identifierGeneratorParameters.put((String)key, value);
            }
        }));
    }

    @Deprecated
    @Remove
    public void setIdentifierGeneratorProperties(Map<String, Object> identifierGeneratorProperties) {
        this.identifierGeneratorParameters = identifierGeneratorProperties;
    }

    @Override
    public String getNullValue() {
        return this.nullValue;
    }

    public void setNullValue(String nullValue) {
        this.nullValue = nullValue;
    }

    public String getForeignKeyName() {
        return this.foreignKeyName;
    }

    public void setForeignKeyName(String foreignKeyName) {
        if ("none".equals(foreignKeyName)) {
            this.foreignKeyEnabled = false;
        }
        this.foreignKeyName = foreignKeyName;
    }

    public boolean isForeignKeyEnabled() {
        return this.foreignKeyEnabled;
    }

    public void disableForeignKey() {
        this.foreignKeyEnabled = false;
    }

    public boolean isConstrained() {
        return this.isForeignKeyEnabled() && !this.hasFormula();
    }

    public String getForeignKeyDefinition() {
        return this.foreignKeyDefinition;
    }

    public void setForeignKeyDefinition(String foreignKeyDefinition) {
        this.foreignKeyDefinition = foreignKeyDefinition;
    }

    @Override
    public boolean isAlternateUniqueKey() {
        return this.alternateUniqueKey;
    }

    public void setAlternateUniqueKey(boolean unique) {
        this.alternateUniqueKey = unique;
    }

    @Override
    public boolean isNullable() {
        for (Selectable selectable : this.getSelectables()) {
            if (selectable instanceof Formula) {
                return true;
            }
            if (((Column)selectable).isNullable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSimpleValue() {
        return true;
    }

    @Override
    public boolean isValid(Mapping mapping) throws MappingException {
        return this.getColumnSpan() == this.getType().getColumnSpan(mapping);
    }

    protected void setAttributeConverterDescriptor(ConverterDescriptor descriptor) {
        this.attributeConverterDescriptor = descriptor;
    }

    protected ConverterDescriptor getAttributeConverterDescriptor() {
        return this.attributeConverterDescriptor;
    }

    @Override
    public void setTypeUsingReflection(String className, String propertyName) throws MappingException {
        if (this.typeName != null) {
            return;
        }
        if (this.type != null) {
            return;
        }
        if (this.attributeConverterDescriptor == null) {
            if (className == null) {
                throw new MappingException("Attribute types for a dynamic entity must be explicitly specified: " + propertyName);
            }
            this.typeName = this.getClass(className, propertyName).getName();
            return;
        }
        this.type = this.buildAttributeConverterTypeAdapter();
    }

    private Class<?> getClass(String className, String propertyName) {
        return ReflectHelper.reflectedPropertyClass(className, propertyName, this.getMetadata().getMetadataBuildingOptions().getServiceRegistry().getService(ClassLoaderService.class));
    }

    private Type buildAttributeConverterTypeAdapter() {
        return this.buildAttributeConverterTypeAdapter(this.attributeConverterDescriptor.createJpaAttributeConverter(new JpaAttributeConverterCreationContext(){

            @Override
            public ManagedBeanRegistry getManagedBeanRegistry() {
                return SimpleValue.this.getMetadata().getMetadataBuildingOptions().getServiceRegistry().getService(ManagedBeanRegistry.class);
            }

            @Override
            public TypeConfiguration getTypeConfiguration() {
                return SimpleValue.this.getMetadata().getTypeConfiguration();
            }
        }));
    }

    private <T> Type buildAttributeConverterTypeAdapter(JpaAttributeConverter<T, ?> jpaAttributeConverter) {
        JavaType domainJavaType = jpaAttributeConverter.getDomainJavaType();
        JavaType relationalJavaType = jpaAttributeConverter.getRelationalJavaType();
        JdbcType recommendedJdbcType = relationalJavaType.getRecommendedJdbcType(new JdbcTypeIndicators(){

            @Override
            public TypeConfiguration getTypeConfiguration() {
                return SimpleValue.this.metadata.getTypeConfiguration();
            }

            @Override
            public TimeZoneStorageStrategy getDefaultTimeZoneStorageStrategy() {
                return SimpleValue.this.buildingContext.getBuildingOptions().getDefaultTimeZoneStorage();
            }
        });
        int jdbcTypeCode = recommendedJdbcType.getDdlTypeCode();
        if (this.isLob()) {
            if (LobTypeMappings.isMappedToKnownLobCode(jdbcTypeCode)) {
                jdbcTypeCode = LobTypeMappings.getLobCodeTypeMapping(jdbcTypeCode);
            } else if (Serializable.class.isAssignableFrom(domainJavaType.getJavaTypeClass())) {
                jdbcTypeCode = 2004;
            } else {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "JDBC type-code [%s (%s)] not known to have a corresponding LOB equivalent, and Java type is not Serializable (to use BLOB)", jdbcTypeCode, JdbcTypeNameMapper.getTypeName(jdbcTypeCode)));
            }
        }
        if (this.isNationalized()) {
            jdbcTypeCode = NationalizedTypeMappings.toNationalizedTypeCode(jdbcTypeCode);
        }
        return new ConvertedBasicTypeImpl<T>("converted::" + jpaAttributeConverter.getConverterJavaType().getJavaType().getTypeName(), String.format("BasicType adapter for AttributeConverter<%s,%s>", domainJavaType.getJavaType().getTypeName(), relationalJavaType.getJavaType().getTypeName()), this.metadata.getTypeConfiguration().getJdbcTypeRegistry().getDescriptor(jdbcTypeCode), jpaAttributeConverter);
    }

    public boolean isTypeSpecified() {
        return this.typeName != null;
    }

    public void setTypeParameters(Properties parameterMap) {
        this.typeParameters = parameterMap;
    }

    public void setTypeParameters(Map<String, ?> parameters) {
        if (parameters != null) {
            Properties properties = new Properties();
            properties.putAll(parameters);
            this.setTypeParameters(properties);
        }
    }

    public Properties getTypeParameters() {
        return this.typeParameters;
    }

    public void copyTypeFrom(SimpleValue sourceValue) {
        this.setTypeName(sourceValue.getTypeName());
        this.setTypeParameters(sourceValue.getTypeParameters());
        this.type = sourceValue.type;
        this.attributeConverterDescriptor = sourceValue.attributeConverterDescriptor;
    }

    @Override
    public boolean isSame(Value other) {
        return this == other || other instanceof SimpleValue && this.isSame((SimpleValue)other);
    }

    protected static boolean isSame(Value v1, Value v2) {
        return v1 == v2 || v1 != null && v2 != null && v1.isSame(v2);
    }

    public boolean isSame(SimpleValue other) {
        return Objects.equals(this.columns, other.columns) && Objects.equals(this.typeName, other.typeName) && Objects.equals(this.typeParameters, other.typeParameters) && Objects.equals(this.table, other.table) && Objects.equals(this.foreignKeyName, other.foreignKeyName) && Objects.equals(this.foreignKeyDefinition, other.foreignKeyDefinition);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.columns + ")";
    }

    @Override
    public Object accept(ValueVisitor visitor) {
        return visitor.accept(this);
    }

    @Override
    public boolean[] getColumnInsertability() {
        return SimpleValue.extractBooleansFromList(this.insertability);
    }

    @Override
    public boolean hasAnyInsertableColumns() {
        for (int i = 0; i < this.insertability.size(); ++i) {
            if (!this.insertability.get(i).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean[] getColumnUpdateability() {
        return SimpleValue.extractBooleansFromList(this.updatability);
    }

    @Override
    public boolean hasAnyUpdatableColumns() {
        for (int i = 0; i < this.updatability.size(); ++i) {
            if (!this.updatability.get(i).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isColumnInsertable(int index) {
        if (this.insertability.size() > 0) {
            return this.insertability.get(index);
        }
        return false;
    }

    @Override
    public boolean isColumnUpdateable(int index) {
        if (this.updatability.size() > 0) {
            return this.updatability.get(index);
        }
        return false;
    }

    public boolean isPartitionKey() {
        return this.partitionKey;
    }

    public void setPartitionKey(boolean partitionColumn) {
        this.partitionKey = partitionColumn;
    }

    private static boolean[] extractBooleansFromList(List<Boolean> list) {
        boolean[] array = new boolean[list.size()];
        int i = 0;
        for (Boolean value : list) {
            array[i++] = value;
        }
        return array;
    }

    public ConverterDescriptor getJpaAttributeConverterDescriptor() {
        return this.attributeConverterDescriptor;
    }

    public void setJpaAttributeConverterDescriptor(ConverterDescriptor descriptor) {
        this.attributeConverterDescriptor = descriptor;
    }

    protected void createParameterImpl() {
        try {
            String[] columnNames = new String[this.columns.size()];
            Long[] columnLengths = new Long[this.columns.size()];
            for (int i = 0; i < this.columns.size(); ++i) {
                Selectable selectable = this.columns.get(i);
                if (!(selectable instanceof Column)) continue;
                Column column = (Column)selectable;
                columnNames[i] = column.getName();
                columnLengths[i] = column.getLength();
            }
            XProperty xProperty = (XProperty)this.typeParameters.get("org.hibernate.type.ParameterType.xproperty");
            Annotation[] annotations = xProperty == null ? null : xProperty.getAnnotations();
            ClassLoaderService classLoaderService = this.getMetadata().getMetadataBuildingOptions().getServiceRegistry().getService(ClassLoaderService.class);
            this.typeParameters.put("org.hibernate.type.ParameterType", new ParameterTypeImpl(classLoaderService.classForTypeName(this.typeParameters.getProperty("org.hibernate.type.ParameterType.returnedClass")), annotations, this.table.getCatalog(), this.table.getSchema(), this.table.getName(), Boolean.parseBoolean(this.typeParameters.getProperty("org.hibernate.type.ParameterType.primaryKey")), columnNames, columnLengths));
        }
        catch (ClassLoadingException e) {
            throw new MappingException("Could not create DynamicParameterizedType for type: " + this.typeName, (Throwable)((Object)e));
        }
    }

    public DynamicParameterizedType.ParameterType makeParameterImpl() {
        try {
            String[] columnNames = new String[this.columns.size()];
            Long[] columnLengths = new Long[this.columns.size()];
            for (int i = 0; i < this.columns.size(); ++i) {
                Selectable selectable = this.columns.get(i);
                if (!(selectable instanceof Column)) continue;
                Column column = (Column)selectable;
                columnNames[i] = column.getName();
                columnLengths[i] = column.getLength();
            }
            XProperty xProperty = (XProperty)this.typeParameters.get("org.hibernate.type.ParameterType.xproperty");
            Annotation[] annotations = xProperty == null ? null : xProperty.getAnnotations();
            ClassLoaderService classLoaderService = this.getMetadata().getMetadataBuildingOptions().getServiceRegistry().getService(ClassLoaderService.class);
            return new ParameterTypeImpl(classLoaderService.classForTypeName(this.typeParameters.getProperty("org.hibernate.type.ParameterType.returnedClass")), annotations, this.table.getCatalog(), this.table.getSchema(), this.table.getName(), Boolean.parseBoolean(this.typeParameters.getProperty("org.hibernate.type.ParameterType.primaryKey")), columnNames, columnLengths);
        }
        catch (ClassLoadingException e) {
            throw new MappingException("Could not create DynamicParameterizedType for type: " + this.typeName, (Throwable)((Object)e));
        }
    }

    private class IdGeneratorCreationContext
    implements CustomIdGeneratorCreationContext {
        private final IdentifierGeneratorFactory identifierGeneratorFactory;
        private final String defaultCatalog;
        private final String defaultSchema;
        private final RootClass rootClass;

        public IdGeneratorCreationContext(IdentifierGeneratorFactory identifierGeneratorFactory, String defaultCatalog, String defaultSchema, RootClass rootClass) {
            this.identifierGeneratorFactory = identifierGeneratorFactory;
            this.defaultCatalog = defaultCatalog;
            this.defaultSchema = defaultSchema;
            this.rootClass = rootClass;
        }

        @Override
        public IdentifierGeneratorFactory getIdentifierGeneratorFactory() {
            return this.identifierGeneratorFactory;
        }

        @Override
        public Database getDatabase() {
            return SimpleValue.this.buildingContext.getMetadataCollector().getDatabase();
        }

        @Override
        public ServiceRegistry getServiceRegistry() {
            return SimpleValue.this.buildingContext.getBootstrapContext().getServiceRegistry();
        }

        @Override
        public String getDefaultCatalog() {
            return this.defaultCatalog;
        }

        @Override
        public String getDefaultSchema() {
            return this.defaultSchema;
        }

        @Override
        public RootClass getRootClass() {
            return this.rootClass;
        }

        @Override
        public PersistentClass getPersistentClass() {
            return this.rootClass;
        }

        @Override
        public Property getProperty() {
            return this.rootClass.getIdentifierProperty();
        }
    }

    private static final class ParameterTypeImpl
    implements DynamicParameterizedType.ParameterType {
        private final Class<?> returnedClass;
        private final Annotation[] annotationsMethod;
        private final String catalog;
        private final String schema;
        private final String table;
        private final boolean primaryKey;
        private final String[] columns;
        private final Long[] columnLengths;

        private ParameterTypeImpl(Class<?> returnedClass, Annotation[] annotationsMethod, String catalog, String schema, String table, boolean primaryKey, String[] columns, Long[] columnLengths) {
            this.returnedClass = returnedClass;
            this.annotationsMethod = annotationsMethod;
            this.catalog = catalog;
            this.schema = schema;
            this.table = table;
            this.primaryKey = primaryKey;
            this.columns = columns;
            this.columnLengths = columnLengths;
        }

        @Override
        public Class<?> getReturnedClass() {
            return this.returnedClass;
        }

        @Override
        public Annotation[] getAnnotationsMethod() {
            return this.annotationsMethod;
        }

        @Override
        public String getCatalog() {
            return this.catalog;
        }

        @Override
        public String getSchema() {
            return this.schema;
        }

        @Override
        public String getTable() {
            return this.table;
        }

        @Override
        public boolean isPrimaryKey() {
            return this.primaryKey;
        }

        @Override
        public String[] getColumns() {
            return this.columns;
        }

        @Override
        public Long[] getColumnLengths() {
            return this.columnLengths;
        }
    }
}

