/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.internal;

import org.hibernate.InstantiationException;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.metamodel.internal.EmbeddableHelper;
import org.hibernate.metamodel.internal.EmbeddableInstantiatorRecordStandard;
import org.hibernate.metamodel.spi.ValueAccess;

public class EmbeddableInstantiatorRecordIndirecting
extends EmbeddableInstantiatorRecordStandard {
    protected final int[] index;

    public EmbeddableInstantiatorRecordIndirecting(Class<?> javaType, int[] index) {
        super(javaType);
        this.index = index;
    }

    public static EmbeddableInstantiatorRecordIndirecting of(Class<?> javaType, String[] propertyNames) {
        int[] index;
        String[] componentNames = ReflectHelper.getRecordComponentNames(javaType);
        if (EmbeddableHelper.resolveIndex(propertyNames, componentNames, index = new int[componentNames.length])) {
            return new EmbeddableInstantiatorRecordIndirectingWithGap(javaType, index);
        }
        return new EmbeddableInstantiatorRecordIndirecting(javaType, index);
    }

    @Override
    public Object instantiate(ValueAccess valuesAccess, SessionFactoryImplementor sessionFactory) {
        if (this.constructor == null) {
            throw new InstantiationException("Unable to locate constructor for embeddable", this.getMappedPojoClass());
        }
        try {
            Object[] originalValues = valuesAccess.getValues();
            Object[] values = new Object[originalValues.length];
            for (int i = 0; i < values.length; ++i) {
                values[i] = originalValues[this.index[i]];
            }
            return this.constructor.newInstance(values);
        }
        catch (Exception e) {
            throw new InstantiationException("Could not instantiate entity: ", this.getMappedPojoClass(), e);
        }
    }

    private static class EmbeddableInstantiatorRecordIndirectingWithGap
    extends EmbeddableInstantiatorRecordIndirecting {
        public EmbeddableInstantiatorRecordIndirectingWithGap(Class<?> javaType, int[] index) {
            super(javaType, index);
        }

        @Override
        public Object instantiate(ValueAccess valuesAccess, SessionFactoryImplementor sessionFactory) {
            if (this.constructor == null) {
                throw new InstantiationException("Unable to locate constructor for embeddable", this.getMappedPojoClass());
            }
            try {
                Object[] originalValues = valuesAccess.getValues();
                Object[] values = new Object[this.index.length];
                for (int i = 0; i < values.length; ++i) {
                    int index = this.index[i];
                    if (index < 0) continue;
                    values[i] = originalValues[index];
                }
                return this.constructor.newInstance(values);
            }
            catch (Exception e) {
                throw new InstantiationException("Could not instantiate entity: ", this.getMappedPojoClass(), e);
            }
        }
    }
}

