/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.internal;

import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.function.Supplier;
import org.hibernate.HibernateException;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.bytecode.spi.ProxyFactoryFactory;
import org.hibernate.bytecode.spi.ReflectionOptimizer;
import org.hibernate.cfg.Environment;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.mapping.Backref;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.IndexBackref;
import org.hibernate.mapping.Property;
import org.hibernate.metamodel.RepresentationMode;
import org.hibernate.metamodel.internal.AbstractEmbeddableRepresentationStrategy;
import org.hibernate.metamodel.internal.EmbeddableInstantiatorPojoOptimized;
import org.hibernate.metamodel.internal.EmbeddableInstantiatorPojoStandard;
import org.hibernate.metamodel.internal.EmbeddableInstantiatorProxied;
import org.hibernate.metamodel.internal.StandardEmbeddableInstantiator;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.spi.EmbeddableInstantiator;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.property.access.internal.PropertyAccessStrategyBackRefImpl;
import org.hibernate.property.access.internal.PropertyAccessStrategyIndexBackRefImpl;
import org.hibernate.property.access.spi.BuiltInPropertyAccessStrategies;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.property.access.spi.PropertyAccessStrategy;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.spi.JavaTypeRegistry;
import org.hibernate.type.internal.CompositeUserTypeJavaTypeWrapper;
import org.hibernate.usertype.CompositeUserType;

public class EmbeddableRepresentationStrategyPojo
extends AbstractEmbeddableRepresentationStrategy {
    private final StrategySelector strategySelector;
    private final ReflectionOptimizer reflectionOptimizer;
    private final EmbeddableInstantiator instantiator;

    public EmbeddableRepresentationStrategyPojo(Component bootDescriptor, Supplier<EmbeddableMappingType> runtimeDescriptorAccess, EmbeddableInstantiator customInstantiator, CompositeUserType<Object> compositeUserType, RuntimeModelCreationContext creationContext) {
        super(bootDescriptor, EmbeddableRepresentationStrategyPojo.resolveEmbeddableJavaType(bootDescriptor, compositeUserType, creationContext), creationContext);
        assert (bootDescriptor.getComponentClass() != null);
        this.strategySelector = creationContext.getSessionFactory().getServiceRegistry().getService(StrategySelector.class);
        this.reflectionOptimizer = this.buildReflectionOptimizer(bootDescriptor, creationContext);
        ConfigurationService configurationService = creationContext.getMetadata().getMetadataBuildingOptions().getServiceRegistry().getService(ConfigurationService.class);
        boolean createEmptyCompositesEnabled = ConfigurationHelper.getBoolean("hibernate.create_empty_composites.enabled", configurationService.getSettings(), false);
        this.instantiator = customInstantiator != null ? customInstantiator : this.determineInstantiator(bootDescriptor, runtimeDescriptorAccess, creationContext);
    }

    private static <T> JavaType<T> resolveEmbeddableJavaType(Component bootDescriptor, CompositeUserType<T> compositeUserType, RuntimeModelCreationContext creationContext) {
        JavaTypeRegistry javaTypeRegistry = creationContext.getTypeConfiguration().getJavaTypeRegistry();
        if (compositeUserType == null) {
            return javaTypeRegistry.resolveDescriptor(bootDescriptor.getComponentClass());
        }
        return javaTypeRegistry.resolveDescriptor(compositeUserType.returnedClass(), () -> new CompositeUserTypeJavaTypeWrapper(compositeUserType));
    }

    private EmbeddableInstantiator determineInstantiator(Component bootDescriptor, Supplier<EmbeddableMappingType> runtimeDescriptorAccess, RuntimeModelCreationContext creationContext) {
        if (this.reflectionOptimizer != null && this.reflectionOptimizer.getInstantiationOptimizer() != null) {
            ReflectionOptimizer.InstantiationOptimizer instantiationOptimizer = this.reflectionOptimizer.getInstantiationOptimizer();
            return new EmbeddableInstantiatorPojoOptimized(this.getEmbeddableJavaType(), runtimeDescriptorAccess, instantiationOptimizer);
        }
        if (bootDescriptor.isEmbedded() && ReflectHelper.isAbstractClass(bootDescriptor.getComponentClass())) {
            ProxyFactoryFactory proxyFactoryFactory = creationContext.getSessionFactory().getServiceRegistry().getService(ProxyFactoryFactory.class);
            return new EmbeddableInstantiatorProxied(bootDescriptor.getComponentClass(), runtimeDescriptorAccess, proxyFactoryFactory.buildBasicProxyFactory(bootDescriptor.getComponentClass()));
        }
        return new EmbeddableInstantiatorPojoStandard(this.getEmbeddableJavaType(), runtimeDescriptorAccess);
    }

    @Override
    public ReflectionOptimizer getReflectionOptimizer() {
        return this.reflectionOptimizer;
    }

    @Override
    protected PropertyAccess buildPropertyAccess(Property bootAttributeDescriptor) {
        PropertyAccessStrategy strategy = bootAttributeDescriptor.getPropertyAccessStrategy(this.getEmbeddableJavaType().getJavaTypeClass());
        if (strategy == null) {
            String propertyAccessorName = bootAttributeDescriptor.getPropertyAccessorName();
            if (StringHelper.isNotEmpty(propertyAccessorName)) {
                strategy = this.strategySelector.resolveStrategy(PropertyAccessStrategy.class, propertyAccessorName);
            } else if (bootAttributeDescriptor instanceof Backref) {
                Backref backref = (Backref)bootAttributeDescriptor;
                strategy = new PropertyAccessStrategyBackRefImpl(backref.getCollectionRole(), backref.getEntityName());
            } else if (bootAttributeDescriptor instanceof IndexBackref) {
                IndexBackref indexBackref = (IndexBackref)bootAttributeDescriptor;
                strategy = new PropertyAccessStrategyIndexBackRefImpl(indexBackref.getCollectionRole(), indexBackref.getEntityName());
            } else {
                strategy = BuiltInPropertyAccessStrategies.MIXED.getStrategy();
            }
        }
        if (strategy == null) {
            throw new HibernateException(String.format(Locale.ROOT, "Could not resolve PropertyAccess for attribute `%s#%s`", this.getEmbeddableJavaType().getJavaType().getTypeName(), bootAttributeDescriptor.getName()));
        }
        return strategy.buildPropertyAccess(this.getEmbeddableJavaType().getJavaTypeClass(), bootAttributeDescriptor.getName(), this.instantiator instanceof StandardEmbeddableInstantiator);
    }

    private ReflectionOptimizer buildReflectionOptimizer(Component bootDescriptor, RuntimeModelCreationContext creationContext) {
        if (!Environment.useReflectionOptimizer()) {
            return null;
        }
        if (this.hasCustomAccessors() || bootDescriptor.getCustomInstantiator() != null || bootDescriptor.getInstantiator() != null) {
            return null;
        }
        LinkedHashMap<String, PropertyAccess> propertyAccessMap = new LinkedHashMap<String, PropertyAccess>();
        int i = 0;
        for (Property property : bootDescriptor.getProperties()) {
            propertyAccessMap.put(property.getName(), this.getPropertyAccesses()[i]);
            ++i;
        }
        return Environment.getBytecodeProvider().getReflectionOptimizer(bootDescriptor.getComponentClass(), propertyAccessMap);
    }

    @Override
    public RepresentationMode getMode() {
        return RepresentationMode.POJO;
    }

    @Override
    public EmbeddableInstantiator getInstantiator() {
        return this.instantiator;
    }
}

