/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping;

import java.io.Serializable;
import java.util.Objects;
import org.hibernate.Incubating;

@Incubating
public class SelectablePath
implements Serializable {
    private final SelectablePath parent;
    private final String name;
    private final int index;

    public SelectablePath(String root) {
        this.parent = null;
        this.name = root.intern();
        this.index = 0;
    }

    private SelectablePath(SelectablePath parent, String name) {
        this.parent = parent;
        this.name = name;
        this.index = parent.index + 1;
    }

    public SelectablePath[] getParts() {
        SelectablePath[] array = new SelectablePath[this.index + 1];
        this.parts(array);
        return array;
    }

    private void parts(SelectablePath[] array) {
        if (this.parent != null) {
            this.parent.parts(array);
        }
        array[this.index] = this;
    }

    public SelectablePath[] relativize(SelectablePath basePath) {
        SelectablePath[] array = new SelectablePath[this.index - basePath.index];
        this.relativize(array, basePath);
        return array;
    }

    private boolean relativize(SelectablePath[] array, SelectablePath basePath) {
        if (this.equals(basePath)) {
            return true;
        }
        if (this.parent != null && this.parent.relativize(array, basePath)) {
            array[this.index - basePath.index - 1] = this;
            return true;
        }
        return false;
    }

    public String getSelectableName() {
        return this.name;
    }

    public SelectablePath getParent() {
        return this.parent;
    }

    public SelectablePath append(String selectableName) {
        return new SelectablePath(this, selectableName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.name.length() * this.index);
        this.toString(sb);
        return sb.toString();
    }

    private void toString(StringBuilder sb) {
        if (this.parent != null) {
            this.parent.toString(sb);
            sb.append('.');
        }
        sb.append(this.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SelectablePath that = (SelectablePath)o;
        if (!Objects.equals(this.parent, that.parent)) {
            return false;
        }
        return this.name.equals(that.name);
    }

    public int hashCode() {
        int result = this.parent != null ? this.parent.hashCode() : 0;
        result = 31 * result + this.name.hashCode();
        return result;
    }
}

