/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.io.Serializable;
import java.util.Locale;
import java.util.function.Consumer;
import org.hibernate.MappingException;
import org.hibernate.SharedSessionContract;
import org.hibernate.bytecode.spi.ReflectionOptimizer;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.CascadeStyle;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.mapping.Any;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Value;
import org.hibernate.metamodel.UnsupportedMappingException;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.ManagedMappingType;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.SelectableMappings;
import org.hibernate.metamodel.mapping.SelectablePath;
import org.hibernate.metamodel.mapping.internal.AbstractSingularAttributeMapping;
import org.hibernate.metamodel.mapping.internal.BasicAttributeMapping;
import org.hibernate.metamodel.mapping.internal.DiscriminatedAssociationAttributeMapping;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationHelper;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.metamodel.mapping.internal.SelectableMappingsImpl;
import org.hibernate.metamodel.mapping.internal.SimpleAttributeMetadata;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.metamodel.spi.EmbeddableRepresentationStrategy;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.internal.MutableAttributeMappingList;
import org.hibernate.property.access.internal.PropertyAccessStrategyBackRefImpl;
import org.hibernate.property.access.spi.Getter;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.sql.ast.tree.from.TableGroupProducer;
import org.hibernate.type.AnyType;
import org.hibernate.type.BasicType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.spi.TypeConfiguration;

public abstract class AbstractEmbeddableMapping
implements EmbeddableMappingType {
    public AbstractEmbeddableMapping(MappingModelCreationProcess creationProcess) {
        this(creationProcess.getCreationContext());
    }

    public AbstractEmbeddableMapping(RuntimeModelCreationContext creationContext) {
    }

    @Override
    public JavaType<?> getMappedJavaType() {
        return this.getRepresentationStrategy().getMappedJavaType();
    }

    @Override
    public Object[] getValues(Object compositeInstance) {
        if (compositeInstance == PropertyAccessStrategyBackRefImpl.UNKNOWN) {
            return new Object[this.getNumberOfAttributeMappings()];
        }
        ReflectionOptimizer optimizer = this.getRepresentationStrategy().getReflectionOptimizer();
        if (optimizer != null && optimizer.getAccessOptimizer() != null) {
            return optimizer.getAccessOptimizer().getPropertyValues(compositeInstance);
        }
        Object[] results = new Object[this.getNumberOfAttributeMappings()];
        for (int i = 0; i < results.length; ++i) {
            Getter getter = this.getAttributeMapping(i).getAttributeMetadata().getPropertyAccess().getGetter();
            results[i] = getter.get(compositeInstance);
        }
        return results;
    }

    @Override
    public void setValues(Object component, Object[] values) {
        ReflectionOptimizer optimizer = this.getRepresentationStrategy().getReflectionOptimizer();
        if (optimizer != null && optimizer.getAccessOptimizer() != null) {
            optimizer.getAccessOptimizer().setPropertyValues(component, values);
        } else {
            for (int i = 0; i < values.length; ++i) {
                this.getAttributeMapping(i).getPropertyAccess().getSetter().set(component, values[i]);
            }
        }
    }

    protected static boolean inverseInitializeCallback(TableGroupProducer declaringTableGroupProducer, SelectableMappings selectableMappings, EmbeddableMappingType inverseMappingType, MappingModelCreationProcess creationProcess, ManagedMappingType declaringType, MutableAttributeMappingList mappings) {
        int size = inverseMappingType.getNumberOfAttributeMappings();
        if (size == 0) {
            return false;
        }
        mappings.clear();
        int currentIndex = 0;
        for (int j = 0; j < size; ++j) {
            AbstractSingularAttributeMapping original;
            AttributeMapping attributeMapping = inverseMappingType.getAttributeMapping(j);
            if (attributeMapping instanceof BasicAttributeMapping) {
                original = (BasicAttributeMapping)attributeMapping;
                SelectableMapping selectableMapping = selectableMappings.getSelectable(currentIndex);
                attributeMapping = BasicAttributeMapping.withSelectableMapping(declaringType, (BasicValuedModelPart)((Object)original), original.getPropertyAccess(), selectableMapping.isInsertable(), selectableMapping.isUpdateable(), selectableMapping);
                ++currentIndex;
            } else if (attributeMapping instanceof ToOneAttributeMapping) {
                original = (ToOneAttributeMapping)attributeMapping;
                ForeignKeyDescriptor foreignKeyDescriptor = ((ToOneAttributeMapping)original).getForeignKeyDescriptor();
                if (foreignKeyDescriptor == null) {
                    throw new IllegalStateException("Not yet ready: " + (ToOneAttributeMapping)original);
                }
                ToOneAttributeMapping toOne = ((ToOneAttributeMapping)original).copy(declaringType, declaringTableGroupProducer);
                int offset = currentIndex;
                toOne.setIdentifyingColumnsTableExpression(selectableMappings.getSelectable(offset).getContainingTableExpression());
                toOne.setForeignKeyDescriptor(foreignKeyDescriptor.withKeySelectionMapping(declaringType, declaringTableGroupProducer, index -> selectableMappings.getSelectable(offset + index), creationProcess));
                attributeMapping = toOne;
                currentIndex += attributeMapping.getJdbcTypeCount();
            } else if (attributeMapping instanceof EmbeddableValuedModelPart) {
                SelectableMapping[] subMappings = new SelectableMapping[attributeMapping.getJdbcTypeCount()];
                for (int i = 0; i < subMappings.length; ++i) {
                    subMappings[i] = selectableMappings.getSelectable(currentIndex++);
                }
                attributeMapping = MappingModelCreationHelper.createInverseModelPart((EmbeddableValuedModelPart)((Object)attributeMapping), declaringType, declaringTableGroupProducer, new SelectableMappingsImpl(subMappings), creationProcess);
            } else {
                throw new UnsupportedMappingException("Only basic and to-one attributes are supported in composite fks");
            }
            mappings.add(attributeMapping);
        }
        return true;
    }

    protected static boolean finishInitialization(NavigableRole navigableRole, Component bootDescriptor, CompositeType compositeType, String rootTableExpression, String[] rootTableKeyColumnNames, EmbeddableMappingType declarer, EmbeddableRepresentationStrategy representationStrategy, AttributeTypeValidator attributeTypeValidator, ConcreteTableResolver concreteTableResolver, Consumer<AttributeMapping> attributeConsumer, SuccessfulCompletionCallback completionCallback, final MappingModelCreationProcess creationProcess) {
        SessionFactoryImplementor sessionFactory = creationProcess.getCreationContext().getSessionFactory();
        TypeConfiguration typeConfiguration = sessionFactory.getTypeConfiguration();
        JdbcServices jdbcServices = sessionFactory.getJdbcServices();
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        Dialect dialect = jdbcEnvironment.getDialect();
        Type[] subtypes = compositeType.getSubtypes();
        int attributeIndex = 0;
        int columnPosition = 0;
        for (Property bootPropertyDescriptor : bootDescriptor.getProperties()) {
            EntityPersister entityPersister;
            AttributeMapping attributeMapping;
            Type subtype = subtypes[attributeIndex];
            attributeTypeValidator.check(bootPropertyDescriptor.getName(), subtype);
            PropertyAccess propertyAccess = representationStrategy.resolvePropertyAccess(bootPropertyDescriptor);
            Value value = bootPropertyDescriptor.getValue();
            if (subtype instanceof BasicType) {
                SelectablePath selectablePath;
                boolean nullable;
                Integer scale;
                Integer precision;
                Long length;
                String columnDefinition;
                String containingTableExpression;
                String columnExpression;
                BasicValue basicValue = (BasicValue)value;
                Selectable selectable = basicValue.getColumn();
                if (rootTableKeyColumnNames == null) {
                    columnExpression = selectable.isFormula() ? selectable.getTemplate(dialect, creationProcess.getCreationContext().getTypeConfiguration(), creationProcess.getSqmFunctionRegistry()) : selectable.getText(dialect);
                    containingTableExpression = selectable instanceof Column ? concreteTableResolver.resolve((Column)selectable, jdbcEnvironment) : rootTableExpression;
                } else {
                    containingTableExpression = rootTableExpression;
                    columnExpression = rootTableKeyColumnNames[columnPosition];
                }
                if (selectable instanceof Column) {
                    Column column = (Column)selectable;
                    columnDefinition = column.getSqlType();
                    length = column.getLength();
                    precision = column.getPrecision();
                    scale = column.getScale();
                    nullable = column.isNullable();
                    selectablePath = basicValue.createSelectablePath(column.getQuotedName(dialect));
                } else {
                    columnDefinition = null;
                    length = null;
                    precision = null;
                    scale = null;
                    nullable = true;
                    selectablePath = basicValue.createSelectablePath(bootPropertyDescriptor.getName());
                }
                attributeMapping = MappingModelCreationHelper.buildBasicAttributeMapping(bootPropertyDescriptor.getName(), navigableRole.append(bootPropertyDescriptor.getName()), attributeIndex, attributeIndex, bootPropertyDescriptor, declarer, (BasicType)subtype, containingTableExpression, columnExpression, selectablePath, selectable.isFormula(), selectable.getCustomReadExpression(), selectable.getCustomWriteExpression(), columnDefinition, length, precision, scale, nullable, value.isColumnInsertable(0), value.isColumnUpdateable(0), propertyAccess, compositeType.getCascadeStyle(attributeIndex), creationProcess);
                ++columnPosition;
            } else if (subtype instanceof AnyType) {
                Any bootValueMapping = (Any)value;
                final AnyType anyType = (AnyType)subtype;
                boolean nullable = bootValueMapping.isNullable();
                boolean insertable = value.isColumnInsertable(0);
                boolean updateable = value.isColumnUpdateable(0);
                boolean includeInOptimisticLocking = bootPropertyDescriptor.isOptimisticLocked();
                CascadeStyle cascadeStyle = compositeType.getCascadeStyle(attributeIndex);
                MutabilityPlan<Object> mutabilityPlan = updateable ? new MutabilityPlan<Object>(){

                    @Override
                    public boolean isMutable() {
                        return true;
                    }

                    @Override
                    public Object deepCopy(Object value) {
                        if (value == null) {
                            return null;
                        }
                        return anyType.deepCopy(value, creationProcess.getCreationContext().getSessionFactory());
                    }

                    @Override
                    public Serializable disassemble(Object value, SharedSessionContract session) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public Object assemble(Serializable cached, SharedSessionContract session) {
                        throw new UnsupportedOperationException();
                    }
                } : ImmutableMutabilityPlan.INSTANCE;
                SimpleAttributeMetadata attributeMetadataAccess = new SimpleAttributeMetadata(propertyAccess, mutabilityPlan, nullable, insertable, updateable, includeInOptimisticLocking, cascadeStyle);
                attributeMapping = new DiscriminatedAssociationAttributeMapping(navigableRole.append(bootPropertyDescriptor.getName()), typeConfiguration.getJavaTypeRegistry().getDescriptor((java.lang.reflect.Type)((Object)Object.class)), declarer, attributeIndex, attributeIndex, attributeMetadataAccess, bootPropertyDescriptor.isLazy() ? FetchTiming.DELAYED : FetchTiming.IMMEDIATE, propertyAccess, bootPropertyDescriptor, anyType, bootValueMapping, creationProcess);
            } else if (subtype instanceof CompositeType) {
                String[] subRootTableKeyColumnNames;
                String subTableExpression;
                CompositeType subCompositeType = (CompositeType)subtype;
                int columnSpan = subCompositeType.getColumnSpan(sessionFactory);
                if (rootTableKeyColumnNames == null) {
                    subTableExpression = rootTableExpression;
                    subRootTableKeyColumnNames = null;
                } else {
                    subTableExpression = rootTableExpression;
                    subRootTableKeyColumnNames = new String[columnSpan];
                    System.arraycopy(rootTableKeyColumnNames, columnPosition, subRootTableKeyColumnNames, 0, columnSpan);
                }
                attributeMapping = MappingModelCreationHelper.buildEmbeddedAttributeMapping(bootPropertyDescriptor.getName(), attributeIndex, attributeIndex, bootPropertyDescriptor, declarer, subCompositeType, subTableExpression, subRootTableKeyColumnNames, propertyAccess, compositeType.getCascadeStyle(attributeIndex), creationProcess);
                columnPosition += columnSpan;
            } else if (subtype instanceof CollectionType) {
                entityPersister = creationProcess.getEntityPersister(bootDescriptor.getOwner().getEntityName());
                attributeMapping = MappingModelCreationHelper.buildPluralAttributeMapping(bootPropertyDescriptor.getName(), attributeIndex, attributeIndex, bootPropertyDescriptor, entityPersister, propertyAccess, compositeType.getCascadeStyle(attributeIndex), compositeType.getFetchMode(attributeIndex), creationProcess);
            } else if (subtype instanceof EntityType) {
                entityPersister = creationProcess.getEntityPersister(bootDescriptor.getOwner().getEntityName());
                attributeMapping = MappingModelCreationHelper.buildSingularAssociationAttributeMapping(bootPropertyDescriptor.getName(), navigableRole.append(bootPropertyDescriptor.getName()), attributeIndex, attributeIndex, bootPropertyDescriptor, entityPersister, entityPersister, (EntityType)subtype, representationStrategy.resolvePropertyAccess(bootPropertyDescriptor), compositeType.getCascadeStyle(attributeIndex), creationProcess);
                columnPosition += bootPropertyDescriptor.getColumnSpan();
            } else {
                throw new MappingException(String.format(Locale.ROOT, "Unable to determine attribute nature : %s#%s", bootDescriptor.getOwner().getEntityName(), bootPropertyDescriptor.getName()));
            }
            attributeConsumer.accept(attributeMapping);
            ++attributeIndex;
        }
        completionCallback.success();
        return true;
    }

    @FunctionalInterface
    protected static interface AttributeTypeValidator {
        public void check(String var1, Type var2) throws IllegalAttributeType;
    }

    protected static class IllegalAttributeType
    extends RuntimeException {
        public IllegalAttributeType(String message) {
            super(message);
        }
    }

    @FunctionalInterface
    protected static interface SuccessfulCompletionCallback {
        public void success();
    }

    @FunctionalInterface
    protected static interface ConcreteTableResolver {
        public String resolve(Column var1, JdbcEnvironment var2);
    }
}

