/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.IntFunction;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.MutableInteger;
import org.hibernate.mapping.IndexedConsumer;
import org.hibernate.metamodel.mapping.AssociationKey;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.CompositeIdentifierMapping;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.ManagedMappingType;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.SelectableMappings;
import org.hibernate.metamodel.mapping.ValuedModelPart;
import org.hibernate.metamodel.mapping.internal.EmbeddedForeignKeyDescriptorSide;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationHelper;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.metamodel.mapping.internal.SelectableMappingsImpl;
import org.hibernate.metamodel.mapping.internal.SingleAttributeIdentifierMapping;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableGroupProducer;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.Junction;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.embeddable.internal.EmbeddableForeignKeyResultImpl;
import org.hibernate.type.descriptor.java.JavaType;

public class EmbeddedForeignKeyDescriptor
implements ForeignKeyDescriptor {
    private final EmbeddedForeignKeyDescriptorSide keySide;
    private final EmbeddedForeignKeyDescriptorSide targetSide;
    private final String keyTable;
    private final SelectableMappings keySelectableMappings;
    private final String targetTable;
    private final SelectableMappings targetSelectableMappings;
    private final AssociationKey associationKey;
    private final boolean hasConstraint;

    public EmbeddedForeignKeyDescriptor(String keyTable, SelectableMappings keySelectableMappings, EmbeddableValuedModelPart keyMappingType, String targetTable, SelectableMappings targetSelectableMappings, EmbeddableValuedModelPart targetMappingType, boolean hasConstraint, MappingModelCreationProcess creationProcess) {
        this(keyMappingType, targetMappingType, keyTable, keySelectableMappings, targetTable, targetSelectableMappings, hasConstraint, creationProcess);
    }

    public EmbeddedForeignKeyDescriptor(EmbeddableValuedModelPart keyMappingType, EmbeddableValuedModelPart targetMappingType, String keyTable, SelectableMappings keySelectableMappings, String targetTable, SelectableMappings targetSelectableMappings, boolean hasConstraint, MappingModelCreationProcess creationProcess) {
        this.keyTable = keyTable;
        this.keySelectableMappings = keySelectableMappings;
        this.targetTable = targetTable;
        this.targetSelectableMappings = targetSelectableMappings;
        this.targetSide = new EmbeddedForeignKeyDescriptorSide(ForeignKeyDescriptor.Nature.TARGET, targetMappingType);
        this.keySide = new EmbeddedForeignKeyDescriptorSide(ForeignKeyDescriptor.Nature.KEY, keyMappingType);
        ArrayList<String> columns = new ArrayList<String>(keySelectableMappings.getJdbcTypeCount());
        keySelectableMappings.forEachSelectable((columnIndex, selection) -> columns.add(selection.getSelectionExpression()));
        this.associationKey = new AssociationKey(keyTable, columns);
        this.hasConstraint = hasConstraint;
        creationProcess.registerInitializationCallback("Embedded (composite) FK descriptor " + targetMappingType.getNavigableRole(), () -> targetMappingType.getEmbeddableTypeDescriptor().getNumberOfAttributeMappings() != 0);
    }

    private EmbeddedForeignKeyDescriptor(EmbeddedForeignKeyDescriptor original, String keyTable, ManagedMappingType keyDeclaringType, TableGroupProducer keyDeclaringTableGroupProducer, SelectableMappings keySelectableMappings, MappingModelCreationProcess creationProcess) {
        this.keyTable = keyTable;
        this.keySelectableMappings = keySelectableMappings;
        this.targetTable = original.targetTable;
        this.targetSelectableMappings = original.targetSelectableMappings;
        this.targetSide = original.targetSide;
        this.keySide = new EmbeddedForeignKeyDescriptorSide(ForeignKeyDescriptor.Nature.KEY, MappingModelCreationHelper.createInverseModelPart(original.targetSide.getModelPart(), keyDeclaringType, keyDeclaringTableGroupProducer, keySelectableMappings, creationProcess));
        ArrayList<String> columns = new ArrayList<String>(keySelectableMappings.getJdbcTypeCount());
        keySelectableMappings.forEachSelectable((columnIndex, selection) -> columns.add(selection.getSelectionExpression()));
        this.associationKey = new AssociationKey(keyTable, columns);
        this.hasConstraint = original.hasConstraint;
    }

    @Override
    public String getKeyTable() {
        return this.keyTable;
    }

    @Override
    public String getTargetTable() {
        return this.targetTable;
    }

    @Override
    public EmbeddableValuedModelPart getKeyPart() {
        return this.keySide.getModelPart().getEmbeddableTypeDescriptor().getEmbeddedValueMapping();
    }

    @Override
    public EmbeddableValuedModelPart getTargetPart() {
        return this.targetSide.getModelPart().getEmbeddableTypeDescriptor().getEmbeddedValueMapping();
    }

    @Override
    public ForeignKeyDescriptor.Side getKeySide() {
        return this.keySide;
    }

    @Override
    public ForeignKeyDescriptor.Side getTargetSide() {
        return this.targetSide;
    }

    @Override
    public int compare(Object key1, Object key2) {
        return this.getKeyPart().getEmbeddableTypeDescriptor().compare(key1, key2);
    }

    @Override
    public ForeignKeyDescriptor withKeySelectionMapping(ManagedMappingType declaringType, TableGroupProducer declaringTableGroupProducer, IntFunction<SelectableMapping> selectableMappingAccess, MappingModelCreationProcess creationProcess) {
        SelectableMapping[] selectionMappings = new SelectableMapping[this.keySelectableMappings.getJdbcTypeCount()];
        for (int i = 0; i < selectionMappings.length; ++i) {
            selectionMappings[i] = selectableMappingAccess.apply(i);
        }
        return new EmbeddedForeignKeyDescriptor(this, selectionMappings[0].getContainingTableExpression(), declaringType, declaringTableGroupProducer, new SelectableMappingsImpl(selectionMappings), creationProcess);
    }

    @Override
    public DomainResult<?> createKeyDomainResult(NavigablePath navigablePath, TableGroup tableGroup, FetchParent fetchParent, DomainResultCreationState creationState) {
        return this.createDomainResult(navigablePath, tableGroup, null, this.keyTable, this.keySide.getModelPart(), fetchParent, creationState);
    }

    @Override
    public DomainResult<?> createTargetDomainResult(NavigablePath navigablePath, TableGroup tableGroup, FetchParent fetchParent, DomainResultCreationState creationState) {
        assert (tableGroup.getTableReference(navigablePath, this.targetTable) != null);
        return this.createDomainResult(navigablePath, tableGroup, null, this.targetTable, this.targetSide.getModelPart(), fetchParent, creationState);
    }

    @Override
    public DomainResult<?> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, ForeignKeyDescriptor.Nature side, FetchParent fetchParent, DomainResultCreationState creationState) {
        if (side == ForeignKeyDescriptor.Nature.KEY) {
            return this.createDomainResult(navigablePath, tableGroup, null, this.keyTable, this.keySide.getModelPart(), fetchParent, creationState);
        }
        return this.createDomainResult(navigablePath, tableGroup, null, this.targetTable, this.targetSide.getModelPart(), fetchParent, creationState);
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        return this.createDomainResult(navigablePath, tableGroup, resultVariable, this.keyTable, this.keySide.getModelPart(), null, creationState);
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState, BiConsumer<SqlSelection, JdbcMapping> selectionConsumer) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, String columnContainingTable, EmbeddableValuedModelPart modelPart, FetchParent fetchParent, DomainResultCreationState creationState) {
        NavigablePath resultNavigablePath = modelPart == this.keySide.getModelPart() ? navigablePath.append("{fk}") : navigablePath.append("{fk-target}");
        TableGroup fkTableGroup = creationState.getSqlAstCreationState().getFromClauseAccess().resolveTableGroup(resultNavigablePath, np -> {
            TableGroupJoin tableGroupJoin = modelPart.createTableGroupJoin(resultNavigablePath, tableGroup, null, SqlAstJoinType.INNER, true, false, creationState.getSqlAstCreationState());
            tableGroup.addTableGroupJoin(tableGroupJoin);
            return tableGroupJoin.getJoinedGroup();
        });
        ForeignKeyDescriptor.Nature currentForeignKeyResolvingKey = creationState.getCurrentlyResolvingForeignKeyPart();
        try {
            creationState.setCurrentlyResolvingForeignKeyPart(this.keySide.getModelPart() == modelPart ? ForeignKeyDescriptor.Nature.KEY : ForeignKeyDescriptor.Nature.TARGET);
            EmbeddableForeignKeyResultImpl embeddableForeignKeyResultImpl = new EmbeddableForeignKeyResultImpl(resultNavigablePath, modelPart, resultVariable, fetchParent, creationState);
            return embeddableForeignKeyResultImpl;
        }
        finally {
            creationState.setCurrentlyResolvingForeignKeyPart(currentForeignKeyResolvingKey);
        }
    }

    @Override
    public Predicate generateJoinPredicate(TableGroup targetSideTableGroup, TableGroup keySideTableGroup, SqlExpressionResolver sqlExpressionResolver, SqlAstCreationContext creationContext) {
        TableReference lhsTableReference = targetSideTableGroup.resolveTableReference(targetSideTableGroup.getNavigablePath(), this.targetTable, false);
        TableReference rhsTableKeyReference = keySideTableGroup.resolveTableReference(null, this.keyTable, false);
        return this.generateJoinPredicate(lhsTableReference, rhsTableKeyReference, sqlExpressionResolver, creationContext);
    }

    @Override
    public Predicate generateJoinPredicate(TableReference targetSideReference, TableReference keySideReference, SqlExpressionResolver sqlExpressionResolver, SqlAstCreationContext creationContext) {
        Junction predicate = new Junction(Junction.Nature.CONJUNCTION);
        this.targetSelectableMappings.forEachSelectable((i, selection) -> {
            ComparisonPredicate comparisonPredicate = new ComparisonPredicate(new ColumnReference(targetSideReference, selection), ComparisonOperator.EQUAL, new ColumnReference(keySideReference, this.keySelectableMappings.getSelectable(i)));
            predicate.add(comparisonPredicate);
        });
        return predicate;
    }

    @Override
    public boolean isSimpleJoinPredicate(Predicate predicate) {
        if (!(predicate instanceof Junction)) {
            return false;
        }
        Junction junction = (Junction)predicate;
        if (junction.getNature() != Junction.Nature.CONJUNCTION) {
            return false;
        }
        List<Predicate> predicates = junction.getPredicates();
        if (predicates.size() != this.keySelectableMappings.getJdbcTypeCount()) {
            return false;
        }
        Boolean lhsIsKey = null;
        for (int i = 0; i < predicates.size(); ++i) {
            String rhsSelectionExpression;
            String lhsSelectionExpression;
            Predicate p = predicates.get(i);
            if (!(p instanceof ComparisonPredicate)) {
                return false;
            }
            ComparisonPredicate comparisonPredicate = (ComparisonPredicate)p;
            if (comparisonPredicate.getOperator() != ComparisonOperator.EQUAL) {
                return false;
            }
            Expression lhsExpr = comparisonPredicate.getLeftHandExpression();
            Expression rhsExpr = comparisonPredicate.getRightHandExpression();
            if (!(lhsExpr instanceof ColumnReference) || !(rhsExpr instanceof ColumnReference)) {
                return false;
            }
            ColumnReference lhs = (ColumnReference)lhsExpr;
            ColumnReference rhs = (ColumnReference)rhsExpr;
            if (lhsIsKey == null) {
                String targetExpression;
                String keyExpression = this.keySelectableMappings.getSelectable(i).getSelectionExpression();
                if (keyExpression.equals(targetExpression = this.targetSelectableMappings.getSelectable(i).getSelectionExpression())) {
                    if (lhs.getColumnExpression().equals(keyExpression) && rhs.getColumnExpression().equals(keyExpression)) continue;
                    return false;
                }
                if (keyExpression.equals(lhs.getColumnExpression())) {
                    if (!targetExpression.equals(rhs.getColumnExpression())) {
                        return false;
                    }
                    lhsIsKey = true;
                    continue;
                }
                if (keyExpression.equals(rhs.getColumnExpression())) {
                    if (!targetExpression.equals(lhs.getColumnExpression())) {
                        return false;
                    }
                    lhsIsKey = false;
                    continue;
                }
                return false;
            }
            if (lhsIsKey.booleanValue()) {
                lhsSelectionExpression = this.keySelectableMappings.getSelectable(i).getSelectionExpression();
                rhsSelectionExpression = this.targetSelectableMappings.getSelectable(i).getSelectionExpression();
            } else {
                lhsSelectionExpression = this.targetSelectableMappings.getSelectable(i).getSelectionExpression();
                rhsSelectionExpression = this.keySelectableMappings.getSelectable(i).getSelectionExpression();
            }
            if (lhs.getColumnExpression().equals(lhsSelectionExpression) && rhs.getColumnExpression().equals(rhsSelectionExpression)) continue;
            return false;
        }
        return true;
    }

    @Override
    public SelectableMapping getSelectable(int columnIndex) {
        return this.keySelectableMappings.getSelectable(columnIndex);
    }

    @Override
    public int visitKeySelectables(int offset, SelectableConsumer consumer) {
        return this.keySelectableMappings.forEachSelectable(offset, consumer);
    }

    @Override
    public int visitTargetSelectables(int offset, SelectableConsumer consumer) {
        return this.targetSelectableMappings.forEachSelectable(offset, consumer);
    }

    @Override
    public boolean hasConstraint() {
        return this.hasConstraint;
    }

    @Override
    public AssociationKey getAssociationKey() {
        return this.associationKey;
    }

    @Override
    public MappingType getMappedType() {
        return this.getPartMappingType();
    }

    @Override
    public MappingType getPartMappingType() {
        return this.targetSide.getModelPart().getPartMappingType();
    }

    @Override
    public JavaType<?> getJavaType() {
        return this.targetSide.getModelPart().getJavaType();
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.targetSide.getModelPart().getNavigableRole();
    }

    @Override
    public void breakDownJdbcValues(Object domainValue, ModelPart.JdbcValueConsumer valueConsumer, SharedSessionContractImplementor session) {
        if (domainValue == null) {
            this.keySelectableMappings.forEachSelectable((index, selectable) -> valueConsumer.consume(null, selectable));
        } else if (domainValue instanceof Object[]) {
            Object[] values = (Object[])domainValue;
            this.keySelectableMappings.forEachSelectable((index, selectable) -> valueConsumer.consume(values[index], selectable));
        } else {
            MutableInteger columnPosition = new MutableInteger();
            this.keySide.getModelPart().breakDownJdbcValues(domainValue, (jdbcValue, jdbcValueMapping) -> valueConsumer.consume(jdbcValue, this.keySelectableMappings.getSelectable(columnPosition.getAndIncrement())), session);
        }
    }

    @Override
    public Object getAssociationKeyFromSide(Object targetObject, ForeignKeyDescriptor.Side side, SharedSessionContractImplementor session) {
        ValuedModelPart modelPart = side.getModelPart();
        if (modelPart instanceof SingleAttributeIdentifierMapping) {
            return ((SingleAttributeIdentifierMapping)modelPart).getIdentifierIfNotUnsaved(targetObject, session);
        }
        if (modelPart instanceof CompositeIdentifierMapping) {
            return ((CompositeIdentifierMapping)modelPart).getIdentifierIfNotUnsaved(targetObject, session);
        }
        return targetObject;
    }

    @Override
    public EntityMappingType findContainingEntityMapping() {
        return this.targetSide.getModelPart().findContainingEntityMapping();
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        return this.targetSide.getModelPart().forEachJdbcType(offset, action);
    }

    @Override
    public int forEachDisassembledJdbcValue(Object value, int offset, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        return this.targetSide.getModelPart().forEachDisassembledJdbcValue(value, offset, valuesConsumer, session);
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        return this.targetSide.getModelPart().disassemble(value, session);
    }

    @Override
    public boolean hasPartitionedSelectionMapping() {
        return this.keySide.getModelPart().hasPartitionedSelectionMapping();
    }
}

