/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.function.BiConsumer;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.mapping.IndexedConsumer;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.EntityRowIdMapping;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.JavaType;

public class EntityRowIdMappingImpl
implements EntityRowIdMapping {
    private final String rowIdName;
    private final EntityMappingType declaringType;
    private final String tableExpression;
    private final BasicType<Object> rowIdType;

    public EntityRowIdMappingImpl(String rowIdName, String tableExpression, EntityMappingType declaringType) {
        this.rowIdName = rowIdName;
        this.tableExpression = tableExpression;
        this.declaringType = declaringType;
        this.rowIdType = declaringType.getEntityPersister().getFactory().getTypeConfiguration().getBasicTypeRegistry().resolve(Object.class, -8);
    }

    @Override
    public String getRowIdName() {
        return this.rowIdName;
    }

    @Override
    public MappingType getPartMappingType() {
        return this.rowIdType;
    }

    @Override
    public JavaType<?> getJavaType() {
        return this.rowIdType.getJavaTypeDescriptor();
    }

    @Override
    public String getPartName() {
        return this.rowIdName;
    }

    @Override
    public NavigableRole getNavigableRole() {
        return null;
    }

    @Override
    public EntityMappingType findContainingEntityMapping() {
        return this.declaringType;
    }

    @Override
    public boolean hasPartitionedSelectionMapping() {
        return false;
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        SqlAstCreationState sqlAstCreationState = creationState.getSqlAstCreationState();
        SqlExpressionResolver sqlExpressionResolver = sqlAstCreationState.getSqlExpressionResolver();
        TableReference columnTableReference = tableGroup.resolveTableReference(navigablePath, this.tableExpression);
        SqlSelection sqlSelection = sqlExpressionResolver.resolveSqlSelection(sqlExpressionResolver.resolveSqlExpression(columnTableReference, this), this.rowIdType.getJdbcJavaType(), null, sqlAstCreationState.getCreationContext().getSessionFactory().getTypeConfiguration());
        return new BasicResult(sqlSelection.getValuesArrayPosition(), resultVariable, this.rowIdType, navigablePath);
    }

    @Override
    public int getJdbcTypeCount() {
        return 1;
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        return this.rowIdType.disassemble(value, session);
    }

    @Override
    public int forEachDisassembledJdbcValue(Object value, int offset, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        return this.rowIdType.forEachDisassembledJdbcValue(value, offset, valuesConsumer, session);
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        action.accept(offset, this.getJdbcMapping());
        return this.getJdbcTypeCount();
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState, BiConsumer<SqlSelection, JdbcMapping> selectionConsumer) {
    }

    @Override
    public void breakDownJdbcValues(Object domainValue, ModelPart.JdbcValueConsumer valueConsumer, SharedSessionContractImplementor session) {
        valueConsumer.consume(domainValue, this);
    }

    @Override
    public String getContainingTableExpression() {
        return this.tableExpression;
    }

    @Override
    public String getSelectionExpression() {
        return this.rowIdName;
    }

    @Override
    public String getCustomReadExpression() {
        return null;
    }

    @Override
    public String getCustomWriteExpression() {
        return null;
    }

    @Override
    public String getColumnDefinition() {
        return null;
    }

    @Override
    public Long getLength() {
        return null;
    }

    @Override
    public Integer getPrecision() {
        return null;
    }

    @Override
    public Integer getScale() {
        return null;
    }

    @Override
    public boolean isFormula() {
        return false;
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public boolean isInsertable() {
        return false;
    }

    @Override
    public boolean isUpdateable() {
        return false;
    }

    @Override
    public boolean isPartitioned() {
        return false;
    }

    @Override
    public JdbcMapping getJdbcMapping() {
        return this.rowIdType.getJdbcMapping();
    }
}

