/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.CascadeStyle;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.generator.Generator;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.IndexedConsumer;
import org.hibernate.mapping.List;
import org.hibernate.mapping.Map;
import org.hibernate.mapping.Property;
import org.hibernate.metamodel.mapping.AttributeMetadata;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.CollectionIdentifierDescriptor;
import org.hibernate.metamodel.mapping.CollectionMappingType;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.ManagedMappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.ModelPartContainer;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.internal.AbstractAttributeMapping;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.metamodel.mapping.internal.OneToManyCollectionPart;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.metamodel.mapping.ordering.OrderByFragment;
import org.hibernate.metamodel.mapping.ordering.OrderByFragmentTranslator;
import org.hibernate.metamodel.mapping.ordering.TranslationContext;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.spi.SqlAliasBase;
import org.hibernate.sql.ast.spi.SqlAliasBaseGenerator;
import org.hibernate.sql.ast.spi.SqlAliasStemHelper;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.from.CollectionTableGroup;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.OneToManyTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableGroupJoinProducer;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchOptions;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.collection.internal.CollectionDomainResult;
import org.hibernate.sql.results.graph.collection.internal.DelayedCollectionFetch;
import org.hibernate.sql.results.graph.collection.internal.EagerCollectionFetch;
import org.hibernate.sql.results.graph.collection.internal.SelectEagerCollectionFetch;
import org.jboss.logging.Logger;

public class PluralAttributeMappingImpl
extends AbstractAttributeMapping
implements PluralAttributeMapping,
FetchOptions {
    private static final Logger log = Logger.getLogger(PluralAttributeMappingImpl.class);
    private final CollectionMappingType collectionMappingType;
    private final int stateArrayPosition;
    private final PropertyAccess propertyAccess;
    private final AttributeMetadata attributeMetadata;
    private final String referencedPropertyName;
    private final String mapKeyPropertyName;
    private final CollectionPart elementDescriptor;
    private final CollectionPart indexDescriptor;
    private final CollectionIdentifierDescriptor identifierDescriptor;
    private final FetchTiming fetchTiming;
    private final FetchStyle fetchStyle;
    private final String bidirectionalAttributeName;
    private final CollectionPersister collectionDescriptor;
    private final String separateCollectionTable;
    private final String sqlAliasStem;
    private final PluralAttributeMapping.IndexMetadata indexMetadata;
    private ForeignKeyDescriptor fkDescriptor;
    private OrderByFragment orderByFragment;
    private OrderByFragment manyToManyOrderByFragment;

    public PluralAttributeMappingImpl(String attributeName, Collection bootDescriptor, PropertyAccess propertyAccess, AttributeMetadata attributeMetadata, CollectionMappingType<?> collectionMappingType, int stateArrayPosition, int fetchableIndex, CollectionPart elementDescriptor, final CollectionPart indexDescriptor, CollectionIdentifierDescriptor identifierDescriptor, FetchTiming fetchTiming, FetchStyle fetchStyle, CascadeStyle cascadeStyle, ManagedMappingType declaringType, CollectionPersister collectionDescriptor) {
        super(attributeName, fetchableIndex, declaringType);
        this.propertyAccess = propertyAccess;
        this.attributeMetadata = attributeMetadata;
        this.collectionMappingType = collectionMappingType;
        this.stateArrayPosition = stateArrayPosition;
        this.elementDescriptor = elementDescriptor;
        this.indexDescriptor = indexDescriptor;
        this.identifierDescriptor = identifierDescriptor;
        this.fetchTiming = fetchTiming;
        this.fetchStyle = fetchStyle;
        this.collectionDescriptor = collectionDescriptor;
        this.referencedPropertyName = bootDescriptor.getReferencedPropertyName();
        this.mapKeyPropertyName = bootDescriptor instanceof Map ? ((Map)bootDescriptor).getMapKeyPropertyName() : null;
        this.bidirectionalAttributeName = StringHelper.subStringNullIfEmpty(bootDescriptor.getMappedByProperty(), Character.valueOf('.'));
        this.sqlAliasStem = SqlAliasStemHelper.INSTANCE.generateStemFromAttributeName(attributeName);
        this.separateCollectionTable = bootDescriptor.isOneToMany() ? null : ((Joinable)((Object)collectionDescriptor)).getTableName();
        final int baseIndex = bootDescriptor instanceof List ? ((List)bootDescriptor).getBaseIndex() : -1;
        this.indexMetadata = new PluralAttributeMapping.IndexMetadata(){

            @Override
            public CollectionPart getIndexDescriptor() {
                return indexDescriptor;
            }

            @Override
            public int getListIndexBase() {
                return baseIndex;
            }

            @Override
            public String getIndexPropertyName() {
                return PluralAttributeMappingImpl.this.mapKeyPropertyName;
            }
        };
        if (collectionDescriptor instanceof Aware) {
            ((Aware)((Object)collectionDescriptor)).injectAttributeMapping(this);
        }
        if (elementDescriptor instanceof Aware) {
            ((Aware)((Object)elementDescriptor)).injectAttributeMapping(this);
        }
        if (indexDescriptor instanceof Aware) {
            ((Aware)((Object)indexDescriptor)).injectAttributeMapping(this);
        }
    }

    @Override
    public boolean isBidirectionalAttributeName(NavigablePath fetchablePath, ToOneAttributeMapping modelPart) {
        if (this.bidirectionalAttributeName == null) {
            return this.fkDescriptor.getTargetPart() == modelPart.getForeignKeyDescriptor().getTargetPart();
        }
        return fetchablePath.getLocalName().endsWith(this.bidirectionalAttributeName);
    }

    public void finishInitialization(Property bootProperty, Collection bootDescriptor, MappingModelCreationProcess creationProcess) {
        block8: {
            boolean hasManyToManyOrder;
            boolean hasOrder;
            block7: {
                hasOrder = bootDescriptor.getOrderBy() != null;
                boolean bl = hasManyToManyOrder = bootDescriptor.getManyToManyOrdering() != null;
                if (hasOrder) break block7;
                if (!hasManyToManyOrder) break block8;
            }
            TranslationContext context = this.collectionDescriptor::getFactory;
            if (hasOrder) {
                if (log.isDebugEnabled()) {
                    log.debugf("Translating order-by fragment [%s] for collection role : %s", (Object)bootDescriptor.getOrderBy(), (Object)this.collectionDescriptor.getRole());
                }
                this.orderByFragment = OrderByFragmentTranslator.translate(bootDescriptor.getOrderBy(), this, context);
            }
            if (hasManyToManyOrder) {
                if (log.isDebugEnabled()) {
                    log.debugf("Translating many-to-many order-by fragment [%s] for collection role : %s", (Object)bootDescriptor.getOrderBy(), (Object)this.collectionDescriptor.getRole());
                }
                this.manyToManyOrderByFragment = OrderByFragmentTranslator.translate(bootDescriptor.getManyToManyOrdering(), this, context);
            }
        }
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.getCollectionDescriptor().getNavigableRole();
    }

    @Override
    public CollectionMappingType getMappedType() {
        return this.collectionMappingType;
    }

    @Override
    public ForeignKeyDescriptor getKeyDescriptor() {
        return this.fkDescriptor;
    }

    @Override
    public CollectionPersister getCollectionDescriptor() {
        return this.collectionDescriptor;
    }

    @Override
    public CollectionPart getElementDescriptor() {
        return this.elementDescriptor;
    }

    @Override
    public CollectionPart getIndexDescriptor() {
        return this.indexDescriptor;
    }

    @Override
    public PluralAttributeMapping.IndexMetadata getIndexMetadata() {
        return this.indexMetadata;
    }

    @Override
    public CollectionIdentifierDescriptor getIdentifierDescriptor() {
        return this.identifierDescriptor;
    }

    @Override
    public OrderByFragment getOrderByFragment() {
        return this.orderByFragment;
    }

    @Override
    public OrderByFragment getManyToManyOrderByFragment() {
        return this.manyToManyOrderByFragment;
    }

    @Override
    public String getSeparateCollectionTable() {
        return this.separateCollectionTable;
    }

    @Override
    public boolean containsTableReference(String tableExpression) {
        return tableExpression.equals(this.separateCollectionTable);
    }

    @Override
    public int getStateArrayPosition() {
        return this.stateArrayPosition;
    }

    @Override
    public AttributeMetadata getAttributeMetadata() {
        return this.attributeMetadata;
    }

    @Override
    public PropertyAccess getPropertyAccess() {
        return this.propertyAccess;
    }

    @Override
    public Generator getGenerator() {
        return null;
    }

    @Override
    public String getFetchableName() {
        return this.getAttributeName();
    }

    @Override
    public FetchOptions getMappedFetchOptions() {
        return this;
    }

    @Override
    public FetchStyle getStyle() {
        return this.fetchStyle;
    }

    @Override
    public FetchTiming getTiming() {
        return this.fetchTiming;
    }

    @Override
    public boolean hasPartitionedSelectionMapping() {
        return false;
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        TableGroup collectionTableGroup = creationState.getSqlAstCreationState().getFromClauseAccess().getTableGroup(navigablePath);
        assert (collectionTableGroup != null);
        creationState.registerVisitedAssociationKey(this.fkDescriptor.getAssociationKey());
        return new CollectionDomainResult(navigablePath, this, resultVariable, tableGroup, creationState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Fetch generateFetch(FetchParent fetchParent, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, String resultVariable, DomainResultCreationState creationState) {
        SqlAstCreationState sqlAstCreationState = creationState.getSqlAstCreationState();
        boolean added = creationState.registerVisitedAssociationKey(this.fkDescriptor.getAssociationKey());
        try {
            if (fetchTiming == FetchTiming.IMMEDIATE) {
                if (selected) {
                    TableGroup collectionTableGroup = this.resolveCollectionTableGroup(fetchParent, fetchablePath, creationState, sqlAstCreationState);
                    EagerCollectionFetch eagerCollectionFetch = new EagerCollectionFetch(fetchablePath, this, collectionTableGroup, fetchParent, creationState);
                    return eagerCollectionFetch;
                }
                Fetch fetch = this.createSelectEagerCollectionFetch(fetchParent, fetchablePath, creationState, sqlAstCreationState);
                return fetch;
            }
            if (this.getCollectionDescriptor().getCollectionType().hasHolder()) {
                Fetch fetch = this.createSelectEagerCollectionFetch(fetchParent, fetchablePath, creationState, sqlAstCreationState);
                return fetch;
            }
            Fetch fetch = this.createDelayedCollectionFetch(fetchParent, fetchablePath, creationState, sqlAstCreationState);
            return fetch;
        }
        finally {
            if (added) {
                creationState.removeVisitedAssociationKey(this.fkDescriptor.getAssociationKey());
            }
        }
    }

    @Override
    public Fetch resolveCircularFetch(NavigablePath fetchablePath, FetchParent fetchParent, FetchTiming fetchTiming, DomainResultCreationState creationState) {
        boolean alreadyVisited;
        if (fetchTiming == FetchTiming.IMMEDIATE && (alreadyVisited = creationState.isAssociationKeyVisited(this.fkDescriptor.getAssociationKey()))) {
            return this.createSelectEagerCollectionFetch(fetchParent, fetchablePath, creationState, creationState.getSqlAstCreationState());
        }
        return null;
    }

    private Fetch createSelectEagerCollectionFetch(FetchParent fetchParent, NavigablePath fetchablePath, DomainResultCreationState creationState, SqlAstCreationState sqlAstCreationState) {
        if (this.referencedPropertyName != null) {
            this.resolveCollectionTableGroup(fetchParent, fetchablePath, creationState, sqlAstCreationState);
            DomainResult<?> collectionKeyDomainResult = this.getKeyDescriptor().createTargetDomainResult(fetchablePath, sqlAstCreationState.getFromClauseAccess().getTableGroup(fetchParent.getNavigablePath()), fetchParent, creationState);
            return new SelectEagerCollectionFetch(fetchablePath, this, collectionKeyDomainResult, fetchParent);
        }
        return new SelectEagerCollectionFetch(fetchablePath, this, null, fetchParent);
    }

    private TableGroup resolveCollectionTableGroup(FetchParent fetchParent, NavigablePath fetchablePath, DomainResultCreationState creationState, SqlAstCreationState sqlAstCreationState) {
        FromClauseAccess fromClauseAccess = sqlAstCreationState.getFromClauseAccess();
        return fromClauseAccess.resolveTableGroup(fetchablePath, p -> {
            TableGroup lhsTableGroup = fromClauseAccess.getTableGroup(fetchParent.getNavigablePath());
            TableGroupJoin tableGroupJoin = this.createTableGroupJoin(fetchablePath, lhsTableGroup, null, SqlAstJoinType.LEFT, true, false, creationState.getSqlAstCreationState());
            lhsTableGroup.addTableGroupJoin(tableGroupJoin);
            return tableGroupJoin.getJoinedGroup();
        });
    }

    private Fetch createDelayedCollectionFetch(FetchParent fetchParent, NavigablePath fetchablePath, DomainResultCreationState creationState, SqlAstCreationState sqlAstCreationState) {
        EntityMappingType containingEntityMapping = this.findContainingEntityMapping();
        DomainResult<?> collectionKeyDomainResult = fetchParent.getReferencedModePart() == containingEntityMapping && containingEntityMapping.getEntityPersister().getPropertyLaziness()[this.getStateArrayPosition()] ? null : this.getKeyDescriptor().createTargetDomainResult(fetchablePath, sqlAstCreationState.getFromClauseAccess().getTableGroup(fetchParent.getNavigablePath()), fetchParent, creationState);
        return new DelayedCollectionFetch(fetchablePath, this, fetchParent, collectionKeyDomainResult);
    }

    @Override
    public String getSqlAliasStem() {
        return this.sqlAliasStem;
    }

    @Override
    public SqlAstJoinType getDefaultSqlAstJoinType(TableGroup parentTableGroup) {
        return SqlAstJoinType.LEFT;
    }

    @Override
    public boolean isSimpleJoinPredicate(Predicate predicate) {
        return this.fkDescriptor.isSimpleJoinPredicate(predicate);
    }

    @Override
    public TableGroupJoin createTableGroupJoin(NavigablePath navigablePath, TableGroup lhs, String explicitSourceAlias, SqlAstJoinType requestedJoinType, boolean fetched, boolean addsPredicate, SqlAliasBaseGenerator aliasBaseGenerator, SqlExpressionResolver sqlExpressionResolver, FromClauseAccess fromClauseAccess, SqlAstCreationContext creationContext) {
        SqlAstJoinType joinType = requestedJoinType == null ? (fetched ? this.getDefaultSqlAstJoinType(lhs) : SqlAstJoinType.INNER) : requestedJoinType;
        ArrayList predicates = new ArrayList(2);
        TableGroup tableGroup = this.createRootTableGroupJoin(navigablePath, lhs, explicitSourceAlias, requestedJoinType, fetched, predicates::add, aliasBaseGenerator, sqlExpressionResolver, fromClauseAccess, creationContext);
        TableGroupJoin tableGroupJoin = new TableGroupJoin(navigablePath, joinType, tableGroup, null);
        predicates.forEach(tableGroupJoin::applyPredicate);
        return tableGroupJoin;
    }

    @Override
    public TableGroup createRootTableGroupJoin(NavigablePath navigablePath, TableGroup lhs, String explicitSourceAlias, SqlAstJoinType requestedJoinType, boolean fetched, Consumer<Predicate> predicateConsumer, SqlAliasBaseGenerator aliasBaseGenerator, SqlExpressionResolver sqlExpressionResolver, FromClauseAccess fromClauseAccess, SqlAstCreationContext creationContext) {
        SqlAstJoinType joinType = requestedJoinType == null ? SqlAstJoinType.INNER : requestedJoinType;
        CollectionPersister collectionDescriptor = this.getCollectionDescriptor();
        TableGroup tableGroup = collectionDescriptor.isOneToMany() ? this.createOneToManyTableGroup(lhs.canUseInnerJoins() && joinType == SqlAstJoinType.INNER, navigablePath, fetched, explicitSourceAlias, aliasBaseGenerator.createSqlAliasBase(this.getSqlAliasStem()), sqlExpressionResolver, fromClauseAccess, creationContext) : this.createCollectionTableGroup(lhs.canUseInnerJoins() && joinType == SqlAstJoinType.INNER, navigablePath, fetched, explicitSourceAlias, aliasBaseGenerator.createSqlAliasBase(this.getSqlAliasStem()), sqlExpressionResolver, fromClauseAccess, creationContext);
        if (predicateConsumer != null) {
            predicateConsumer.accept(this.getKeyDescriptor().generateJoinPredicate(lhs, tableGroup, sqlExpressionResolver, creationContext));
        }
        return tableGroup;
    }

    @Override
    public void setForeignKeyDescriptor(ForeignKeyDescriptor fkDescriptor) {
        this.fkDescriptor = fkDescriptor;
    }

    private TableGroup createOneToManyTableGroup(boolean canUseInnerJoins, NavigablePath navigablePath, boolean fetched, String sourceAlias, SqlAliasBase sqlAliasBase, SqlExpressionResolver sqlExpressionResolver, FromClauseAccess fromClauseAccess, SqlAstCreationContext creationContext) {
        TableGroup elementTableGroup = ((OneToManyCollectionPart)this.elementDescriptor).createAssociatedTableGroup(canUseInnerJoins, navigablePath.append(CollectionPart.Nature.ELEMENT.getName()), fetched, sourceAlias, sqlAliasBase, sqlExpressionResolver, creationContext);
        OneToManyTableGroup tableGroup = new OneToManyTableGroup(this, elementTableGroup, creationContext.getSessionFactory());
        if (this.indexDescriptor instanceof TableGroupJoinProducer) {
            TableGroupJoin tableGroupJoin = ((TableGroupJoinProducer)((Object)this.indexDescriptor)).createTableGroupJoin(navigablePath.append(CollectionPart.Nature.INDEX.getName()), tableGroup, null, SqlAstJoinType.INNER, fetched, false, stem -> sqlAliasBase, sqlExpressionResolver, fromClauseAccess, creationContext);
            tableGroup.registerIndexTableGroup(tableGroupJoin);
        }
        return tableGroup;
    }

    private TableGroup createCollectionTableGroup(boolean canUseInnerJoins, NavigablePath navigablePath, boolean fetched, String sourceAlias, SqlAliasBase sqlAliasBase, SqlExpressionResolver sqlExpressionResolver, FromClauseAccess fromClauseAccess, SqlAstCreationContext creationContext) {
        TableGroupJoin tableGroupJoin;
        assert (!this.getCollectionDescriptor().isOneToMany());
        String collectionTableName = ((Joinable)((Object)this.collectionDescriptor)).getTableName();
        NamedTableReference collectionTableReference = new NamedTableReference(collectionTableName, sqlAliasBase.generateNewAlias(), true);
        CollectionTableGroup tableGroup = new CollectionTableGroup(canUseInnerJoins, navigablePath, this, fetched, sourceAlias, (TableReference)collectionTableReference, true, sqlAliasBase, s -> false, null, creationContext.getSessionFactory());
        if (this.elementDescriptor instanceof TableGroupJoinProducer) {
            tableGroupJoin = ((TableGroupJoinProducer)((Object)this.elementDescriptor)).createTableGroupJoin(navigablePath.append(CollectionPart.Nature.ELEMENT.getName()), tableGroup, null, SqlAstJoinType.INNER, fetched, false, stem -> sqlAliasBase, sqlExpressionResolver, fromClauseAccess, creationContext);
            tableGroup.registerElementTableGroup(tableGroupJoin);
        }
        if (this.indexDescriptor instanceof TableGroupJoinProducer) {
            tableGroupJoin = ((TableGroupJoinProducer)((Object)this.indexDescriptor)).createTableGroupJoin(navigablePath.append(CollectionPart.Nature.INDEX.getName()), tableGroup, null, SqlAstJoinType.INNER, fetched, false, stem -> sqlAliasBase, sqlExpressionResolver, fromClauseAccess, creationContext);
            tableGroup.registerIndexTableGroup(tableGroupJoin);
        }
        return tableGroup;
    }

    @Override
    public TableGroup createRootTableGroup(boolean canUseInnerJoins, NavigablePath navigablePath, String explicitSourceAlias, Supplier<Consumer<Predicate>> additionalPredicateCollectorAccess, SqlAstCreationState creationState, SqlAstCreationContext creationContext) {
        return this.createRootTableGroup(canUseInnerJoins, navigablePath, explicitSourceAlias, additionalPredicateCollectorAccess, creationState.getSqlAliasBaseGenerator().createSqlAliasBase(this.getSqlAliasStem()), creationState.getSqlExpressionResolver(), creationState.getFromClauseAccess(), creationContext);
    }

    @Override
    public TableGroup createRootTableGroup(boolean canUseInnerJoins, NavigablePath navigablePath, String explicitSourceAlias, Supplier<Consumer<Predicate>> additionalPredicateCollectorAccess, SqlAliasBase sqlAliasBase, SqlExpressionResolver expressionResolver, FromClauseAccess fromClauseAccess, SqlAstCreationContext creationContext) {
        if (this.getCollectionDescriptor().isOneToMany()) {
            return this.createOneToManyTableGroup(canUseInnerJoins, navigablePath, false, explicitSourceAlias, sqlAliasBase, expressionResolver, fromClauseAccess, creationContext);
        }
        return this.createCollectionTableGroup(canUseInnerJoins, navigablePath, false, explicitSourceAlias, sqlAliasBase, expressionResolver, fromClauseAccess, creationContext);
    }

    @Override
    public boolean isAffectedByEnabledFilters(LoadQueryInfluencers influencers) {
        return this.getCollectionDescriptor().isAffectedByEnabledFilters(influencers);
    }

    @Override
    public boolean isAffectedByEntityGraph(LoadQueryInfluencers influencers) {
        return this.getCollectionDescriptor().isAffectedByEntityGraph(influencers);
    }

    @Override
    public boolean isAffectedByEnabledFetchProfiles(LoadQueryInfluencers influencers) {
        return this.getCollectionDescriptor().isAffectedByEnabledFetchProfiles(influencers);
    }

    @Override
    public String getRootPathName() {
        return this.getCollectionDescriptor().getRole();
    }

    @Override
    public ModelPart findSubPart(String name, EntityMappingType treatTargetType) {
        ModelPart subPart;
        if (this.elementDescriptor instanceof ModelPartContainer && (subPart = ((ModelPartContainer)((Object)this.elementDescriptor)).findSubPart(name, null)) != null) {
            return subPart;
        }
        CollectionPart.Nature nature = CollectionPart.Nature.fromName(name);
        if (nature != null) {
            switch (nature) {
                case ELEMENT: {
                    return this.elementDescriptor;
                }
                case INDEX: {
                    return this.indexDescriptor;
                }
                case ID: {
                    return this.identifierDescriptor;
                }
            }
        }
        return null;
    }

    @Override
    public void forEachSubPart(IndexedConsumer<ModelPart> consumer, EntityMappingType treatTarget) {
        consumer.accept(0, this.elementDescriptor);
        int position = 1;
        if (this.indexDescriptor != null) {
            consumer.accept(position++, this.indexDescriptor);
        }
        if (this.identifierDescriptor != null) {
            consumer.accept(position + 1, this.identifierDescriptor);
        }
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        this.elementDescriptor.applySqlSelections(navigablePath, tableGroup, creationState);
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState, BiConsumer<SqlSelection, JdbcMapping> selectionConsumer) {
        this.elementDescriptor.applySqlSelections(navigablePath, tableGroup, creationState, selectionConsumer);
    }

    @Override
    public void breakDownJdbcValues(Object domainValue, ModelPart.JdbcValueConsumer valueConsumer, SharedSessionContractImplementor session) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visitSubParts(Consumer<ModelPart> consumer, EntityMappingType treatTargetType) {
        consumer.accept(this.elementDescriptor);
        if (this.indexDescriptor != null) {
            consumer.accept(this.indexDescriptor);
        }
    }

    @Override
    public String getContainingTableExpression() {
        return this.getKeyDescriptor().getKeyTable();
    }

    @Override
    public int getJdbcTypeCount() {
        return 0;
    }

    @Override
    public SelectableMapping getSelectable(int columnIndex) {
        return null;
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        return 0;
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        return this.elementDescriptor.disassemble(value, session);
    }

    @Override
    public int forEachDisassembledJdbcValue(Object value, int offset, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        return this.elementDescriptor.forEachDisassembledJdbcValue(value, offset, valuesConsumer, session);
    }

    public String toString() {
        return "PluralAttribute(" + this.getCollectionDescriptor().getRole() + ")";
    }

    public static interface Aware {
        public void injectAttributeMapping(PluralAttributeMapping var1);
    }
}

