/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.collection.mutation;

import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.jdbc.mutation.ParameterUsage;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.NullnessHelper;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.persister.collection.mutation.CollectionMutationTarget;
import org.hibernate.persister.collection.mutation.OperationProducer;
import org.hibernate.sql.model.ast.MutatingTableReference;
import org.hibernate.sql.model.jdbc.JdbcMutationOperation;

public class RowMutationOperations {
    private final CollectionMutationTarget target;
    private final OperationProducer insertRowOperationProducer;
    private final Values insertRowValues;
    private final OperationProducer updateRowOperationProducer;
    private final Values updateRowValues;
    private final Restrictions updateRowRestrictions;
    private final OperationProducer deleteRowOperationProducer;
    private final Restrictions deleteRowRestrictions;
    private JdbcMutationOperation insertRowOperation;
    private JdbcMutationOperation updateRowOperation;
    private JdbcMutationOperation deleteRowOperation;

    public RowMutationOperations(CollectionMutationTarget target, OperationProducer insertRowOperationProducer, Values insertRowValues, OperationProducer updateRowOperationProducer, Values updateRowValues, Restrictions updateRowRestrictions, OperationProducer deleteRowOperationProducer, Restrictions deleteRowRestrictions) {
        this.target = target;
        assert (NullnessHelper.areSameNullness(insertRowOperationProducer, insertRowValues));
        assert (NullnessHelper.areSameNullness(updateRowOperationProducer, updateRowValues, updateRowRestrictions));
        assert (NullnessHelper.areSameNullness(deleteRowOperationProducer, deleteRowRestrictions));
        this.insertRowOperationProducer = insertRowOperationProducer;
        this.insertRowValues = insertRowValues;
        this.updateRowOperationProducer = updateRowOperationProducer;
        this.updateRowValues = updateRowValues;
        this.updateRowRestrictions = updateRowRestrictions;
        this.deleteRowOperationProducer = deleteRowOperationProducer;
        this.deleteRowRestrictions = deleteRowRestrictions;
    }

    public String toString() {
        return "RowMutationOperations(" + this.target.getRolePath() + ")";
    }

    public boolean hasInsertRow() {
        return this.insertRowOperationProducer != null;
    }

    public Values getInsertRowValues() {
        return this.insertRowValues;
    }

    public JdbcMutationOperation getInsertRowOperation() {
        if (!this.hasInsertRow()) {
            return null;
        }
        JdbcMutationOperation local = this.insertRowOperation;
        if (local == null) {
            MutatingTableReference tableReference = new MutatingTableReference(this.target.getCollectionTableMapping());
            this.insertRowOperation = local = this.insertRowOperationProducer.createOperation(tableReference);
        }
        return local;
    }

    public boolean hasUpdateRow() {
        return this.updateRowOperationProducer != null;
    }

    public JdbcMutationOperation getUpdateRowOperation() {
        if (!this.hasUpdateRow()) {
            return null;
        }
        JdbcMutationOperation local = this.updateRowOperation;
        if (local == null) {
            MutatingTableReference tableReference = new MutatingTableReference(this.target.getCollectionTableMapping());
            this.updateRowOperation = local = this.updateRowOperationProducer.createOperation(tableReference);
        }
        return local;
    }

    public Values getUpdateRowValues() {
        return this.updateRowValues;
    }

    public Restrictions getUpdateRowRestrictions() {
        return this.updateRowRestrictions;
    }

    public boolean hasDeleteRow() {
        return this.deleteRowOperationProducer != null;
    }

    public Restrictions getDeleteRowRestrictions() {
        return this.deleteRowRestrictions;
    }

    public JdbcMutationOperation getDeleteRowOperation() {
        if (!this.hasDeleteRow()) {
            return null;
        }
        JdbcMutationOperation local = this.deleteRowOperation;
        if (local == null) {
            MutatingTableReference tableReference = new MutatingTableReference(this.target.getCollectionTableMapping());
            this.deleteRowOperation = local = this.deleteRowOperationProducer.createOperation(tableReference);
        }
        return local;
    }

    @FunctionalInterface
    public static interface ValuesBindingConsumer
    extends ModelPart.JdbcValueConsumer {
        public void consumeJdbcValueBinding(Object var1, SelectableMapping var2, ParameterUsage var3);

        @Override
        default public void consume(Object value, SelectableMapping jdbcValueMapping) {
            this.consumeJdbcValueBinding(value, jdbcValueMapping, ParameterUsage.SET);
        }
    }

    @FunctionalInterface
    public static interface Values {
        public void applyValues(PersistentCollection<?> var1, Object var2, Object var3, int var4, SharedSessionContractImplementor var5, ValuesBindingConsumer var6);
    }

    @FunctionalInterface
    public static interface Restrictions {
        public void applyRestrictions(PersistentCollection<?> var1, Object var2, Object var3, int var4, SharedSessionContractImplementor var5, ModelPart.JdbcValueConsumer var6);
    }
}

