/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.entity;

import org.hibernate.Internal;
import org.hibernate.MappingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.MarkerObject;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.type.BasicType;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;

@Internal
public class DiscriminatorHelper {
    public static final Object NULL_DISCRIMINATOR = new MarkerObject("<null discriminator>");
    public static final Object NOT_NULL_DISCRIMINATOR = new MarkerObject("<not null discriminator>");

    static BasicType<?> getDiscriminatorType(PersistentClass persistentClass) {
        Type discriminatorType = persistentClass.getDiscriminator().getType();
        if (discriminatorType instanceof BasicType) {
            return (BasicType)discriminatorType;
        }
        throw new MappingException("Illegal discriminator type: " + discriminatorType.getName());
    }

    static String getDiscriminatorSQLValue(PersistentClass persistentClass, Dialect dialect, SessionFactoryImplementor factory) {
        if (persistentClass.isDiscriminatorValueNull()) {
            return "null";
        }
        if (persistentClass.isDiscriminatorValueNotNull()) {
            return "not null";
        }
        return DiscriminatorHelper.discriminatorSqlLiteral(DiscriminatorHelper.getDiscriminatorType(persistentClass), persistentClass, dialect);
    }

    private static Object parseDiscriminatorValue(PersistentClass persistentClass) {
        BasicType<?> discriminatorType = DiscriminatorHelper.getDiscriminatorType(persistentClass);
        try {
            return discriminatorType.getJavaTypeDescriptor().fromString(persistentClass.getDiscriminatorValue());
        }
        catch (Exception e) {
            throw new MappingException("Could not parse discriminator value", e);
        }
    }

    static Object getDiscriminatorValue(PersistentClass persistentClass) {
        if (persistentClass.isDiscriminatorValueNull()) {
            return NULL_DISCRIMINATOR;
        }
        if (persistentClass.isDiscriminatorValueNotNull()) {
            return NOT_NULL_DISCRIMINATOR;
        }
        return DiscriminatorHelper.parseDiscriminatorValue(persistentClass);
    }

    private static <T> String discriminatorSqlLiteral(BasicType<T> discriminatorType, PersistentClass persistentClass, Dialect dialect) {
        return DiscriminatorHelper.jdbcLiteral(discriminatorType.getJavaTypeDescriptor().fromString(persistentClass.getDiscriminatorValue()), discriminatorType.getJdbcLiteralFormatter(), dialect);
    }

    public static <T> String jdbcLiteral(T value, JdbcLiteralFormatter<T> formatter, Dialect dialect) {
        try {
            return formatter.toJdbcLiteral(value, dialect, null);
        }
        catch (Exception e) {
            throw new MappingException("Could not format discriminator value to SQL string", e);
        }
    }
}

