/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.entity;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Map;
import java.util.Objects;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.metamodel.RepresentationMode;
import org.hibernate.metamodel.mapping.EntityDiscriminatorMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.model.convert.spi.BasicValueConverter;
import org.hibernate.metamodel.spi.MappingMetamodelImplementor;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.type.AbstractType;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.java.ClassJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.StringJavaType;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.jdbc.JdbcType;

public class DiscriminatorType<T>
extends AbstractType
implements BasicType<T>,
BasicValueConverter<T, Object> {
    private final BasicType<Object> underlyingType;
    private final Loadable persister;

    public DiscriminatorType(BasicType<?> underlyingType, Loadable persister) {
        this.underlyingType = underlyingType;
        this.persister = persister;
    }

    public BasicType<?> getUnderlyingType() {
        return this.underlyingType;
    }

    @Override
    public BasicValueConverter<T, ?> getValueConverter() {
        return this;
    }

    @Override
    public JavaType<?> getJdbcJavaType() {
        return this.underlyingType.getJdbcJavaType();
    }

    @Override
    public T toDomainValue(Object discriminatorValue) {
        if (discriminatorValue == null) {
            return null;
        }
        EntityDiscriminatorMapping.DiscriminatorValueDetails valueDetails = this.persister.getDiscriminatorMapping().resolveDiscriminatorValue(discriminatorValue);
        if (valueDetails == null) {
            throw new HibernateException("Unable to resolve discriminator value [" + discriminatorValue + "] to entity name");
        }
        EntityMappingType indicatedEntity = valueDetails.getIndicatedEntity();
        return (T)(indicatedEntity.getRepresentationStrategy().getMode() == RepresentationMode.POJO ? indicatedEntity.getJavaType().getJavaTypeClass() : indicatedEntity.getEntityName());
    }

    @Override
    public Object toRelationalValue(T domainForm) {
        if (domainForm == null) {
            return null;
        }
        MappingMetamodelImplementor mappingMetamodel = this.persister.getFactory().getRuntimeMetamodels().getMappingMetamodel();
        Loadable loadable = domainForm instanceof Class ? (Loadable)mappingMetamodel.getEntityDescriptor((Class)domainForm) : (Loadable)mappingMetamodel.getEntityDescriptor((String)domainForm);
        return loadable.getDiscriminatorValue();
    }

    @Override
    public JavaType<T> getDomainJavaType() {
        return this.getExpressibleJavaType();
    }

    @Override
    public JavaType<Object> getRelationalJavaType() {
        return this.underlyingType.getExpressibleJavaType();
    }

    @Override
    public Class<?> getReturnedClass() {
        return Class.class;
    }

    public Class getJavaType() {
        return Class.class;
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public T extract(CallableStatement statement, int paramIndex, SharedSessionContractImplementor session) throws SQLException {
        Object discriminatorValue = this.underlyingType.extract(statement, paramIndex, session);
        return this.toDomainValue(discriminatorValue);
    }

    @Override
    public T extract(CallableStatement statement, String paramName, SharedSessionContractImplementor session) throws SQLException {
        Object discriminatorValue = this.underlyingType.extract(statement, paramName, session);
        return this.toDomainValue(discriminatorValue);
    }

    @Override
    public void nullSafeSet(PreparedStatement st, Object value, int index, boolean[] settable, SharedSessionContractImplementor session) throws HibernateException, SQLException {
        this.nullSafeSet(st, value, index, session);
    }

    @Override
    public void nullSafeSet(PreparedStatement st, Object value, int index, SharedSessionContractImplementor session) throws HibernateException, SQLException {
        this.underlyingType.nullSafeSet(st, this.toRelationalValue((T)value), index, session);
    }

    @Override
    public String toLoggableString(Object value, SessionFactoryImplementor factory) throws HibernateException {
        return value == null ? "[null]" : value.toString();
    }

    @Override
    public Object deepCopy(Object value, SessionFactoryImplementor factory) throws HibernateException {
        return value;
    }

    @Override
    public Object replace(Object original, Object target, SharedSessionContractImplementor session, Object owner, Map<Object, Object> copyCache) throws HibernateException {
        return original;
    }

    @Override
    public boolean[] toColumnNullness(Object value, Mapping mapping) {
        return value == null ? ArrayHelper.FALSE : ArrayHelper.TRUE;
    }

    @Override
    public boolean isDirty(Object old, Object current, boolean[] checkable, SharedSessionContractImplementor session) throws HibernateException {
        return Objects.equals(old, current);
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        return this.toRelationalValue((T)value);
    }

    @Override
    public int[] getSqlTypeCodes(Mapping mapping) throws MappingException {
        return this.underlyingType.getSqlTypeCodes(mapping);
    }

    @Override
    public int getColumnSpan(Mapping mapping) throws MappingException {
        return this.underlyingType.getColumnSpan(mapping);
    }

    @Override
    public boolean canDoExtraction() {
        return this.underlyingType.canDoExtraction();
    }

    @Override
    public JavaType<T> getExpressibleJavaType() {
        return this.persister.getRepresentationStrategy().getMode() == RepresentationMode.POJO ? ClassJavaType.INSTANCE : StringJavaType.INSTANCE;
    }

    @Override
    public JavaType<T> getJavaTypeDescriptor() {
        return this.getExpressibleJavaType();
    }

    @Override
    public JavaType<T> getMappedJavaType() {
        return this.getExpressibleJavaType();
    }

    @Override
    public JdbcType getJdbcType() {
        return this.underlyingType.getJdbcType();
    }

    @Override
    public ValueExtractor<T> getJdbcValueExtractor() {
        return this.underlyingType.getJdbcValueExtractor();
    }

    @Override
    public ValueBinder<T> getJdbcValueBinder() {
        return this.underlyingType.getJdbcValueBinder();
    }

    @Override
    public JdbcLiteralFormatter getJdbcLiteralFormatter() {
        return this.underlyingType.getJdbcLiteralFormatter();
    }

    @Override
    public String[] getRegistrationKeys() {
        return ArrayHelper.EMPTY_STRING_ARRAY;
    }
}

