/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.entity;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.MappingException;
import org.hibernate.bytecode.spi.BytecodeEnhancementMetadata;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.cache.spi.access.NaturalIdDataAccess;
import org.hibernate.cache.spi.entry.CacheEntry;
import org.hibernate.cache.spi.entry.CacheEntryStructure;
import org.hibernate.engine.spi.CascadeStyle;
import org.hibernate.engine.spi.EntityEntryFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.generator.BeforeExecutionGenerator;
import org.hibernate.generator.Generator;
import org.hibernate.generator.internal.VersionGeneration;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.internal.FilterAliasGenerator;
import org.hibernate.internal.TableGroupFilterAliasGenerator;
import org.hibernate.loader.ast.spi.MultiIdLoadOptions;
import org.hibernate.loader.ast.spi.MultiNaturalIdLoader;
import org.hibernate.loader.ast.spi.NaturalIdLoader;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.spi.EntityRepresentationStrategy;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.persister.walking.spi.AttributeSource;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableInsertStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.sql.ast.spi.SqlAliasStemHelper;
import org.hibernate.sql.ast.tree.from.RootTableGroupProducer;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.tuple.entity.EntityMetamodel;
import org.hibernate.type.BasicType;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.VersionJavaType;

public interface EntityPersister
extends EntityMappingType,
RootTableGroupProducer,
AttributeSource {
    @Deprecated(since="6.2")
    public static final String ENTITY_ID = "id";

    public void postInstantiate() throws MappingException;

    public SessionFactoryImplementor getFactory();

    @Override
    default public String getSqlAliasStem() {
        return SqlAliasStemHelper.INSTANCE.generateStemFromEntityName(this.getEntityName());
    }

    public EntityEntryFactory getEntityEntryFactory();

    public String getRootEntityName();

    @Override
    public String getEntityName();

    @Override
    public SqmMultiTableMutationStrategy getSqmMultiTableMutationStrategy();

    @Override
    public SqmMultiTableInsertStrategy getSqmMultiTableInsertStrategy();

    public EntityMetamodel getEntityMetamodel();

    default public Object initializeEnhancedEntityUsedAsProxy(Object entity, String nameOfAttributeBeingAccessed, SharedSessionContractImplementor session) {
        throw new UnsupportedOperationException("Initialization of entity enhancement used to act like a proxy is not supported by this EntityPersister : " + this.getClass().getName());
    }

    public boolean isSubclassEntityName(String var1);

    public Serializable[] getPropertySpaces();

    public Serializable[] getQuerySpaces();

    default public String[] getSynchronizationSpaces() {
        return (String[])this.getQuerySpaces();
    }

    default public String[] getSynchronizedQuerySpaces() {
        return (String[])this.getQuerySpaces();
    }

    @Override
    default public void visitQuerySpaces(Consumer<String> querySpaceConsumer) {
        String[] spaces;
        for (String space : spaces = this.getSynchronizedQuerySpaces()) {
            querySpaceConsumer.accept(space);
        }
    }

    public boolean hasProxy();

    public boolean hasCollections();

    public boolean hasMutableProperties();

    public boolean hasSubselectLoadableCollections();

    public boolean hasCascades();

    default public boolean hasCascadeDelete() {
        return this.hasCascades();
    }

    default public boolean hasOwnedCollections() {
        return this.hasCollections();
    }

    public boolean isMutable();

    public boolean isInherited();

    public boolean isIdentifierAssignedByInsert();

    @Deprecated(since="6", forRemoval=true)
    public Type getPropertyType(String var1) throws MappingException;

    public int[] findDirty(Object[] var1, Object[] var2, Object var3, SharedSessionContractImplementor var4);

    public int[] findModified(Object[] var1, Object[] var2, Object var3, SharedSessionContractImplementor var4);

    public boolean hasIdentifierProperty();

    @Deprecated(since="6")
    default public boolean canExtractIdOutOfEntity() {
        return true;
    }

    public boolean isVersioned();

    public BasicType<?> getVersionType();

    default public VersionJavaType<Object> getVersionJavaType() {
        return (VersionJavaType)this.getVersionType().getJavaTypeDescriptor();
    }

    public int getVersionProperty();

    public boolean hasNaturalIdentifier();

    public int[] getNaturalIdentifierProperties();

    public Object getNaturalIdentifierSnapshot(Object var1, SharedSessionContractImplementor var2);

    @Deprecated
    public IdentifierGenerator getIdentifierGenerator();

    default public Generator getGenerator() {
        return this.getIdentifierGenerator();
    }

    default public BeforeExecutionGenerator getVersionGenerator() {
        return new VersionGeneration(this.getVersionMapping());
    }

    @Override
    default public AttributeMapping getAttributeMapping(int position) {
        return this.getAttributeMappings().get(position);
    }

    @Override
    default public void breakDownJdbcValues(Object domainValue, ModelPart.JdbcValueConsumer valueConsumer, SharedSessionContractImplementor session) {
        if (domainValue instanceof Object[]) {
            Object[] values = (Object[])domainValue;
            for (int i = 0; i < this.getNumberOfAttributeMappings(); ++i) {
                AttributeMapping attributeMapping = this.getAttributeMapping(i);
                attributeMapping.breakDownJdbcValues(values[i], valueConsumer, session);
            }
        } else {
            for (int i = 0; i < this.getNumberOfAttributeMappings(); ++i) {
                AttributeMapping attributeMapping = this.getAttributeMapping(i);
                Object attributeValue = attributeMapping.getPropertyAccess().getGetter().get(domainValue);
                attributeMapping.breakDownJdbcValues(attributeValue, valueConsumer, session);
            }
        }
    }

    public boolean hasLazyProperties();

    @Override
    default public NaturalIdLoader<?> getNaturalIdLoader() {
        throw new UnsupportedOperationException("EntityPersister implementation '" + this.getClass().getName() + "' does not support 'NaturalIdLoader'");
    }

    @Override
    default public MultiNaturalIdLoader<?> getMultiNaturalIdLoader() {
        throw new UnsupportedOperationException("EntityPersister implementation '" + this.getClass().getName() + "' does not support 'MultiNaturalIdLoader'");
    }

    public Object loadEntityIdByNaturalId(Object[] var1, LockOptions var2, SharedSessionContractImplementor var3);

    public Object load(Object var1, Object var2, LockMode var3, SharedSessionContractImplementor var4);

    @Deprecated(since="6.0")
    default public Object load(Object id, Object optionalObject, LockMode lockMode, SharedSessionContractImplementor session, Boolean readOnly) throws HibernateException {
        return this.load(id, optionalObject, lockMode, session);
    }

    public Object load(Object var1, Object var2, LockOptions var3, SharedSessionContractImplementor var4);

    default public Object load(Object id, Object optionalObject, LockOptions lockOptions, SharedSessionContractImplementor session, Boolean readOnly) throws HibernateException {
        return this.load(id, optionalObject, lockOptions, session);
    }

    public List<?> multiLoad(Object[] var1, EventSource var2, MultiIdLoadOptions var3);

    public void lock(Object var1, Object var2, Object var3, LockMode var4, EventSource var5);

    public void lock(Object var1, Object var2, Object var3, LockOptions var4, EventSource var5);

    public void insert(Object var1, Object[] var2, Object var3, SharedSessionContractImplementor var4);

    public Object insert(Object[] var1, Object var2, SharedSessionContractImplementor var3);

    public void delete(Object var1, Object var2, Object var3, SharedSessionContractImplementor var4);

    public void update(Object var1, Object[] var2, int[] var3, boolean var4, Object[] var5, Object var6, Object var7, Object var8, SharedSessionContractImplementor var9);

    public Type[] getPropertyTypes();

    public String[] getPropertyNames();

    public boolean[] getPropertyInsertability();

    public boolean[] getPropertyUpdateability();

    public boolean[] getPropertyCheckability();

    public boolean[] getPropertyNullability();

    public boolean[] getPropertyVersionability();

    public boolean[] getPropertyLaziness();

    public CascadeStyle[] getPropertyCascadeStyles();

    public Type getIdentifierType();

    public String getIdentifierPropertyName();

    public boolean isCacheInvalidationRequired();

    public boolean isLazyPropertiesCacheable();

    public boolean canReadFromCache();

    public boolean canWriteToCache();

    @Deprecated
    public boolean hasCache();

    public EntityDataAccess getCacheAccessStrategy();

    public CacheEntryStructure getCacheEntryStructure();

    public CacheEntry buildCacheEntry(Object var1, Object[] var2, Object var3, SharedSessionContractImplementor var4);

    public boolean hasNaturalIdCache();

    public NaturalIdDataAccess getNaturalIdCacheAccessStrategy();

    @Deprecated(since="6.0")
    public ClassMetadata getClassMetadata();

    public boolean isBatchLoadable();

    public boolean isSelectBeforeUpdateRequired();

    public Object[] getDatabaseSnapshot(Object var1, SharedSessionContractImplementor var2) throws HibernateException;

    public Object getIdByUniqueKey(Object var1, String var2, SharedSessionContractImplementor var3);

    public Object getCurrentVersion(Object var1, SharedSessionContractImplementor var2) throws HibernateException;

    public Object forceVersionIncrement(Object var1, Object var2, SharedSessionContractImplementor var3) throws HibernateException;

    public boolean isInstrumented();

    public boolean hasInsertGeneratedProperties();

    public boolean hasUpdateGeneratedProperties();

    public boolean isVersionPropertyGenerated();

    public void afterInitialize(Object var1, SharedSessionContractImplementor var2);

    public void afterReassociate(Object var1, SharedSessionContractImplementor var2);

    public Object createProxy(Object var1, SharedSessionContractImplementor var2);

    public Boolean isTransient(Object var1, SharedSessionContractImplementor var2);

    public Object[] getPropertyValuesToInsert(Object var1, Map<Object, Object> var2, SharedSessionContractImplementor var3);

    public void processInsertGeneratedProperties(Object var1, Object var2, Object[] var3, SharedSessionContractImplementor var4);

    public void processUpdateGeneratedProperties(Object var1, Object var2, Object[] var3, SharedSessionContractImplementor var4);

    public Class<?> getMappedClass();

    public boolean implementsLifecycle();

    public Class<?> getConcreteProxyClass();

    @Override
    default public void setValues(Object object, Object[] values) {
        this.setPropertyValues(object, values);
    }

    @Deprecated(since="6.0")
    public void setPropertyValues(Object var1, Object[] var2);

    @Override
    default public void setValue(Object object, int i, Object value) {
        this.setPropertyValue(object, i, value);
    }

    @Deprecated(since="6.0")
    public void setPropertyValue(Object var1, int var2, Object var3);

    @Override
    default public Object[] getValues(Object object) {
        return this.getPropertyValues(object);
    }

    @Deprecated(since="6.0")
    public Object[] getPropertyValues(Object var1);

    @Override
    default public Object getValue(Object object, int i) {
        return this.getPropertyValue(object, i);
    }

    @Deprecated(since="6.0")
    public Object getPropertyValue(Object var1, int var2) throws HibernateException;

    public Object getPropertyValue(Object var1, String var2);

    public Object getIdentifier(Object var1, SharedSessionContractImplementor var2);

    public void setIdentifier(Object var1, Object var2, SharedSessionContractImplementor var3);

    public Object getVersion(Object var1) throws HibernateException;

    public Object instantiate(Object var1, SharedSessionContractImplementor var2);

    public boolean isInstance(Object var1);

    public boolean hasUninitializedLazyProperties(Object var1);

    public void resetIdentifier(Object var1, Object var2, Object var3, SharedSessionContractImplementor var4);

    public EntityPersister getSubclassEntityPersister(Object var1, SessionFactoryImplementor var2);

    @Override
    public EntityRepresentationStrategy getRepresentationStrategy();

    @Override
    default public EntityMappingType getEntityMappingType() {
        return this;
    }

    public BytecodeEnhancementMetadata getInstrumentationMetadata();

    default public BytecodeEnhancementMetadata getBytecodeEnhancementMetadata() {
        return this.getInstrumentationMetadata();
    }

    public FilterAliasGenerator getFilterAliasGenerator(String var1);

    default public FilterAliasGenerator getFilterAliasGenerator(TableGroup rootTableGroup) {
        if (!1.$assertionsDisabled && !(this instanceof Joinable)) {
            throw new AssertionError();
        }
        return new TableGroupFilterAliasGenerator(((Joinable)((Object)this)).getTableName(), rootTableGroup);
    }

    public int[] resolveAttributeIndexes(String[] var1);

    default public int[] resolveDirtyAttributeIndexes(Object[] values, Object[] loadedState, String[] attributeNames, SessionImplementor session) {
        return this.resolveAttributeIndexes(attributeNames);
    }

    public boolean canUseReferenceCacheEntries();

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

