/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.entity.mutation;

import org.hibernate.engine.OptimisticLockStyle;
import org.hibernate.engine.jdbc.batch.internal.BasicBatchKey;
import org.hibernate.engine.jdbc.mutation.JdbcValueBindings;
import org.hibernate.engine.jdbc.mutation.MutationExecutor;
import org.hibernate.engine.jdbc.mutation.ParameterUsage;
import org.hibernate.engine.jdbc.mutation.group.PreparedStatementDetails;
import org.hibernate.engine.jdbc.mutation.internal.ModelMutationHelper;
import org.hibernate.engine.jdbc.mutation.spi.MutationExecutorService;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.EntityRowIdMapping;
import org.hibernate.metamodel.mapping.SingularAttributeMapping;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.persister.entity.mutation.AbstractMutationCoordinator;
import org.hibernate.persister.entity.mutation.EntityTableMapping;
import org.hibernate.sql.model.MutationOperationGroup;
import org.hibernate.sql.model.MutationTarget;
import org.hibernate.sql.model.MutationType;
import org.hibernate.sql.model.TableMapping;
import org.hibernate.sql.model.ast.builder.MutationGroupBuilder;
import org.hibernate.sql.model.ast.builder.RestrictedTableMutationBuilder;
import org.hibernate.sql.model.ast.builder.TableDeleteBuilder;
import org.hibernate.sql.model.ast.builder.TableDeleteBuilderSkipped;
import org.hibernate.sql.model.ast.builder.TableDeleteBuilderStandard;

public class DeleteCoordinator
extends AbstractMutationCoordinator {
    private final MutationOperationGroup staticOperationGroup = this.generateOperationGroup(null, true, null);
    private final BasicBatchKey batchKey;
    private MutationOperationGroup noVersionDeleteGroup;

    public DeleteCoordinator(AbstractEntityPersister entityPersister, SessionFactoryImplementor factory) {
        super(entityPersister, factory);
        this.batchKey = new BasicBatchKey(entityPersister.getEntityName() + "#DELETE");
        if (!entityPersister.isVersioned()) {
            this.noVersionDeleteGroup = this.staticOperationGroup;
        }
    }

    public MutationOperationGroup getStaticDeleteGroup() {
        return this.staticOperationGroup;
    }

    public BasicBatchKey getBatchKey() {
        return this.batchKey;
    }

    public void coordinateDelete(Object entity, Object id, Object version, SharedSessionContractImplementor session) {
        Object rowId;
        boolean isImpliedOptimisticLocking = this.entityPersister().optimisticLockStyle().isAllOrDirty();
        PersistenceContext persistenceContext = session.getPersistenceContextInternal();
        EntityEntry entry = persistenceContext.getEntry(entity);
        Object[] loadedState = entry != null && isImpliedOptimisticLocking ? entry.getLoadedState() : null;
        Object object = rowId = entry != null && this.entityPersister().hasRowId() ? entry.getRowId() : null;
        if (isImpliedOptimisticLocking && loadedState != null || rowId != null) {
            this.doDynamicDelete(entity, id, rowId, loadedState, session);
        } else {
            this.doStaticDelete(entity, id, entry == null ? null : entry.getLoadedState(), version, session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDynamicDelete(Object entity, Object id, Object rowId, Object[] loadedState, SharedSessionContractImplementor session) {
        MutationOperationGroup operationGroup = this.generateOperationGroup(loadedState, true, session);
        MutationExecutor mutationExecutor = this.executor(session, operationGroup);
        operationGroup.forEachOperation((position, mutation) -> {
            if (mutation != null) {
                String tableName = mutation.getTableDetails().getTableName();
                mutationExecutor.getPreparedStatementDetails(tableName);
            }
        });
        this.applyLocking(null, loadedState, mutationExecutor, session);
        this.applyId(id, rowId, mutationExecutor, operationGroup, session);
        try {
            mutationExecutor.execute(entity, null, null, (statementDetails, affectedRowCount, batchPosition) -> ModelMutationHelper.identifiedResultsCheck(statementDetails, affectedRowCount, batchPosition, this.entityPersister(), id, this.factory()), session);
        }
        finally {
            mutationExecutor.release();
        }
    }

    private MutationExecutor executor(SharedSessionContractImplementor session, MutationOperationGroup group) {
        return session.getFactory().getServiceRegistry().getService(MutationExecutorService.class).createExecutor(() -> this.batchKey, group, session);
    }

    protected void applyLocking(Object version, Object[] loadedState, MutationExecutor mutationExecutor, SharedSessionContractImplementor session) {
        JdbcValueBindings jdbcValueBindings = mutationExecutor.getJdbcValueBindings();
        OptimisticLockStyle optimisticLockStyle = this.entityPersister().optimisticLockStyle();
        switch (optimisticLockStyle) {
            case VERSION: {
                this.applyVersionLocking(version, session, jdbcValueBindings);
                break;
            }
            case ALL: 
            case DIRTY: {
                this.applyAllOrDirtyLocking(loadedState, session, jdbcValueBindings);
            }
        }
    }

    private void applyAllOrDirtyLocking(Object[] loadedState, SharedSessionContractImplementor session, JdbcValueBindings jdbcValueBindings) {
        if (loadedState != null) {
            boolean[] versionability = this.entityPersister().getPropertyVersionability();
            this.entityPersister().forEachAttributeMapping((attributeIndex, attribute) -> {
                Object loadedValue;
                if (versionability[attributeIndex] && attribute instanceof SingularAttributeMapping && (loadedValue = loadedState[attributeIndex]) != null) {
                    attribute.breakDownJdbcValues(loadedValue, (jdbcValue, jdbcValueMapping) -> {
                        if (jdbcValue == null) {
                            return;
                        }
                        jdbcValueBindings.bindValue(jdbcValue, this.entityPersister().getAttributeMutationTableName(attributeIndex), jdbcValueMapping.getSelectionExpression(), ParameterUsage.RESTRICT, session);
                    }, session);
                }
            });
        }
    }

    private void applyVersionLocking(Object version, SharedSessionContractImplementor session, JdbcValueBindings jdbcValueBindings) {
        if (version != null && this.entityPersister().getVersionMapping() != null) {
            jdbcValueBindings.bindValue(version, this.entityPersister().getIdentifierTableMapping().getTableName(), this.entityPersister().getVersionMapping().getSelectionExpression(), ParameterUsage.RESTRICT, session);
        }
    }

    protected void applyId(Object id, Object rowId, MutationExecutor mutationExecutor, MutationOperationGroup operationGroup, SharedSessionContractImplementor session) {
        JdbcValueBindings jdbcValueBindings = mutationExecutor.getJdbcValueBindings();
        EntityRowIdMapping rowIdMapping = this.entityPersister().getRowIdMapping();
        operationGroup.forEachOperation((position, jdbcMutation) -> {
            EntityTableMapping tableDetails = (EntityTableMapping)jdbcMutation.getTableDetails();
            DeleteCoordinator.breakDownIdJdbcValues(id, rowId, session, jdbcValueBindings, rowIdMapping, tableDetails);
            PreparedStatementDetails statementDetails = mutationExecutor.getPreparedStatementDetails(tableDetails.getTableName());
            if (statementDetails != null) {
                statementDetails.resolveStatement();
            }
        });
    }

    private static void breakDownIdJdbcValues(Object id, Object rowId, SharedSessionContractImplementor session, JdbcValueBindings jdbcValueBindings, EntityRowIdMapping rowIdMapping, EntityTableMapping tableDetails) {
        if (rowId != null && rowIdMapping != null && tableDetails.isIdentifierTable()) {
            jdbcValueBindings.bindValue(rowId, tableDetails.getTableName(), rowIdMapping.getRowIdName(), ParameterUsage.RESTRICT, session);
        } else {
            tableDetails.getKeyMapping().breakDownKeyJdbcValues(id, (jdbcValue, columnMapping) -> jdbcValueBindings.bindValue(jdbcValue, tableDetails.getTableName(), columnMapping.getColumnName(), ParameterUsage.RESTRICT, session), session);
        }
    }

    protected void doStaticDelete(Object entity, Object id, Object[] loadedState, Object version, SharedSessionContractImplementor session) {
        MutationOperationGroup operationGroupToUse;
        boolean applyVersion;
        if (entity == null) {
            applyVersion = false;
            operationGroupToUse = this.resolveNoVersionDeleteGroup(session);
        } else {
            applyVersion = true;
            operationGroupToUse = this.staticOperationGroup;
        }
        MutationExecutor mutationExecutor = this.executor(session, operationGroupToUse);
        this.staticOperationGroup.forEachOperation((position, mutation) -> {
            if (mutation != null) {
                mutationExecutor.getPreparedStatementDetails(mutation.getTableDetails().getTableName());
            }
        });
        if (applyVersion) {
            this.applyLocking(version, null, mutationExecutor, session);
        }
        JdbcValueBindings jdbcValueBindings = mutationExecutor.getJdbcValueBindings();
        this.bindPartitionColumnValueBindings(loadedState, session, jdbcValueBindings);
        this.applyId(id, null, mutationExecutor, this.staticOperationGroup, session);
        mutationExecutor.execute(entity, null, null, (statementDetails, affectedRowCount, batchPosition) -> ModelMutationHelper.identifiedResultsCheck(statementDetails, affectedRowCount, batchPosition, this.entityPersister(), id, this.factory()), session);
        mutationExecutor.release();
    }

    protected MutationOperationGroup resolveNoVersionDeleteGroup(SharedSessionContractImplementor session) {
        if (this.noVersionDeleteGroup == null) {
            this.noVersionDeleteGroup = this.generateOperationGroup(null, false, session);
        }
        return this.noVersionDeleteGroup;
    }

    protected MutationOperationGroup generateOperationGroup(Object[] loadedState, boolean applyVersion, SharedSessionContractImplementor session) {
        MutationGroupBuilder deleteGroupBuilder = new MutationGroupBuilder(MutationType.DELETE, this.entityPersister());
        this.entityPersister().forEachMutableTableReverse(tableMapping -> {
            TableDeleteBuilder tableDeleteBuilder = tableMapping.isCascadeDeleteEnabled() ? new TableDeleteBuilderSkipped((TableMapping)tableMapping) : new TableDeleteBuilderStandard((MutationTarget<?>)this.entityPersister(), (TableMapping)tableMapping, this.factory());
            deleteGroupBuilder.addTableDetailsBuilder(tableDeleteBuilder);
        });
        this.applyTableDeleteDetails(deleteGroupBuilder, loadedState, applyVersion, session);
        return this.createOperationGroup(null, deleteGroupBuilder.buildMutationGroup());
    }

    private void applyTableDeleteDetails(MutationGroupBuilder deleteGroupBuilder, Object[] loadedState, boolean applyVersion, SharedSessionContractImplementor session) {
        deleteGroupBuilder.forEachTableMutationBuilder(builder -> {
            EntityTableMapping tableMapping = (EntityTableMapping)builder.getMutatingTable().getTableMapping();
            TableDeleteBuilder tableDeleteBuilder = (TableDeleteBuilder)builder;
            DeleteCoordinator.applyKeyDetails(tableDeleteBuilder, tableMapping);
        });
        if (applyVersion) {
            this.applyOptimisticLocking(deleteGroupBuilder, loadedState, session);
            if (this.entityPersister().hasPartitionedSelectionMapping()) {
                this.entityPersister().forEachSelectable((selectionIndex, selectableMapping) -> {
                    if (selectableMapping.isPartitioned()) {
                        String tableNameForMutation = this.entityPersister().physicalTableNameForMutation(selectableMapping);
                        RestrictedTableMutationBuilder rootTableMutationBuilder = (RestrictedTableMutationBuilder)deleteGroupBuilder.findTableDetailsBuilder(tableNameForMutation);
                        rootTableMutationBuilder.addKeyRestrictionLeniently(selectableMapping);
                    }
                });
            }
        }
    }

    private static void applyKeyDetails(TableDeleteBuilder tableDeleteBuilder, EntityTableMapping tableMapping) {
        tableMapping.getKeyMapping().forEachKeyColumn(columnMapping -> tableDeleteBuilder.addKeyRestriction(columnMapping.getColumnName(), columnMapping.getWriteExpression(), columnMapping.getJdbcMapping()));
    }

    protected void applyOptimisticLocking(MutationGroupBuilder mutationGroupBuilder, Object[] loadedState, SharedSessionContractImplementor session) {
        OptimisticLockStyle optimisticLockStyle = this.entityPersister().optimisticLockStyle();
        if (optimisticLockStyle.isVersion() && this.entityPersister().getVersionMapping() != null) {
            this.applyVersionBasedOptLocking(mutationGroupBuilder);
        } else if (loadedState != null && this.entityPersister().optimisticLockStyle().isAllOrDirty()) {
            this.applyNonVersionOptLocking(optimisticLockStyle, mutationGroupBuilder, loadedState, session);
        }
    }

    protected void applyVersionBasedOptLocking(MutationGroupBuilder mutationGroupBuilder) {
        assert (this.entityPersister().optimisticLockStyle() == OptimisticLockStyle.VERSION);
        assert (this.entityPersister().getVersionMapping() != null);
        String tableNameForMutation = this.entityPersister().physicalTableNameForMutation(this.entityPersister().getVersionMapping());
        RestrictedTableMutationBuilder rootTableMutationBuilder = (RestrictedTableMutationBuilder)mutationGroupBuilder.findTableDetailsBuilder(tableNameForMutation);
        rootTableMutationBuilder.addOptimisticLockRestriction(this.entityPersister().getVersionMapping());
    }

    protected void applyNonVersionOptLocking(OptimisticLockStyle lockStyle, MutationGroupBuilder mutationGroupBuilder, Object[] loadedState, SharedSessionContractImplementor session) {
        assert (loadedState != null);
        assert (lockStyle.isAllOrDirty());
        assert (this.entityPersister().optimisticLockStyle().isAllOrDirty());
        assert (session != null);
        boolean[] versionability = this.entityPersister().getPropertyVersionability();
        this.entityPersister().forEachAttributeMapping((attributeIndex, attribute) -> {
            if (versionability[attributeIndex] && attribute instanceof SingularAttributeMapping) {
                this.breakDownJdbcValues(mutationGroupBuilder, session, (AttributeMapping)attribute, loadedState[attributeIndex]);
            }
        });
    }

    private void breakDownJdbcValues(MutationGroupBuilder mutationGroupBuilder, SharedSessionContractImplementor session, AttributeMapping attribute, Object loadedValue) {
        attribute.breakDownJdbcValues(loadedValue, (jdbcValue, columnMapping) -> {
            String physicalTableName = this.entityPersister().physicalTableNameForMutation(columnMapping);
            RestrictedTableMutationBuilder tableMutationBuilder = (RestrictedTableMutationBuilder)mutationGroupBuilder.findTableDetailsBuilder(physicalTableName);
            if (tableMutationBuilder != null) {
                if (jdbcValue == null) {
                    tableMutationBuilder.addNullOptimisticLockRestriction(columnMapping);
                } else {
                    tableMutationBuilder.addOptimisticLockRestriction(columnMapping);
                }
            }
        }, session);
    }
}

