/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Consumer;
import org.hibernate.mapping.IndexedConsumer;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.persister.entity.AttributeMappingsList;

public final class ImmutableAttributeMappingList
implements AttributeMappingsList {
    private final AttributeMapping[] list;

    private ImmutableAttributeMappingList(ArrayList<AttributeMapping> objects) {
        this.list = objects.toArray(new AttributeMapping[0]);
    }

    @Override
    public int size() {
        return this.list.length;
    }

    @Override
    public AttributeMapping get(int i) {
        return this.list[i];
    }

    @Override
    public Iterator<AttributeMapping> iterator() {
        return new AttributeMappingIterator();
    }

    @Override
    public void forEach(Consumer<? super AttributeMapping> attributeMappingConsumer) {
        for (AttributeMapping o : this.list) {
            attributeMappingConsumer.accept(o);
        }
    }

    @Override
    public void indexedForEach(IndexedConsumer<? super AttributeMapping> consumer) {
        for (int i = 0; i < this.list.length; ++i) {
            consumer.accept(i, this.list[i]);
        }
    }

    public static final class Builder {
        private final ArrayList<AttributeMapping> builderList;

        public Builder(int sizeHint) {
            this.builderList = new ArrayList(sizeHint);
        }

        public void add(AttributeMapping attributeMapping) {
            Objects.requireNonNull(attributeMapping);
            this.builderList.add(attributeMapping);
        }

        public AttributeMappingsList build() {
            return new ImmutableAttributeMappingList(this.builderList);
        }

        public boolean assertFetchableIndexes() {
            for (int i = 0; i < this.builderList.size(); ++i) {
                AttributeMapping attributeMapping = this.builderList.get(i);
                assert (i == attributeMapping.getFetchableKey());
            }
            return true;
        }
    }

    private final class AttributeMappingIterator
    implements Iterator<AttributeMapping> {
        private int idx = 0;

        private AttributeMappingIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.idx < ImmutableAttributeMappingList.this.list.length;
        }

        @Override
        public AttributeMapping next() {
            return ImmutableAttributeMappingList.this.list[this.idx++];
        }
    }
}

