/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results;

import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.internal.SingleAttributeIdentifierMapping;
import org.hibernate.query.results.DomainResultCreationStateImpl;
import org.hibernate.query.results.ResultSetMappingSqlSelection;
import org.hibernate.spi.EntityIdentifierNavigablePath;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.basic.BasicFetch;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;

public class ResultsHelper {
    public static int jdbcPositionToValuesArrayPosition(int jdbcPosition) {
        return jdbcPosition - 1;
    }

    public static int valuesArrayPositionToJdbcPosition(int valuesArrayPosition) {
        return valuesArrayPosition + 1;
    }

    public static DomainResultCreationStateImpl impl(DomainResultCreationState creationState) {
        return ResultsHelper.unwrap(creationState);
    }

    private static DomainResultCreationStateImpl unwrap(DomainResultCreationState creationState) {
        if (creationState instanceof DomainResultCreationStateImpl) {
            return (DomainResultCreationStateImpl)creationState;
        }
        throw new IllegalArgumentException("Passed DomainResultCreationState not an instance of org.hibernate.query.results.DomainResultCreationStateImpl");
    }

    public static Expression resolveSqlExpression(DomainResultCreationStateImpl resolver, JdbcValuesMetadata jdbcValuesMetadata, TableReference tableReference, SelectableMapping selectableMapping, String columnAlias) {
        return resolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, selectableMapping), processingState -> {
            int jdbcPosition = jdbcValuesMetadata.resolveColumnPosition(columnAlias);
            int valuesArrayPosition = ResultsHelper.jdbcPositionToValuesArrayPosition(jdbcPosition);
            return new ResultSetMappingSqlSelection(valuesArrayPosition, selectableMapping.getJdbcMapping());
        });
    }

    private ResultsHelper() {
    }

    public static boolean isIdentifier(EntityIdentifierMapping identifierDescriptor, String ... names) {
        String identifierAttributeName = identifierDescriptor instanceof SingleAttributeIdentifierMapping ? ((SingleAttributeIdentifierMapping)identifierDescriptor).getAttributeName() : "{id}";
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            if ("{id}".equals(name)) {
                return true;
            }
            if (!identifierAttributeName.equals(name)) continue;
            return true;
        }
        return false;
    }

    public static DomainResult implicitIdentifierResult(EntityIdentifierMapping identifierMapping, EntityIdentifierNavigablePath idPath, DomainResultCreationState creationState) {
        DomainResultCreationStateImpl creationStateImpl = ResultsHelper.impl(creationState);
        TableGroup tableGroup = creationStateImpl.getFromClauseAccess().getTableGroup(idPath.getParent());
        return identifierMapping.createDomainResult(idPath, tableGroup, null, creationState);
    }

    public static String attributeName(ModelPart identifierMapping) {
        if (identifierMapping instanceof EntityIdentifierMapping) {
            return identifierMapping instanceof SingleAttributeIdentifierMapping ? ((SingleAttributeIdentifierMapping)identifierMapping).getAttributeName() : null;
        }
        return identifierMapping.getPartName();
    }

    public static DomainResult convertIdFetchToResult(Fetch fetch, DomainResultCreationState creationState) {
        EntityIdentifierMapping idMapping = (EntityIdentifierMapping)((Object)fetch.getFetchedMapping());
        if (fetch instanceof BasicFetch) {
            BasicFetch basicFetch = (BasicFetch)fetch;
        }
        return null;
    }
}

