/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results.complete;

import jakarta.persistence.AttributeConverter;
import java.util.Objects;
import java.util.function.BiFunction;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.metamodel.model.convert.internal.JpaAttributeConverterImpl;
import org.hibernate.query.results.DomainResultCreationStateImpl;
import org.hibernate.query.results.ResultBuilder;
import org.hibernate.query.results.ResultSetMappingSqlSelection;
import org.hibernate.query.results.ResultsHelper;
import org.hibernate.query.results.complete.CompleteResultBuilderBasicValued;
import org.hibernate.query.results.dynamic.DynamicFetchBuilderLegacy;
import org.hibernate.resource.beans.spi.ManagedBean;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;
import org.hibernate.type.descriptor.java.BasicJavaType;
import org.hibernate.type.descriptor.java.JavaType;

public class CompleteResultBuilderBasicValuedConverted<O, R>
implements CompleteResultBuilderBasicValued {
    private final String explicitColumnName;
    private final BasicValuedMapping underlyingMapping;
    private final JpaAttributeConverterImpl<O, R> valueConverter;

    public CompleteResultBuilderBasicValuedConverted(String explicitColumnName, ManagedBean<? extends AttributeConverter<O, R>> converterBean, JavaType<? extends AttributeConverter<O, R>> converterJtd, BasicJavaType<O> domainJavaType, BasicValuedMapping underlyingMapping) {
        this.explicitColumnName = explicitColumnName;
        this.underlyingMapping = underlyingMapping;
        this.valueConverter = new JpaAttributeConverterImpl(converterBean, converterJtd, domainJavaType, underlyingMapping.getJdbcMapping().getJavaTypeDescriptor());
    }

    @Override
    public Class<?> getJavaType() {
        return this.valueConverter.getDomainJavaType().getJavaTypeClass();
    }

    @Override
    public ResultBuilder cacheKeyInstance() {
        return this;
    }

    @Override
    public BasicResult<?> buildResult(JdbcValuesMetadata jdbcResultsMetadata, int resultPosition, BiFunction<String, String, DynamicFetchBuilderLegacy> legacyFetchResolver, DomainResultCreationState domainResultCreationState) {
        DomainResultCreationStateImpl creationStateImpl = ResultsHelper.impl(domainResultCreationState);
        SessionFactoryImplementor sessionFactory = creationStateImpl.getSessionFactory();
        String columnName = this.explicitColumnName != null ? this.explicitColumnName : jdbcResultsMetadata.resolveColumnName(creationStateImpl.getNumberOfProcessedSelections() + 1);
        SqlSelection sqlSelection = creationStateImpl.resolveSqlSelection(creationStateImpl.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(columnName), processingState -> {
            int jdbcPosition = this.explicitColumnName != null ? jdbcResultsMetadata.resolveColumnPosition(this.explicitColumnName) : resultPosition + 1;
            int valuesArrayPosition = ResultsHelper.jdbcPositionToValuesArrayPosition(jdbcPosition);
            return new ResultSetMappingSqlSelection(valuesArrayPosition, this.underlyingMapping);
        }), this.valueConverter.getRelationalJavaType(), null, sessionFactory.getTypeConfiguration());
        return new BasicResult<O>(sqlSelection.getValuesArrayPosition(), columnName, this.valueConverter.getDomainJavaType(), this.valueConverter);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompleteResultBuilderBasicValuedConverted that = (CompleteResultBuilderBasicValuedConverted)o;
        if (!Objects.equals(this.explicitColumnName, that.explicitColumnName)) {
            return false;
        }
        if (!this.underlyingMapping.equals(that.underlyingMapping)) {
            return false;
        }
        return this.valueConverter.equals(that.valueConverter);
    }

    public int hashCode() {
        int result = this.explicitColumnName != null ? this.explicitColumnName.hashCode() : 0;
        result = 31 * result + this.underlyingMapping.hashCode();
        result = 31 * result + this.valueConverter.hashCode();
        return result;
    }
}

