/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results.complete;

import java.util.function.Function;
import org.hibernate.LockMode;
import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.basic.BasicFetch;
import org.hibernate.sql.results.graph.entity.EntityResult;
import org.hibernate.sql.results.graph.entity.EntityResultGraphNode;
import org.hibernate.sql.results.graph.entity.internal.EntityAssembler;
import org.hibernate.sql.results.graph.entity.internal.EntityResultInitializer;
import org.hibernate.sql.results.graph.internal.ImmutableFetchList;

public class EntityResultImpl
implements EntityResult {
    private final NavigablePath navigablePath;
    private final EntityValuedModelPart entityValuedModelPart;
    private final Fetch identifierFetch;
    private final BasicFetch<?> discriminatorFetch;
    private final ImmutableFetchList fetches;
    private final boolean hasJoinFetches;
    private final boolean containsCollectionFetches;
    private final String resultAlias;
    private final LockMode lockMode;

    public EntityResultImpl(NavigablePath navigablePath, EntityValuedModelPart entityValuedModelPart, String resultAlias, LockMode lockMode, Function<EntityResultImpl, BasicFetch<?>> discriminatorFetchBuilder, DomainResultCreationState creationState) {
        this.navigablePath = navigablePath;
        this.entityValuedModelPart = entityValuedModelPart;
        this.resultAlias = resultAlias;
        this.lockMode = lockMode;
        SqlAstCreationState sqlAstCreationState = creationState.getSqlAstCreationState();
        sqlAstCreationState.getFromClauseAccess().resolveTableGroup(navigablePath, np -> entityValuedModelPart.getEntityMappingType().getEntityPersister().createRootTableGroup(true, navigablePath, null, () -> p -> {}, sqlAstCreationState, sqlAstCreationState.getCreationContext().getSessionFactory()));
        this.identifierFetch = creationState.visitIdentifierFetch(this);
        this.discriminatorFetch = discriminatorFetchBuilder.apply(this);
        this.fetches = creationState.visitFetches(this);
        this.hasJoinFetches = this.fetches.hasJoinFetches();
        this.containsCollectionFetches = this.fetches.containsCollectionFetches();
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public EntityValuedModelPart getReferencedMappingType() {
        return this.entityValuedModelPart;
    }

    @Override
    public EntityValuedModelPart getEntityValuedModelPart() {
        return this.entityValuedModelPart;
    }

    @Override
    public String getResultVariable() {
        return this.resultAlias;
    }

    @Override
    public ImmutableFetchList getFetches() {
        return this.fetches;
    }

    @Override
    public Fetch findFetch(Fetchable fetchable) {
        return this.fetches.get(fetchable);
    }

    @Override
    public boolean hasJoinFetches() {
        return this.hasJoinFetches;
    }

    @Override
    public boolean containsCollectionFetches() {
        return this.containsCollectionFetches;
    }

    public DomainResultAssembler<?> createResultAssembler(FetchParentAccess parentAccess, AssemblerCreationState creationState) {
        Initializer initializer = creationState.resolveInitializer(this.getNavigablePath(), this.getReferencedModePart(), () -> new EntityResultInitializer((EntityResultGraphNode)this, this.getNavigablePath(), this.lockMode, this.identifierFetch, this.discriminatorFetch, null, creationState));
        return new EntityAssembler(this.getResultJavaType(), initializer.asEntityInitializer());
    }
}

