/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results.dynamic;

import java.util.Objects;
import java.util.function.BiFunction;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.model.convert.spi.BasicValueConverter;
import org.hibernate.query.results.ResultSetMappingSqlSelection;
import org.hibernate.query.results.ResultsHelper;
import org.hibernate.query.results.dynamic.DynamicFetchBuilderLegacy;
import org.hibernate.query.results.dynamic.DynamicResultBuilderBasic;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.JavaType;

public class DynamicResultBuilderBasicStandard
implements DynamicResultBuilderBasic {
    private final String columnName;
    private final int columnPosition;
    private final String resultAlias;
    private final BasicType<?> explicitType;
    private final JavaType<?> explicitJavaType;

    public DynamicResultBuilderBasicStandard(String columnName, String resultAlias) {
        assert (columnName != null);
        this.columnName = columnName;
        this.columnPosition = 0;
        this.resultAlias = resultAlias != null ? resultAlias : columnName;
        this.explicitType = null;
        this.explicitJavaType = null;
    }

    public DynamicResultBuilderBasicStandard(int columnPosition) {
        assert (columnPosition > 0);
        this.columnName = "c" + columnPosition;
        this.columnPosition = columnPosition;
        this.resultAlias = this.columnName;
        this.explicitType = null;
        this.explicitJavaType = null;
    }

    public DynamicResultBuilderBasicStandard(String columnName, String resultAlias, JavaType<?> explicitJavaType) {
        assert (columnName != null);
        this.columnName = columnName;
        this.columnPosition = 0;
        String string = this.resultAlias = resultAlias != null ? resultAlias : columnName;
        assert (explicitJavaType != null);
        this.explicitJavaType = explicitJavaType;
        this.explicitType = null;
    }

    public DynamicResultBuilderBasicStandard(String columnName, String resultAlias, BasicType<?> explicitType) {
        assert (columnName != null);
        this.columnName = columnName;
        this.columnPosition = 0;
        String string = this.resultAlias = resultAlias != null ? resultAlias : columnName;
        assert (explicitType != null);
        this.explicitType = explicitType;
        this.explicitJavaType = null;
    }

    public DynamicResultBuilderBasicStandard(int columnPosition, BasicType<?> explicitType) {
        assert (columnPosition > 0);
        this.columnName = "c" + columnPosition;
        this.columnPosition = columnPosition;
        this.resultAlias = this.columnName;
        assert (explicitType != null);
        this.explicitType = explicitType;
        this.explicitJavaType = null;
    }

    @Override
    public Class<?> getJavaType() {
        if (this.explicitJavaType != null) {
            return this.explicitJavaType.getJavaTypeClass();
        }
        if (this.explicitType != null) {
            return this.explicitType.getJavaType();
        }
        return null;
    }

    public String getColumnName() {
        return this.columnName;
    }

    @Override
    public DynamicResultBuilderBasicStandard cacheKeyInstance() {
        return this;
    }

    @Override
    public BasicResult<?> buildResult(JdbcValuesMetadata jdbcResultsMetadata, int resultPosition, BiFunction<String, String, DynamicFetchBuilderLegacy> legacyFetchResolver, DomainResultCreationState domainResultCreationState) {
        BasicValueConverter converter;
        JavaType<?> jdbcJavaType;
        JavaType<?> javaType;
        SessionFactoryImplementor sessionFactory = domainResultCreationState.getSqlAstCreationState().getCreationContext().getSessionFactory();
        SqlExpressionResolver sqlExpressionResolver = domainResultCreationState.getSqlAstCreationState().getSqlExpressionResolver();
        Expression expression = sqlExpressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(this.columnName), state -> {
            int jdbcPosition = this.columnPosition > 0 ? this.columnPosition : jdbcResultsMetadata.resolveColumnPosition(this.columnName);
            int valuesArrayPosition = ResultsHelper.jdbcPositionToValuesArrayPosition(jdbcPosition);
            BasicType<?> basicType = this.explicitType != null ? this.explicitType : jdbcResultsMetadata.resolveType(jdbcPosition, this.explicitJavaType, sessionFactory);
            return new ResultSetMappingSqlSelection(valuesArrayPosition, basicType);
        });
        if (this.explicitJavaType != null) {
            javaType = this.explicitJavaType;
            jdbcJavaType = this.explicitJavaType;
            converter = null;
        } else {
            JdbcMapping jdbcMapping = expression.getExpressionType().getJdbcMappings().get(0);
            javaType = jdbcMapping.getMappedJavaType();
            jdbcJavaType = jdbcMapping.getJdbcJavaType();
            converter = jdbcMapping.getValueConverter();
        }
        SqlSelection sqlSelection = sqlExpressionResolver.resolveSqlSelection(expression, jdbcJavaType, null, sessionFactory.getTypeConfiguration());
        assert (javaType != null);
        return new BasicResult(sqlSelection.getValuesArrayPosition(), this.resultAlias, javaType, converter);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DynamicResultBuilderBasicStandard that = (DynamicResultBuilderBasicStandard)o;
        if (this.columnPosition != that.columnPosition) {
            return false;
        }
        if (!this.columnName.equals(that.columnName)) {
            return false;
        }
        if (!this.resultAlias.equals(that.resultAlias)) {
            return false;
        }
        if (!Objects.equals(this.explicitType, that.explicitType)) {
            return false;
        }
        return Objects.equals(this.explicitJavaType, that.explicitJavaType);
    }

    public int hashCode() {
        int result = this.columnName.hashCode();
        result = 31 * result + this.columnPosition;
        result = 31 * result + this.resultAlias.hashCode();
        result = 31 * result + (this.explicitType != null ? this.explicitType.hashCode() : 0);
        result = 31 * result + (this.explicitJavaType != null ? this.explicitJavaType.hashCode() : 0);
        return result;
    }
}

