/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results.implicit;

import java.util.function.BiFunction;
import org.hibernate.metamodel.spi.MappingMetamodelImplementor;
import org.hibernate.query.results.ResultBuilder;
import org.hibernate.query.results.dynamic.DynamicFetchBuilderLegacy;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;
import org.hibernate.type.BasicType;
import org.hibernate.type.spi.TypeConfiguration;

public class ImplicitResultClassBuilder
implements ResultBuilder {
    private final Class<?> suppliedResultClass;

    public ImplicitResultClassBuilder(Class<?> suppliedResultClass) {
        this.suppliedResultClass = suppliedResultClass;
    }

    @Override
    public DomainResult<?> buildResult(JdbcValuesMetadata jdbcResultsMetadata, int resultPosition, BiFunction<String, String, DynamicFetchBuilderLegacy> legacyFetchResolver, DomainResultCreationState domainResultCreationState) {
        MappingMetamodelImplementor mappingMetamodel = domainResultCreationState.getSqlAstCreationState().getCreationContext().getMappingMetamodel();
        TypeConfiguration typeConfiguration = mappingMetamodel.getTypeConfiguration();
        int jdbcResultPosition = resultPosition + 1;
        BasicType basicType = jdbcResultsMetadata.resolveType(jdbcResultPosition, typeConfiguration.getJavaTypeRegistry().resolveDescriptor(this.suppliedResultClass), typeConfiguration);
        return new BasicResult(resultPosition, jdbcResultsMetadata.resolveColumnName(jdbcResultPosition), basicType);
    }

    @Override
    public Class<?> getJavaType() {
        return this.suppliedResultClass;
    }

    @Override
    public ResultBuilder cacheKeyInstance() {
        return this;
    }
}

