/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.function;

import java.util.List;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.mapping.IndexedConsumer;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Table;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.metamodel.mapping.SqlExpressible;
import org.hibernate.metamodel.model.convert.spi.BasicValueConverter;
import org.hibernate.query.ReturnableType;
import org.hibernate.query.sqm.function.FunctionRenderingSupport;
import org.hibernate.query.sqm.function.SqmFunctionRegistry;
import org.hibernate.query.sqm.sql.internal.DomainResultProducer;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.FunctionExpression;
import org.hibernate.sql.ast.tree.expression.SelfRenderingExpression;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.sql.results.internal.SqlSelectionImpl;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.spi.TypeConfiguration;

public class SelfRenderingFunctionSqlAstExpression
implements SelfRenderingExpression,
Selectable,
SqlExpressible,
DomainResultProducer,
FunctionExpression {
    private final String functionName;
    private final FunctionRenderingSupport renderer;
    private final List<? extends SqlAstNode> sqlAstArguments;
    private final ReturnableType<?> type;
    private final JdbcMappingContainer expressible;

    public SelfRenderingFunctionSqlAstExpression(String functionName, FunctionRenderingSupport renderer, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> type, JdbcMappingContainer expressible) {
        this.functionName = functionName;
        this.renderer = renderer;
        this.sqlAstArguments = sqlAstArguments;
        this.type = type;
        this.expressible = expressible;
    }

    @Override
    public String getFunctionName() {
        return this.functionName;
    }

    @Override
    public List<? extends SqlAstNode> getArguments() {
        return this.sqlAstArguments;
    }

    @Override
    public JdbcMappingContainer getExpressionType() {
        if (this.type instanceof SqlExpressible) {
            return (JdbcMappingContainer)((Object)this.type);
        }
        return this.expressible;
    }

    protected FunctionRenderingSupport getRenderer() {
        return this.renderer;
    }

    @Override
    public SqlSelection createSqlSelection(int jdbcPosition, int valuesArrayPosition, JavaType javaType, TypeConfiguration typeConfiguration) {
        return new SqlSelectionImpl(jdbcPosition, valuesArrayPosition, this);
    }

    public DomainResult<?> createDomainResult(String resultVariable, DomainResultCreationState creationState) {
        BasicValueConverter converter;
        JavaType<Object> jdbcJavaType;
        JdbcMapping jdbcMapping = this.getJdbcMapping();
        if (jdbcMapping != null) {
            jdbcJavaType = jdbcMapping.getJdbcJavaType();
            converter = jdbcMapping.getValueConverter();
        } else {
            jdbcJavaType = this.type.getExpressibleJavaType();
            converter = null;
        }
        return new BasicResult(creationState.getSqlAstCreationState().getSqlExpressionResolver().resolveSqlSelection(this, jdbcJavaType, null, creationState.getSqlAstCreationState().getCreationContext().getMappingMetamodel().getTypeConfiguration()).getValuesArrayPosition(), resultVariable, this.type.getExpressibleJavaType(), converter);
    }

    @Override
    public void renderToSql(SqlAppender sqlAppender, SqlAstTranslator<?> walker, SessionFactoryImplementor sessionFactory) {
        this.renderer.render(sqlAppender, this.sqlAstArguments, walker);
    }

    @Override
    public String getAlias(Dialect dialect) {
        return null;
    }

    @Override
    public String getAlias(Dialect dialect, Table table) {
        return null;
    }

    @Override
    public boolean isFormula() {
        return false;
    }

    @Override
    public String getTemplate(Dialect dialect, TypeConfiguration typeConfiguration, SqmFunctionRegistry functionRegistry) {
        return null;
    }

    @Override
    public String getText(Dialect dialect) {
        return null;
    }

    @Override
    public String getText() {
        return null;
    }

    @Override
    public String getCustomReadExpression() {
        return null;
    }

    @Override
    public String getCustomWriteExpression() {
        return null;
    }

    @Override
    public JdbcMapping getJdbcMapping() {
        if (this.type instanceof SqlExpressible) {
            return ((SqlExpressible)((Object)this.type)).getJdbcMapping();
        }
        return ((SqlExpressible)this.expressible).getJdbcMapping();
    }

    @Override
    public void applySqlSelections(DomainResultCreationState creationState) {
        SqlAstCreationState sqlAstCreationState = creationState.getSqlAstCreationState();
        SqlExpressionResolver sqlExpressionResolver = sqlAstCreationState.getSqlExpressionResolver();
        JdbcMapping jdbcMapping = this.getJdbcMapping();
        JavaType<Object> jdbcJavaType = jdbcMapping != null ? jdbcMapping.getJdbcJavaType() : this.type.getExpressibleJavaType();
        sqlExpressionResolver.resolveSqlSelection(this, jdbcJavaType, null, sqlAstCreationState.getCreationContext().getMappingMetamodel().getTypeConfiguration());
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        throw new UnsupportedOperationException();
    }
}

