/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal;

import jakarta.persistence.metamodel.Bindable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.SqmJdbcExecutionContextAdapter;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.mutation.internal.MultiTableSqmMutationConverter;
import org.hibernate.query.sqm.spi.SqmParameterMappingModelResolutionAccess;
import org.hibernate.query.sqm.sql.internal.SqlAstQueryPartProcessingStateImpl;
import org.hibernate.query.sqm.tree.SqmDeleteOrUpdateStatement;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.sql.results.internal.SqlSelectionImpl;
import org.hibernate.sql.results.spi.ListResultsConsumer;
import org.hibernate.sql.results.spi.RowTransformer;
import org.jboss.logging.Logger;

public class MatchingIdSelectionHelper {
    private static final Logger log = Logger.getLogger(MatchingIdSelectionHelper.class);

    public static SelectStatement generateMatchingIdSelectStatement(EntityMappingType targetEntityDescriptor, SqmDeleteOrUpdateStatement sqmStatement, boolean queryRoot, Predicate restriction, MultiTableSqmMutationConverter sqmConverter, DomainQueryExecutionContext executionContext, SessionFactoryImplementor sessionFactory) {
        Bindable entityDomainType = ((SqmRoot)sqmStatement.getTarget()).getModel();
        if (log.isTraceEnabled()) {
            log.tracef("Starting generation of entity-id SQM selection - %s", (Object)entityDomainType.getHibernateEntityName());
        }
        QuerySpec idSelectionQuery = new QuerySpec(queryRoot, 1);
        idSelectionQuery.applyPredicate(restriction);
        TableGroup mutatingTableGroup = sqmConverter.getMutatingTableGroup();
        idSelectionQuery.getFromClause().addRoot(mutatingTableGroup);
        ArrayList domainResults = new ArrayList();
        sqmConverter.getProcessingStateStack().push(new SqlAstQueryPartProcessingStateImpl(idSelectionQuery, sqmConverter.getCurrentProcessingState(), sqmConverter.getSqlAstCreationState(), sqmConverter.getCurrentClauseStack()::getCurrent, false));
        targetEntityDescriptor.getIdentifierMapping().applySqlSelections(mutatingTableGroup.getNavigablePath(), mutatingTableGroup, sqmConverter, (selection, jdbcMapping) -> domainResults.add(new BasicResult(selection.getValuesArrayPosition(), null, (JdbcMapping)jdbcMapping)));
        sqmConverter.getProcessingStateStack().pop();
        targetEntityDescriptor.getEntityPersister().applyBaseRestrictions(idSelectionQuery::applyPredicate, mutatingTableGroup, true, executionContext.getSession().getLoadQueryInfluencers().getEnabledFilters(), null, sqmConverter);
        return new SelectStatement(idSelectionQuery, domainResults);
    }

    public static QuerySpec generateMatchingIdSelectQuery(EntityMappingType targetEntityDescriptor, SqmDeleteOrUpdateStatement sqmStatement, DomainParameterXref domainParameterXref, Predicate restriction, MultiTableSqmMutationConverter sqmConverter, SessionFactoryImplementor sessionFactory) {
        Bindable entityDomainType = ((SqmRoot)sqmStatement.getTarget()).getModel();
        if (log.isTraceEnabled()) {
            log.tracef("Starting generation of entity-id SQM selection - %s", (Object)entityDomainType.getHibernateEntityName());
        }
        QuerySpec idSelectionQuery = new QuerySpec(true, 1);
        TableGroup mutatingTableGroup = sqmConverter.getMutatingTableGroup();
        idSelectionQuery.getFromClause().addRoot(mutatingTableGroup);
        targetEntityDescriptor.getIdentifierMapping().forEachSelectable((position, selection) -> {
            TableReference tableReference = mutatingTableGroup.resolveTableReference(mutatingTableGroup.getNavigablePath(), selection.getContainingTableExpression());
            Expression expression = sqmConverter.getSqlExpressionResolver().resolveSqlExpression(tableReference, selection);
            idSelectionQuery.getSelectClause().addSqlSelection(new SqlSelectionImpl(position, position + 1, expression));
        });
        idSelectionQuery.applyPredicate(restriction);
        return idSelectionQuery;
    }

    public static List<Object> selectMatchingIds(SqmDeleteOrUpdateStatement<?> sqmMutationStatement, DomainParameterXref domainParameterXref, DomainQueryExecutionContext executionContext) {
        SessionFactoryImplementor factory = executionContext.getSession().getFactory();
        EntityMappingType entityDescriptor = factory.getRuntimeMetamodels().getEntityMappingType(((SqmRoot)sqmMutationStatement.getTarget()).getModel().getHibernateEntityName());
        final MultiTableSqmMutationConverter sqmConverter = new MultiTableSqmMutationConverter(entityDescriptor, (SqmStatement<?>)sqmMutationStatement, (SqmRoot<?>)sqmMutationStatement.getTarget(), domainParameterXref, executionContext.getQueryOptions(), executionContext.getSession().getLoadQueryInfluencers(), executionContext.getQueryParameterBindings(), factory);
        Map parameterResolutions = domainParameterXref.getSqmParameterCount() == 0 ? Collections.emptyMap() : new IdentityHashMap();
        Predicate restriction = sqmConverter.visitWhereClause(sqmMutationStatement.getWhereClause(), columnReference -> {}, (sqmParam, mappingType, jdbcParameters) -> parameterResolutions.put(sqmParam, jdbcParameters));
        SelectStatement matchingIdSelection = MatchingIdSelectionHelper.generateMatchingIdSelectStatement(entityDescriptor, sqmMutationStatement, true, restriction, sqmConverter, executionContext, factory);
        if (sqmMutationStatement instanceof SqmDeleteStatement) {
            sqmConverter.getProcessingStateStack().push(new SqlAstQueryPartProcessingStateImpl(matchingIdSelection.getQuerySpec(), sqmConverter.getCurrentProcessingState(), sqmConverter.getSqlAstCreationState(), sqmConverter.getCurrentClauseStack()::getCurrent, true));
            entityDescriptor.visitSubTypeAttributeMappings(attribute -> {
                PluralAttributeMapping pluralAttribute;
                if (attribute instanceof PluralAttributeMapping && (pluralAttribute = (PluralAttributeMapping)attribute).getSeparateCollectionTable() != null) {
                    boolean useFkTarget;
                    boolean bl = useFkTarget = !(pluralAttribute.getKeyDescriptor().getTargetPart() instanceof EntityIdentifierMapping);
                    if (useFkTarget) {
                        TableGroup mutatingTableGroup = sqmConverter.getMutatingTableGroup();
                        pluralAttribute.getKeyDescriptor().getTargetPart().applySqlSelections(mutatingTableGroup.getNavigablePath(), mutatingTableGroup, sqmConverter, (selection, jdbcMapping) -> matchingIdSelection.getDomainResultDescriptors().add(new BasicResult(selection.getValuesArrayPosition(), null, (JdbcMapping)jdbcMapping)));
                    }
                }
            });
            sqmConverter.getProcessingStateStack().pop();
        }
        JdbcServices jdbcServices = factory.getJdbcServices();
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        SqlAstTranslator<JdbcOperationQuerySelect> sqlAstSelectTranslator = jdbcEnvironment.getSqlAstTranslatorFactory().buildSelectTranslator(factory, matchingIdSelection);
        JdbcParameterBindings jdbcParameterBindings = SqmUtil.createJdbcParameterBindings(executionContext.getQueryParameterBindings(), domainParameterXref, SqmUtil.generateJdbcParamsXref(domainParameterXref, sqmConverter), factory.getRuntimeMetamodels().getMappingMetamodel(), navigablePath -> sqmConverter.getMutatingTableGroup(), new SqmParameterMappingModelResolutionAccess(){

            @Override
            public <T> MappingModelExpressible<T> getResolvedMappingModelType(SqmParameter<T> parameter) {
                return sqmConverter.getSqmParameterMappingModelExpressibleResolutions().get(parameter);
            }
        }, executionContext.getSession());
        LockOptions lockOptions = executionContext.getQueryOptions().getLockOptions().makeCopy();
        LockMode lockMode = lockOptions.getLockMode();
        lockOptions.setLockMode(LockMode.WRITE);
        if (!jdbcEnvironment.getDialect().supportsOuterJoinForUpdate()) {
            matchingIdSelection.getQuerySpec().getFromClause().visitTableJoins(tableJoin -> {
                if (tableJoin.getJoinType() != SqlAstJoinType.INNER) {
                    lockOptions.setLockMode(lockMode);
                }
            });
        }
        JdbcOperationQuerySelect idSelectJdbcOperation = sqlAstSelectTranslator.translate(jdbcParameterBindings, executionContext.getQueryOptions());
        lockOptions.setLockMode(lockMode);
        RowTransformer<Object> rowTransformer = matchingIdSelection.getDomainResultDescriptors().size() == 1 ? row -> row[0] : row -> row;
        return jdbcServices.getJdbcSelectExecutor().list(idSelectJdbcOperation, jdbcParameterBindings, SqmJdbcExecutionContextAdapter.omittingLockingAndPaging(executionContext), rowTransformer, ListResultsConsumer.UniqueSemantic.FILTER);
    }
}

