/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal.temptable;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import org.hibernate.dialect.temptable.TemporaryTable;
import org.hibernate.dialect.temptable.TemporaryTableColumn;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.generator.BeforeExecutionGenerator;
import org.hibernate.generator.EventType;
import org.hibernate.generator.Generator;
import org.hibernate.generator.OnExecutionGenerator;
import org.hibernate.id.BulkInsertionCapableIdentifierGenerator;
import org.hibernate.id.OptimizableGenerator;
import org.hibernate.id.PostInsertIdentityPersister;
import org.hibernate.id.enhanced.Optimizer;
import org.hibernate.id.insert.Binder;
import org.hibernate.id.insert.InsertGeneratedIdentifierDelegate;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.mapping.BasicEntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.metamodel.mapping.ModelPartContainer;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.SemanticException;
import org.hibernate.query.results.TableGroupImpl;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.query.sqm.SortOrder;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.mutation.internal.MultiTableSqmMutationConverter;
import org.hibernate.query.sqm.mutation.internal.temptable.AfterUseAction;
import org.hibernate.query.sqm.mutation.internal.temptable.ExecuteWithTemporaryTableHelper;
import org.hibernate.query.sqm.mutation.internal.temptable.TableBasedInsertHandler;
import org.hibernate.query.sqm.spi.SqmParameterMappingModelResolutionAccess;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.insert.SqmInsertStatement;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.UnionTableReference;
import org.hibernate.sql.ast.tree.insert.InsertSelectStatement;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.ast.tree.select.SortSpecification;
import org.hibernate.sql.ast.tree.update.Assignable;
import org.hibernate.sql.ast.tree.update.Assignment;
import org.hibernate.sql.ast.tree.update.UpdateStatement;
import org.hibernate.sql.exec.internal.JdbcParameterBindingImpl;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.internal.JdbcParameterImpl;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcOperationQueryInsert;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.exec.spi.JdbcOperationQueryUpdate;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.results.graph.basic.BasicFetch;
import org.hibernate.sql.results.internal.SqlSelectionImpl;
import org.hibernate.sql.results.spi.ListResultsConsumer;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.WrapperOptions;

public class InsertExecutionDelegate
implements TableBasedInsertHandler.ExecutionDelegate {
    private final SqmInsertStatement<?> sqmInsert;
    private final MultiTableSqmMutationConverter sqmConverter;
    private final TemporaryTable entityTable;
    private final AfterUseAction afterUseAction;
    private final Function<SharedSessionContractImplementor, String> sessionUidAccess;
    private final DomainParameterXref domainParameterXref;
    private final TableGroup updatingTableGroup;
    private final InsertSelectStatement insertStatement;
    private final EntityMappingType entityDescriptor;
    private final JdbcParameterBindings jdbcParameterBindings;
    private final JdbcParameter sessionUidParameter;
    private final Map<TableReference, List<Assignment>> assignmentsByTable;
    private final Map<SqmParameter<?>, MappingModelExpressible<?>> paramTypeResolutions;
    private final SessionFactoryImplementor sessionFactory;

    public InsertExecutionDelegate(SqmInsertStatement<?> sqmInsert, MultiTableSqmMutationConverter sqmConverter, TemporaryTable entityTable, AfterUseAction afterUseAction, Function<SharedSessionContractImplementor, String> sessionUidAccess, DomainParameterXref domainParameterXref, TableGroup insertingTableGroup, Map<String, TableReference> tableReferenceByAlias, List<Assignment> assignments, InsertSelectStatement insertStatement, Map<SqmParameter<?>, List<List<JdbcParameter>>> parameterResolutions, JdbcParameter sessionUidParameter, final Map<SqmParameter<?>, MappingModelExpressible<?>> paramTypeResolutions, DomainQueryExecutionContext executionContext) {
        this.sqmInsert = sqmInsert;
        this.sqmConverter = sqmConverter;
        this.entityTable = entityTable;
        this.afterUseAction = afterUseAction;
        this.sessionUidAccess = sessionUidAccess;
        this.domainParameterXref = domainParameterXref;
        this.updatingTableGroup = insertingTableGroup;
        this.sessionUidParameter = sessionUidParameter;
        this.paramTypeResolutions = paramTypeResolutions;
        this.insertStatement = insertStatement;
        this.sessionFactory = executionContext.getSession().getFactory();
        ModelPartContainer updatingModelPart = insertingTableGroup.getModelPart();
        assert (updatingModelPart instanceof EntityMappingType);
        this.entityDescriptor = (EntityMappingType)updatingModelPart;
        this.assignmentsByTable = CollectionHelper.mapOfSize(insertingTableGroup.getTableReferenceJoins().size() + 1);
        this.jdbcParameterBindings = SqmUtil.createJdbcParameterBindings(executionContext.getQueryParameterBindings(), domainParameterXref, SqmUtil.generateJdbcParamsXref(domainParameterXref, () -> parameterResolutions), this.sessionFactory.getRuntimeMetamodels().getMappingMetamodel(), navigablePath -> insertingTableGroup, new SqmParameterMappingModelResolutionAccess(){

            @Override
            public <T> MappingModelExpressible<T> getResolvedMappingModelType(SqmParameter<T> parameter) {
                return (MappingModelExpressible)paramTypeResolutions.get(parameter);
            }
        }, executionContext.getSession());
        for (int i = 0; i < assignments.size(); ++i) {
            Assignment assignment = assignments.get(i);
            Assignable assignable = assignment.getAssignable();
            List<ColumnReference> assignmentColumnRefs = assignable.getColumnReferences();
            TableReference assignmentTableReference = null;
            for (int c = 0; c < assignmentColumnRefs.size(); ++c) {
                ColumnReference columnReference = assignmentColumnRefs.get(c);
                TableReference tableReference = this.resolveTableReference(columnReference, insertingTableGroup, tableReferenceByAlias);
                if (assignmentTableReference != null && assignmentTableReference != tableReference) {
                    throw new SemanticException("Assignment referred to columns from multiple tables: " + i);
                }
                assignmentTableReference = tableReference;
            }
            this.assignmentsByTable.computeIfAbsent(assignmentTableReference, k -> new ArrayList()).add(assignment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int execute(ExecutionContext executionContext) {
        ExecuteWithTemporaryTableHelper.performBeforeTemporaryTableUseActions(this.entityTable, executionContext);
        try {
            int rows;
            if (this.sessionUidParameter != null) {
                this.jdbcParameterBindings.addBinding(this.sessionUidParameter, new JdbcParameterBindingImpl(this.entityTable.getSessionUidColumn().getJdbcMapping(), UUID.fromString(this.sessionUidAccess.apply(executionContext.getSession()))));
            }
            if ((rows = ExecuteWithTemporaryTableHelper.saveIntoTemporaryTable(this.insertStatement, this.jdbcParameterBindings, executionContext)) != 0) {
                AbstractEntityPersister persister = (AbstractEntityPersister)this.entityDescriptor.getEntityPersister();
                int tableSpan = persister.getTableSpan();
                this.insertRootTable(persister.getTableName(0), rows, persister.getKeyColumns(0), executionContext);
                if (persister.hasDuplicateTables()) {
                    Object[] insertedTables = new String[tableSpan];
                    insertedTables[0] = persister.getTableName(0);
                    for (int i = 1; i < tableSpan; ++i) {
                        String tableName;
                        if (persister.isInverseTable(i)) continue;
                        insertedTables[i] = tableName = persister.getTableName(i);
                        if (ArrayHelper.indexOf(insertedTables, i, tableName) != -1) continue;
                        this.insertTable(tableName, persister.getKeyColumns(i), persister.isNullableTable(i), executionContext);
                    }
                } else {
                    for (int i = 1; i < tableSpan; ++i) {
                        this.insertTable(persister.getTableName(i), persister.getKeyColumns(i), persister.isNullableTable(i), executionContext);
                    }
                }
            }
            int n = rows;
            return n;
        }
        finally {
            ExecuteWithTemporaryTableHelper.performAfterTemporaryTableUseActions(this.entityTable, this.sessionUidAccess, this.afterUseAction, executionContext);
        }
    }

    private TableReference resolveTableReference(ColumnReference columnReference, TableGroup updatingTableGroup, Map<String, TableReference> tableReferenceByAlias) {
        if (columnReference.getQualifier() == null) {
            return null;
        }
        TableReference tableReferenceByQualifier = tableReferenceByAlias.get(columnReference.getQualifier());
        if (tableReferenceByQualifier != null) {
            return tableReferenceByQualifier;
        }
        throw new SemanticException("Assignment referred to column of a joined association: " + columnReference);
    }

    private NamedTableReference resolveUnionTableReference(TableReference tableReference, String tableExpression) {
        if (tableReference instanceof UnionTableReference) {
            return new NamedTableReference(tableExpression, tableReference.getIdentificationVariable(), tableReference.isOptional());
        }
        return (NamedTableReference)tableReference;
    }

    /*
     * WARNING - void declaration
     */
    private void insertRootTable(String tableExpression, int rows, String[] keyColumns, ExecutionContext executionContext) {
        LinkedHashMap entityTableToRootIdentity;
        BasicEntityIdentifierMapping identifierMapping;
        TableReference updatingTableReference = this.updatingTableGroup.getTableReference(this.updatingTableGroup.getNavigablePath(), tableExpression, true, true);
        EntityPersister entityPersister = this.entityDescriptor.getEntityPersister();
        Generator generator = entityPersister.getGenerator();
        List<Assignment> assignments = this.assignmentsByTable.get(updatingTableReference);
        if (!(assignments != null && !assignments.isEmpty() || generator.generatedOnExecution() || generator instanceof BulkInsertionCapableIdentifierGenerator && !((BulkInsertionCapableIdentifierGenerator)generator).supportsBulkInsertionIdentifierGeneration())) {
            throw new IllegalStateException("There must be at least a single root table assignment");
        }
        NamedTableReference dmlTableReference = this.resolveUnionTableReference(updatingTableReference, tableExpression);
        QuerySpec querySpec = new QuerySpec(true);
        NamedTableReference temporaryTableReference = new NamedTableReference(this.insertStatement.getTargetTable().getTableExpression(), updatingTableReference.getIdentificationVariable(), false);
        TableGroupImpl temporaryTableGroup = new TableGroupImpl(this.updatingTableGroup.getNavigablePath(), null, temporaryTableReference, this.entityDescriptor);
        querySpec.getFromClause().addRoot(temporaryTableGroup);
        InsertSelectStatement insertStatement = new InsertSelectStatement(dmlTableReference);
        insertStatement.setSourceSelectStatement(querySpec);
        if (assignments != null) {
            for (Assignment assignment : assignments) {
                Assignable assignable = assignment.getAssignable();
                insertStatement.addTargetColumnReferences(assignable.getColumnReferences());
                for (ColumnReference columnReference : assignable.getColumnReferences()) {
                    querySpec.getSelectClause().addSqlSelection(new SqlSelectionImpl(1, 0, new ColumnReference(updatingTableReference.getIdentificationVariable(), columnReference.getColumnExpression(), false, null, null, columnReference.getJdbcMapping())));
                }
            }
        }
        JdbcServices jdbcServices = this.sessionFactory.getJdbcServices();
        final SharedSessionContractImplementor session = executionContext.getSession();
        if (generator.generatedOnExecution()) {
            identifierMapping = (BasicEntityIdentifierMapping)this.entityDescriptor.getIdentifierMapping();
            QuerySpec idSelectQuerySpec = new QuerySpec(true);
            idSelectQuerySpec.getFromClause().addRoot(temporaryTableGroup);
            ColumnReference columnReference = new ColumnReference((String)null, "HTE_IDENTITY", false, null, null, identifierMapping.getJdbcMapping());
            idSelectQuerySpec.getSelectClause().addSqlSelection(new SqlSelectionImpl(1, 0, columnReference));
            idSelectQuerySpec.addSortSpecification(new SortSpecification(columnReference, SortOrder.ASCENDING));
            SelectStatement selectStatement = new SelectStatement(idSelectQuerySpec, Collections.singletonList(new BasicFetch(0, null, null, identifierMapping, FetchTiming.IMMEDIATE, null)));
            JdbcOperationQuerySelect jdbcSelect = jdbcServices.getJdbcEnvironment().getSqlAstTranslatorFactory().buildSelectTranslator(this.sessionFactory, selectStatement).translate(null, executionContext.getQueryOptions());
            List list = jdbcServices.getJdbcSelectExecutor().list(jdbcSelect, JdbcParameterBindings.NO_BINDINGS, executionContext, null, ListResultsConsumer.UniqueSemantic.NONE);
            entityTableToRootIdentity = new LinkedHashMap(list.size());
            for (Object r : list) {
                entityTableToRootIdentity.put(r, null);
            }
            querySpec.applyPredicate(new ComparisonPredicate(columnReference, ComparisonOperator.EQUAL, new JdbcParameterImpl(identifierMapping.getJdbcMapping())));
        } else {
            entityTableToRootIdentity = null;
            if (this.needsIdentifierGeneration(generator) && insertStatement.getTargetColumns().stream().noneMatch(c -> keyColumns[0].equals(c.getColumnExpression()))) {
                void var24_27;
                Object sessionUidColumn;
                TemporaryTableColumn rowNumberColumn;
                identifierMapping = (BasicEntityIdentifierMapping)this.entityDescriptor.getIdentifierMapping();
                JdbcParameterImpl rowNumber = new JdbcParameterImpl(identifierMapping.getJdbcMapping());
                JdbcParameterImpl rootIdentity = new JdbcParameterImpl(identifierMapping.getJdbcMapping());
                ArrayList<Assignment> temporaryTableAssignments = new ArrayList<Assignment>(1);
                ColumnReference idColumnReference = new ColumnReference((String)null, (SelectableMapping)identifierMapping);
                temporaryTableAssignments.add(new Assignment(idColumnReference, rootIdentity));
                if (this.entityTable.getSessionUidColumn() == null) {
                    rowNumberColumn = this.entityTable.getColumns().get(this.entityTable.getColumns().size() - 1);
                    sessionUidColumn = null;
                    Object var24_25 = null;
                } else {
                    rowNumberColumn = this.entityTable.getColumns().get(this.entityTable.getColumns().size() - 2);
                    sessionUidColumn = this.entityTable.getSessionUidColumn();
                    ComparisonPredicate comparisonPredicate = new ComparisonPredicate(new ColumnReference((String)null, ((TemporaryTableColumn)sessionUidColumn).getColumnName(), false, null, null, ((TemporaryTableColumn)sessionUidColumn).getJdbcMapping()), ComparisonOperator.EQUAL, this.sessionUidParameter);
                }
                UpdateStatement updateStatement = new UpdateStatement(temporaryTableReference, temporaryTableAssignments, Predicate.combinePredicates(new ComparisonPredicate(new ColumnReference((String)null, rowNumberColumn.getColumnName(), false, null, null, rowNumberColumn.getJdbcMapping()), ComparisonOperator.EQUAL, rowNumber), (Predicate)var24_27));
                JdbcOperationQueryUpdate jdbcUpdate = jdbcServices.getJdbcEnvironment().getSqlAstTranslatorFactory().buildUpdateTranslator(this.sessionFactory, updateStatement).translate(null, executionContext.getQueryOptions());
                JdbcParameterBindingsImpl updateBindings = new JdbcParameterBindingsImpl(2);
                if (sessionUidColumn != null) {
                    updateBindings.addBinding(this.sessionUidParameter, new JdbcParameterBindingImpl(((TemporaryTableColumn)sessionUidColumn).getJdbcMapping(), UUID.fromString(this.sessionUidAccess.apply(session))));
                }
                BeforeExecutionGenerator beforeExecutionGenerator = (BeforeExecutionGenerator)generator;
                for (int i = 0; i < rows; ++i) {
                    updateBindings.addBinding(rowNumber, new JdbcParameterBindingImpl(rowNumberColumn.getJdbcMapping(), i + 1));
                    updateBindings.addBinding(rootIdentity, new JdbcParameterBindingImpl(identifierMapping.getJdbcMapping(), beforeExecutionGenerator.generate(session, null, null, EventType.INSERT)));
                    jdbcServices.getJdbcMutationExecutor().execute(jdbcUpdate, updateBindings, sql -> session.getJdbcCoordinator().getStatementPreparer().prepareStatement((String)sql), (integer, preparedStatement) -> {}, executionContext);
                }
                insertStatement.addTargetColumnReferences(new ColumnReference((String)null, keyColumns[0], false, null, null, identifierMapping.getJdbcMapping()));
                querySpec.getSelectClause().addSqlSelection(new SqlSelectionImpl(1, 0, new ColumnReference(updatingTableReference.getIdentificationVariable(), idColumnReference.getColumnExpression(), false, null, null, idColumnReference.getJdbcMapping())));
            }
        }
        JdbcOperationQueryInsert jdbcInsert = jdbcServices.getJdbcEnvironment().getSqlAstTranslatorFactory().buildInsertTranslator(this.sessionFactory, insertStatement).translate(null, executionContext.getQueryOptions());
        if (generator.generatedOnExecution()) {
            OnExecutionGenerator databaseGenerator = (OnExecutionGenerator)generator;
            InsertGeneratedIdentifierDelegate identifierDelegate = databaseGenerator.getGeneratedIdentifierDelegate((PostInsertIdentityPersister)entityPersister);
            String finalSql = identifierDelegate.prepareIdentifierGeneratingInsert(jdbcInsert.getSqlString());
            BasicEntityIdentifierMapping identifierMapping2 = (BasicEntityIdentifierMapping)this.entityDescriptor.getIdentifierMapping();
            final ValueBinder jdbcValueBinder = identifierMapping2.getJdbcMapping().getJdbcValueBinder();
            for (final Map.Entry entry : entityTableToRootIdentity.entrySet()) {
                Object rootIdentity = identifierDelegate.performInsert(finalSql, session, new Binder(){

                    @Override
                    public void bindValues(PreparedStatement ps) throws SQLException {
                        jdbcValueBinder.bind(ps, entry.getKey(), 1, (WrapperOptions)session);
                    }

                    @Override
                    public Object getEntity() {
                        return null;
                    }
                });
                entry.setValue(rootIdentity);
            }
            JdbcParameterImpl entityIdentity = new JdbcParameterImpl(identifierMapping2.getJdbcMapping());
            JdbcParameterImpl jdbcParameterImpl = new JdbcParameterImpl(identifierMapping2.getJdbcMapping());
            ArrayList<Assignment> temporaryTableAssignments = new ArrayList<Assignment>(1);
            temporaryTableAssignments.add(new Assignment(new ColumnReference((String)null, (SelectableMapping)identifierMapping2), jdbcParameterImpl));
            UpdateStatement updateStatement = new UpdateStatement(temporaryTableReference, temporaryTableAssignments, new ComparisonPredicate(new ColumnReference((String)null, "HTE_IDENTITY", false, null, null, identifierMapping2.getJdbcMapping()), ComparisonOperator.EQUAL, entityIdentity));
            JdbcOperationQueryUpdate jdbcUpdate = jdbcServices.getJdbcEnvironment().getSqlAstTranslatorFactory().buildUpdateTranslator(this.sessionFactory, updateStatement).translate(null, executionContext.getQueryOptions());
            JdbcParameterBindingsImpl updateBindings = new JdbcParameterBindingsImpl(2);
            for (Map.Entry entry : entityTableToRootIdentity.entrySet()) {
                JdbcMapping jdbcMapping = identifierMapping2.getJdbcMapping();
                updateBindings.addBinding(entityIdentity, new JdbcParameterBindingImpl(jdbcMapping, entry.getKey()));
                updateBindings.addBinding(jdbcParameterImpl, new JdbcParameterBindingImpl(jdbcMapping, entry.getValue()));
                jdbcServices.getJdbcMutationExecutor().execute(jdbcUpdate, updateBindings, sql -> session.getJdbcCoordinator().getStatementPreparer().prepareStatement((String)sql), (integer, preparedStatement) -> {}, executionContext);
            }
        } else {
            jdbcServices.getJdbcMutationExecutor().execute(jdbcInsert, JdbcParameterBindings.NO_BINDINGS, sql -> session.getJdbcCoordinator().getStatementPreparer().prepareStatement((String)sql), (integer, preparedStatement) -> {}, executionContext);
        }
    }

    private boolean needsIdentifierGeneration(Generator identifierGenerator) {
        if (identifierGenerator instanceof OptimizableGenerator) {
            Optimizer optimizer = ((OptimizableGenerator)identifierGenerator).getOptimizer();
            return optimizer != null && optimizer.getIncrementSize() > 1 || identifierGenerator instanceof BulkInsertionCapableIdentifierGenerator && !((BulkInsertionCapableIdentifierGenerator)identifierGenerator).supportsBulkInsertionIdentifierGeneration();
        }
        return false;
    }

    private void insertTable(String tableExpression, String[] keyColumns, boolean nullableTable, ExecutionContext executionContext) {
        Optimizer optimizer;
        TableReference updatingTableReference = this.updatingTableGroup.getTableReference(this.updatingTableGroup.getNavigablePath(), tableExpression, true, true);
        List<Assignment> assignments = this.assignmentsByTable.get(updatingTableReference);
        if (nullableTable && (assignments == null || assignments.isEmpty())) {
            return;
        }
        NamedTableReference dmlTargetTableReference = this.resolveUnionTableReference(updatingTableReference, tableExpression);
        QuerySpec querySpec = new QuerySpec(true);
        TableGroupImpl temporaryTableGroup = new TableGroupImpl(this.updatingTableGroup.getNavigablePath(), null, new NamedTableReference(this.insertStatement.getTargetTable().getTableExpression(), updatingTableReference.getIdentificationVariable(), false), this.entityDescriptor);
        querySpec.getFromClause().addRoot(temporaryTableGroup);
        InsertSelectStatement insertStatement = new InsertSelectStatement(dmlTargetTableReference);
        insertStatement.setSourceSelectStatement(querySpec);
        if (assignments != null && !assignments.isEmpty()) {
            for (Assignment assignment : assignments) {
                insertStatement.addTargetColumnReferences(assignment.getAssignable().getColumnReferences());
                for (ColumnReference columnReference : assignment.getAssignable().getColumnReferences()) {
                    querySpec.getSelectClause().addSqlSelection(new SqlSelectionImpl(1, 0, new ColumnReference(updatingTableReference.getIdentificationVariable(), columnReference.getColumnExpression(), false, null, null, columnReference.getJdbcMapping())));
                }
            }
        }
        String targetKeyColumnName = keyColumns[0];
        AbstractEntityPersister entityPersister = (AbstractEntityPersister)this.entityDescriptor.getEntityPersister();
        Generator identifierGenerator = entityPersister.getGenerator();
        boolean needsKeyInsert = identifierGenerator.generatedOnExecution() ? true : (identifierGenerator instanceof OptimizableGenerator ? (optimizer = ((OptimizableGenerator)identifierGenerator).getOptimizer()) != null && optimizer.getIncrementSize() > 1 : true);
        if (needsKeyInsert && insertStatement.getTargetColumns().stream().noneMatch(c -> targetKeyColumnName.equals(c.getColumnExpression()))) {
            BasicEntityIdentifierMapping identifierMapping = (BasicEntityIdentifierMapping)this.entityDescriptor.getIdentifierMapping();
            insertStatement.addTargetColumnReferences(new ColumnReference(dmlTargetTableReference.getIdentificationVariable(), targetKeyColumnName, false, null, null, identifierMapping.getJdbcMapping()));
            querySpec.getSelectClause().addSqlSelection(new SqlSelectionImpl(1, 0, new ColumnReference(updatingTableReference.getIdentificationVariable(), (SelectableMapping)identifierMapping)));
        }
        JdbcServices jdbcServices = this.sessionFactory.getJdbcServices();
        JdbcOperationQueryInsert jdbcInsert = jdbcServices.getJdbcEnvironment().getSqlAstTranslatorFactory().buildInsertTranslator(this.sessionFactory, insertStatement).translate(null, executionContext.getQueryOptions());
        jdbcServices.getJdbcMutationExecutor().execute(jdbcInsert, JdbcParameterBindings.NO_BINDINGS, sql -> executionContext.getSession().getJdbcCoordinator().getStatementPreparer().prepareStatement((String)sql), (integer, preparedStatement) -> {}, executionContext);
    }
}

