/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.sql.internal;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.spi.MappingMetamodelImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.SemanticException;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.StrictJpaComplianceViolation;
import org.hibernate.query.sqm.sql.internal.AbstractSqmPathInterpretation;
import org.hibernate.query.sqm.sql.internal.DomainResultProducer;
import org.hibernate.query.sqm.tree.domain.SqmBasicValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmTreatedPath;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.SqlSelectionExpression;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.update.Assignable;

public class BasicValuedPathInterpretation<T>
extends AbstractSqmPathInterpretation<T>
implements Assignable,
DomainResultProducer<T> {
    private final ColumnReference columnReference;

    public static <T> BasicValuedPathInterpretation<T> from(SqmBasicValuedSimplePath<T> sqmPath, SqlAstCreationState sqlAstCreationState, SemanticQueryWalker sqmWalker, boolean jpaQueryComplianceEnabled) {
        ColumnReference columnReference;
        BasicValuedModelPart mapping;
        FromClauseAccess fromClauseAccess = sqlAstCreationState.getFromClauseAccess();
        TableGroup tableGroup = fromClauseAccess.getTableGroup(sqmPath.getNavigablePath().getParent());
        EntityPersister treatTarget = null;
        if (jpaQueryComplianceEnabled) {
            MappingMetamodelImplementor mappingMetamodel;
            if (sqmPath.getLhs() instanceof SqmTreatedPath) {
                EntityDomainType treatTargetDomainType = ((SqmTreatedPath)sqmPath.getLhs()).getTreatTarget();
                mappingMetamodel = sqlAstCreationState.getCreationContext().getSessionFactory().getRuntimeMetamodels().getMappingMetamodel();
                treatTarget = mappingMetamodel.findEntityDescriptor(treatTargetDomainType.getHibernateEntityName());
            } else if (sqmPath.getLhs().getNodeType() instanceof EntityDomainType) {
                EntityDomainType entityDomainType = (EntityDomainType)sqmPath.getLhs().getNodeType();
                mappingMetamodel = sqlAstCreationState.getCreationContext().getSessionFactory().getRuntimeMetamodels().getMappingMetamodel();
                treatTarget = mappingMetamodel.findEntityDescriptor(entityDomainType.getHibernateEntityName());
            }
        }
        if ((mapping = (BasicValuedModelPart)tableGroup.getModelPart().findSubPart(sqmPath.getReferencedPathSource().getPathName(), treatTarget)) == null) {
            ModelPart subPart;
            if (jpaQueryComplianceEnabled && (subPart = tableGroup.getModelPart().findSubPart(sqmPath.getReferencedPathSource().getPathName(), null)) != null) {
                throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.IMPLICIT_TREAT);
            }
            throw new SemanticException("`" + sqmPath.getNavigablePath() + "` did not reference a known model part");
        }
        TableReference tableReference = tableGroup.resolveTableReference(sqmPath.getNavigablePath(), mapping.getContainingTableExpression());
        Expression expression = sqlAstCreationState.getSqlExpressionResolver().resolveSqlExpression(tableReference, mapping);
        if (expression instanceof ColumnReference) {
            columnReference = (ColumnReference)expression;
        } else if (expression instanceof SqlSelectionExpression) {
            Expression selectedExpression = ((SqlSelectionExpression)expression).getSelection().getExpression();
            assert (selectedExpression instanceof ColumnReference);
            columnReference = (ColumnReference)selectedExpression;
        } else {
            throw new UnsupportedOperationException("Unsupported basic-valued path expression : " + expression);
        }
        return new BasicValuedPathInterpretation<T>(columnReference, sqmPath.getNavigablePath(), mapping, tableGroup);
    }

    public BasicValuedPathInterpretation(ColumnReference columnReference, NavigablePath navigablePath, BasicValuedModelPart mapping, TableGroup tableGroup) {
        super(navigablePath, mapping, tableGroup);
        assert (columnReference != null);
        this.columnReference = columnReference;
    }

    @Override
    public Expression getSqlExpression() {
        return this.columnReference;
    }

    @Override
    public void accept(SqlAstWalker sqlTreeWalker) {
        this.columnReference.accept(sqlTreeWalker);
    }

    public String toString() {
        return "BasicValuedPathInterpretation(" + this.getNavigablePath() + ")";
    }

    @Override
    public void visitColumnReferences(Consumer<ColumnReference> columnReferenceConsumer) {
        columnReferenceConsumer.accept(this.columnReference);
    }

    @Override
    public List<ColumnReference> getColumnReferences() {
        return Collections.singletonList(this.columnReference);
    }
}

