/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Predicate;
import org.hibernate.metamodel.model.domain.PersistentAttribute;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.criteria.JpaPredicate;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmJoinable;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.spi.SqmCreationHelper;
import org.hibernate.query.sqm.tree.SqmJoinType;
import org.hibernate.query.sqm.tree.domain.AbstractSqmQualifiedJoin;
import org.hibernate.query.sqm.tree.from.SqmAttributeJoin;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.spi.NavigablePath;
import org.hibernate.type.descriptor.java.JavaType;
import org.jboss.logging.Logger;

public abstract class AbstractSqmAttributeJoin<O, T>
extends AbstractSqmQualifiedJoin<O, T>
implements SqmAttributeJoin<O, T> {
    private static final Logger log = Logger.getLogger(AbstractSqmAttributeJoin.class);
    private final boolean fetched;

    public AbstractSqmAttributeJoin(SqmFrom<?, O> lhs, SqmJoinable joinedNavigable, String alias, SqmJoinType joinType, boolean fetched, NodeBuilder nodeBuilder) {
        this(lhs, SqmCreationHelper.buildSubNavigablePath(lhs, joinedNavigable.getName(), alias), joinedNavigable, alias == "{implicit}" ? null : alias, joinType, fetched, nodeBuilder);
    }

    protected AbstractSqmAttributeJoin(SqmFrom<?, O> lhs, NavigablePath navigablePath, SqmJoinable joinedNavigable, String alias, SqmJoinType joinType, boolean fetched, NodeBuilder nodeBuilder) {
        super(navigablePath, (SqmPathSource)((Object)joinedNavigable), lhs, alias, joinType, nodeBuilder);
        this.fetched = fetched;
    }

    @Override
    public SqmFrom<?, O> getLhs() {
        return (SqmFrom)super.getLhs();
    }

    @Override
    public JavaType<T> getNodeJavaType() {
        return this.getJavaTypeDescriptor();
    }

    @Override
    public boolean isFetched() {
        return this.fetched;
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitQualifiedAttributeJoin(this);
    }

    @Override
    public PersistentAttribute<? super O, ?> getAttribute() {
        return (PersistentAttribute)((Object)this.getReferencedPathSource());
    }

    @Override
    public SqmAttributeJoin<O, T> on(JpaExpression<Boolean> restriction) {
        super.on(restriction);
        return this;
    }

    @Override
    public SqmAttributeJoin<O, T> on(Expression<Boolean> restriction) {
        super.on(restriction);
        return this;
    }

    @Override
    public SqmAttributeJoin<O, T> on(JpaPredicate ... restrictions) {
        super.on(restrictions);
        return this;
    }

    @Override
    public SqmAttributeJoin<O, T> on(Predicate ... restrictions) {
        super.on(restrictions);
        return this;
    }

    public SqmFrom<?, O> getParent() {
        return this.getLhs();
    }

    public JoinType getJoinType() {
        return this.getSqmJoinType().getCorrespondingJpaJoinType();
    }
}

