/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import org.hibernate.query.criteria.JpaSelection;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.domain.SqmCorrelation;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmPathWrapper;
import org.hibernate.query.sqm.tree.from.SqmRoot;

public class SqmCorrelatedRoot<T>
extends SqmRoot<T>
implements SqmPathWrapper<T, T>,
SqmCorrelation<T, T> {
    private final SqmRoot<T> correlationParent;

    public SqmCorrelatedRoot(SqmRoot<T> correlationParent) {
        super(correlationParent.getNavigablePath(), correlationParent.getModel(), correlationParent.getExplicitAlias(), (NodeBuilder)correlationParent.nodeBuilder());
        this.correlationParent = correlationParent;
    }

    @Override
    public SqmCorrelatedRoot<T> copy(SqmCopyContext context) {
        SqmCorrelatedRoot existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmCorrelatedRoot<T> path = context.registerCopy(this, new SqmCorrelatedRoot<T>(this.correlationParent.copy(context)));
        this.copyTo(path, context);
        return path;
    }

    @Override
    public SqmRoot<T> getCorrelationParent() {
        return this.correlationParent;
    }

    @Override
    public SqmPath<T> getWrappedPath() {
        return this.getCorrelationParent();
    }

    @Override
    public String getExplicitAlias() {
        return this.correlationParent.getExplicitAlias();
    }

    @Override
    public void setExplicitAlias(String explicitAlias) {
        throw new UnsupportedOperationException("Can't set alias on a correlated root");
    }

    @Override
    public JpaSelection<T> alias(String name) {
        this.setAlias(name);
        return this;
    }

    @Override
    public boolean isCorrelated() {
        return true;
    }

    @Override
    public SqmRoot<T> getCorrelatedRoot() {
        return this;
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitCorrelation(this);
    }
}

