/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.resource.beans.internal;

import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.config.spi.StandardConverters;
import org.hibernate.resource.beans.container.internal.ContainerManagedLifecycleStrategy;
import org.hibernate.resource.beans.container.internal.JpaCompliantLifecycleStrategy;
import org.hibernate.resource.beans.container.spi.BeanLifecycleStrategy;
import org.hibernate.resource.beans.container.spi.ExtendedBeanManager;
import org.hibernate.service.ServiceRegistry;

public final class Helper {
    private Helper() {
    }

    public static String determineBeanCacheKey(Class<?> beanType) {
        return beanType.getName();
    }

    public static String determineBeanCacheKey(String name, Class<?> beanType) {
        return beanType.getName() + ":" + name;
    }

    public static boolean shouldIgnoreBeanContainer(ServiceRegistry serviceRegistry) {
        ConfigurationService configService = serviceRegistry.getService(ConfigurationService.class);
        Object beanManagerRef = configService.getSettings().get("jakarta.persistence.bean.manager");
        if (beanManagerRef instanceof ExtendedBeanManager) {
            return true;
        }
        return configService.getSetting("hibernate.delay_cdi_access", StandardConverters.BOOLEAN, Boolean.valueOf(false)) != false;
    }

    public static BeanLifecycleStrategy getLifecycleStrategy(boolean shouldRegistryManageLifecycle) {
        return shouldRegistryManageLifecycle ? JpaCompliantLifecycleStrategy.INSTANCE : ContainerManagedLifecycleStrategy.INSTANCE;
    }
}

