/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.hibernate.Internal;
import org.hibernate.MappingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.generator.OnExecutionGenerator;

@Internal
public class Insert {
    private final Dialect dialect;
    protected String tableName;
    protected String comment;
    protected Map<String, String> columns = new LinkedHashMap<String, String>();
    protected Map<String, String> lobColumns;

    public Insert(Dialect dialect) {
        this.dialect = dialect;
    }

    protected Dialect getDialect() {
        return this.dialect;
    }

    public Insert setComment(String comment) {
        this.comment = comment;
        return this;
    }

    public Map<String, String> getColumns() {
        return this.columns;
    }

    public Insert addColumn(String columnName) {
        return this.addColumn(columnName, "?");
    }

    public Insert addColumns(String[] columnNames) {
        for (String columnName : columnNames) {
            this.addColumn(columnName);
        }
        return this;
    }

    public Insert addColumns(String[] columnNames, boolean[] insertable) {
        for (int i = 0; i < columnNames.length; ++i) {
            if (!insertable[i]) continue;
            this.addColumn(columnNames[i]);
        }
        return this;
    }

    public Insert addColumns(String[] columnNames, boolean[] insertable, String[] valueExpressions) {
        for (int i = 0; i < columnNames.length; ++i) {
            if (!insertable[i]) continue;
            this.addColumn(columnNames[i], valueExpressions[i]);
        }
        return this;
    }

    public Insert addColumn(String columnName, String valueExpression) {
        this.columns.put(columnName, valueExpression);
        return this;
    }

    public void addLobColumn(String columnName, String valueExpression) {
        assert (this.dialect.forceLobAsLastValue());
        if (this.lobColumns == null) {
            this.lobColumns = new HashMap<String, String>();
        }
        this.lobColumns.put(columnName, valueExpression);
    }

    public Insert addIdentityColumn(String columnName) {
        IdentityColumnSupport identityColumnSupport = this.dialect.getIdentityColumnSupport();
        if (identityColumnSupport.hasIdentityInsertKeyword()) {
            this.addColumn(columnName, identityColumnSupport.getIdentityInsertString());
        }
        return this;
    }

    public Insert addGeneratedColumns(String[] columnNames, OnExecutionGenerator generator) {
        if (generator.referenceColumnsInSql(this.dialect)) {
            String[] columnValues = generator.getReferencedColumnValues(this.dialect);
            if (columnNames.length != columnValues.length) {
                throw new MappingException("wrong number of generated columns");
            }
            for (int i = 0; i < columnNames.length; ++i) {
                this.addColumn(columnNames[i], columnValues[i]);
            }
        }
        return this;
    }

    public Insert setTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String toStatementString() {
        StringBuilder buf = new StringBuilder(this.columns.size() * 15 + this.tableName.length() + 10);
        if (this.comment != null) {
            buf.append("/* ").append(Dialect.escapeComment(this.comment)).append(" */ ");
        }
        buf.append("insert into ").append(this.tableName);
        if (this.columns.size() == 0 && this.lobColumns == null) {
            if (!this.dialect.supportsNoColumnsInsert()) throw new MappingException(String.format("The INSERT statement for table [%s] contains no column, and this is not supported by [%s]", this.tableName, this.dialect));
            buf.append(' ').append(this.dialect.getNoColumnsInsertString());
            return buf.toString();
        } else {
            buf.append(" (");
            this.renderColumnsClause(buf);
            buf.append(") values (");
            this.renderValuesClause(buf);
            buf.append(')');
        }
        return buf.toString();
    }

    private void renderColumnsClause(StringBuilder buf) {
        Iterator<String> itr = this.columns.keySet().iterator();
        while (itr.hasNext()) {
            buf.append(itr.next());
            if (!itr.hasNext() && this.lobColumns == null) continue;
            buf.append(", ");
        }
        if (this.lobColumns != null) {
            Iterator<String> columnsAtEndItr = this.lobColumns.keySet().iterator();
            while (columnsAtEndItr.hasNext()) {
                buf.append(columnsAtEndItr.next());
                if (!columnsAtEndItr.hasNext()) continue;
                buf.append(", ");
            }
        }
    }

    private void renderValuesClause(StringBuilder buf) {
        Iterator<String> itr = this.columns.values().iterator();
        while (itr.hasNext()) {
            buf.append(itr.next());
            if (!itr.hasNext() && this.lobColumns == null) continue;
            buf.append(", ");
        }
        if (this.lobColumns != null) {
            Iterator<String> columnsAtEndItr = this.lobColumns.values().iterator();
            while (columnsAtEndItr.hasNext()) {
                buf.append(columnsAtEndItr.next());
                if (!columnsAtEndItr.hasNext()) continue;
                buf.append(", ");
            }
        }
    }
}

