/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.exec.spi;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.internal.FilterJdbcParameter;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.exec.spi.JdbcOperationQuery;
import org.hibernate.sql.exec.spi.JdbcParameterBinder;
import org.hibernate.sql.exec.spi.JdbcParameterBinding;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;

public class AbstractJdbcOperationQuery
implements JdbcOperationQuery {
    protected final String sql;
    protected final List<JdbcParameterBinder> parameterBinders;
    protected final Set<String> affectedTableNames;
    protected final Set<FilterJdbcParameter> filterJdbcParameters;
    protected final Map<JdbcParameter, JdbcParameterBinding> appliedParameters;

    public AbstractJdbcOperationQuery(String sql, List<JdbcParameterBinder> parameterBinders, Set<String> affectedTableNames, Set<FilterJdbcParameter> filterJdbcParameters) {
        this(sql, parameterBinders, affectedTableNames, filterJdbcParameters, Collections.emptyMap());
    }

    public AbstractJdbcOperationQuery(String sql, List<JdbcParameterBinder> parameterBinders, Set<String> affectedTableNames, Set<FilterJdbcParameter> filterJdbcParameters, Map<JdbcParameter, JdbcParameterBinding> appliedParameters) {
        this.sql = sql;
        this.parameterBinders = parameterBinders;
        this.affectedTableNames = affectedTableNames;
        this.filterJdbcParameters = filterJdbcParameters;
        this.appliedParameters = appliedParameters;
    }

    @Override
    public String getSqlString() {
        return this.sql;
    }

    @Override
    public List<JdbcParameterBinder> getParameterBinders() {
        return this.parameterBinders;
    }

    @Override
    public Set<String> getAffectedTableNames() {
        return this.affectedTableNames;
    }

    @Override
    public Set<FilterJdbcParameter> getFilterJdbcParameters() {
        return this.filterJdbcParameters;
    }

    @Override
    public boolean dependsOnParameterBindings() {
        return !this.appliedParameters.isEmpty();
    }

    @Override
    public boolean isCompatibleWith(JdbcParameterBindings jdbcParameterBindings, QueryOptions queryOptions) {
        if (!this.appliedParameters.isEmpty()) {
            if (jdbcParameterBindings == null) {
                return false;
            }
            for (Map.Entry<JdbcParameter, JdbcParameterBinding> entry : this.appliedParameters.entrySet()) {
                JdbcParameterBinding binding = jdbcParameterBindings.getBinding(entry.getKey());
                JdbcParameterBinding appliedBinding = entry.getValue();
                if (binding != null && appliedBinding.getBindType().getJavaTypeDescriptor().areEqual(binding.getBindValue(), appliedBinding.getBindValue())) continue;
                return false;
            }
        }
        return true;
    }
}

