/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.model.ast.builder;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.engine.jdbc.mutation.ParameterUsage;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.model.MutationOperation;
import org.hibernate.sql.model.MutationTarget;
import org.hibernate.sql.model.MutationType;
import org.hibernate.sql.model.TableMapping;
import org.hibernate.sql.model.ast.ColumnValueBinding;
import org.hibernate.sql.model.ast.MutatingTableReference;
import org.hibernate.sql.model.ast.RestrictedTableMutation;
import org.hibernate.sql.model.ast.builder.AbstractTableMutationBuilder;
import org.hibernate.sql.model.ast.builder.RestrictedTableMutationBuilder;

public abstract class AbstractRestrictedTableMutationBuilder<O extends MutationOperation, M extends RestrictedTableMutation<O>>
extends AbstractTableMutationBuilder<M>
implements RestrictedTableMutationBuilder<O, M> {
    private final List<ColumnValueBinding> keyRestrictionBindings = new ArrayList<ColumnValueBinding>();
    private List<ColumnValueBinding> optimisticLockBindings;

    public AbstractRestrictedTableMutationBuilder(MutationType mutationType, MutationTarget<?> mutationTarget, TableMapping table, SessionFactoryImplementor sessionFactory) {
        super(mutationType, mutationTarget, table, sessionFactory);
    }

    public AbstractRestrictedTableMutationBuilder(MutationType mutationType, MutationTarget<?> mutationTarget, MutatingTableReference tableReference, SessionFactoryImplementor sessionFactory) {
        super(mutationType, mutationTarget, tableReference, sessionFactory);
    }

    public List<ColumnValueBinding> getKeyRestrictionBindings() {
        return this.keyRestrictionBindings;
    }

    public List<ColumnValueBinding> getOptimisticLockBindings() {
        return this.optimisticLockBindings;
    }

    @Override
    public void addKeyRestriction(String columnName, String columnWriteFragment, JdbcMapping jdbcMapping) {
        this.addColumn(columnName, columnWriteFragment, jdbcMapping, ParameterUsage.RESTRICT, this.keyRestrictionBindings);
    }

    @Override
    public void addNullOptimisticLockRestriction(SelectableMapping column) {
        if (this.optimisticLockBindings == null) {
            this.optimisticLockBindings = new ArrayList<ColumnValueBinding>();
        }
        ColumnReference columnReference = new ColumnReference(this.getMutatingTable(), column.getSelectionExpression(), column.getJdbcMapping());
        this.optimisticLockBindings.add(new ColumnValueBinding(columnReference, null));
    }

    @Override
    public void addOptimisticLockRestriction(String columnName, String columnWriteFragment, JdbcMapping jdbcMapping) {
        if (this.optimisticLockBindings == null) {
            this.optimisticLockBindings = new ArrayList<ColumnValueBinding>();
        }
        this.addColumn(columnName, columnWriteFragment, jdbcMapping, ParameterUsage.RESTRICT, this.optimisticLockBindings);
    }

    @Override
    public void setWhere(String fragment) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addWhereFragment(String fragment) {
        throw new UnsupportedOperationException();
    }
}

