/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.model.ast.builder;

import java.util.Collections;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.sql.model.MutationTarget;
import org.hibernate.sql.model.TableMapping;
import org.hibernate.sql.model.ast.MutatingTableReference;
import org.hibernate.sql.model.ast.TableInsert;
import org.hibernate.sql.model.ast.builder.AbstractTableInsertBuilder;
import org.hibernate.sql.model.internal.TableInsertCustomSql;
import org.hibernate.sql.model.internal.TableInsertStandard;

public class TableInsertBuilderStandard
extends AbstractTableInsertBuilder {
    private final boolean isCustomSql;

    public TableInsertBuilderStandard(MutationTarget<?> mutationTarget, TableMapping table, SessionFactoryImplementor sessionFactory) {
        super(mutationTarget, table, sessionFactory);
        this.isCustomSql = table.getInsertDetails().getCustomSql() != null;
    }

    public TableInsertBuilderStandard(MutationTarget<?> mutationTarget, MutatingTableReference tableReference, SessionFactoryImplementor sessionFactory) {
        super(mutationTarget, tableReference, sessionFactory);
        this.isCustomSql = tableReference.getTableMapping().getInsertDetails().getCustomSql() != null;
    }

    @Override
    public TableInsert buildMutation() {
        if (this.isCustomSql) {
            return new TableInsertCustomSql(this.getMutatingTable(), this.getMutationTarget(), this.combine(this.getValueBindingList(), this.getKeyBindingList(), this.getLobValueBindingList()), this.getParameters());
        }
        return new TableInsertStandard(this.getMutatingTable(), this.getMutationTarget(), this.combine(this.getValueBindingList(), this.getKeyBindingList(), this.getLobValueBindingList()), Collections.emptyList(), this.getParameters());
    }
}

