/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.model.jdbc;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import org.hibernate.engine.jdbc.mutation.JdbcValueBindings;
import org.hibernate.engine.jdbc.mutation.ParameterUsage;
import org.hibernate.engine.jdbc.mutation.group.PreparedStatementDetails;
import org.hibernate.engine.jdbc.mutation.internal.JdbcValueDescriptorImpl;
import org.hibernate.engine.jdbc.mutation.internal.MutationQueryOptions;
import org.hibernate.engine.jdbc.mutation.internal.PreparedStatementGroupSingleTable;
import org.hibernate.engine.jdbc.mutation.spi.Binding;
import org.hibernate.engine.jdbc.mutation.spi.BindingGroup;
import org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.hibernate.engine.jdbc.spi.MutationStatementPreparer;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.jdbc.Expectation;
import org.hibernate.persister.entity.mutation.EntityMutationTarget;
import org.hibernate.persister.entity.mutation.EntityTableMapping;
import org.hibernate.persister.entity.mutation.UpdateValuesAnalysis;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.model.ModelMutationLogging;
import org.hibernate.sql.model.MutationTarget;
import org.hibernate.sql.model.MutationType;
import org.hibernate.sql.model.PreparableMutationOperation;
import org.hibernate.sql.model.SelfExecutingUpdateOperation;
import org.hibernate.sql.model.TableMapping;
import org.hibernate.sql.model.ValuesAnalysis;
import org.hibernate.sql.model.ast.AbstractTableDelete;
import org.hibernate.sql.model.ast.AbstractTableInsert;
import org.hibernate.sql.model.ast.AbstractTableUpdate;
import org.hibernate.sql.model.ast.ColumnValueBinding;
import org.hibernate.sql.model.ast.ColumnValueParameter;
import org.hibernate.sql.model.ast.MutatingTableReference;
import org.hibernate.sql.model.internal.TableDeleteCustomSql;
import org.hibernate.sql.model.internal.TableDeleteStandard;
import org.hibernate.sql.model.internal.TableInsertCustomSql;
import org.hibernate.sql.model.internal.TableInsertStandard;
import org.hibernate.sql.model.internal.TableUpdateCustomSql;
import org.hibernate.sql.model.internal.TableUpdateStandard;
import org.hibernate.sql.model.internal.TableUpsert;
import org.hibernate.sql.model.jdbc.JdbcDeleteMutation;
import org.hibernate.sql.model.jdbc.JdbcInsertMutation;
import org.hibernate.sql.model.jdbc.JdbcMutationOperation;
import org.hibernate.sql.model.jdbc.JdbcValueDescriptor;
import org.hibernate.type.descriptor.WrapperOptions;

public class OptionalTableUpdateOperation
implements SelfExecutingUpdateOperation {
    private final EntityMutationTarget mutationTarget;
    private final EntityTableMapping tableMapping;
    private final Expectation expectation;
    private final List<ColumnValueBinding> valueBindings;
    private final List<ColumnValueBinding> keyBindings;
    private final List<ColumnValueBinding> optimisticLockBindings;
    private final List<ColumnValueParameter> parameters;
    private final List<JdbcValueDescriptorImpl> jdbcValueDescriptors;

    public OptionalTableUpdateOperation(MutationTarget<?> mutationTarget, TableUpsert upsert, SessionFactoryImplementor factory) {
        this.mutationTarget = (EntityMutationTarget)mutationTarget;
        this.tableMapping = (EntityTableMapping)upsert.getMutatingTable().getTableMapping();
        this.expectation = upsert.getExpectation();
        this.valueBindings = upsert.getValueBindings();
        this.keyBindings = upsert.getKeyBindings();
        this.optimisticLockBindings = upsert.getOptimisticLockBindings();
        this.parameters = upsert.getParameters();
        this.jdbcValueDescriptors = CollectionHelper.arrayList(this.parameters.size());
        for (int i = 0; i < this.parameters.size(); ++i) {
            ColumnValueParameter valueParameter = this.parameters.get(i);
            this.jdbcValueDescriptors.add(new JdbcValueDescriptorImpl(valueParameter, i + 1));
        }
    }

    @Override
    public MutationType getMutationType() {
        return MutationType.UPDATE;
    }

    @Override
    public MutationTarget<?> getMutationTarget() {
        return this.mutationTarget;
    }

    @Override
    public TableMapping getTableDetails() {
        return this.tableMapping;
    }

    @Override
    public JdbcValueDescriptor findValueDescriptor(String columnName, ParameterUsage usage) {
        for (int i = 0; i < this.jdbcValueDescriptors.size(); ++i) {
            JdbcValueDescriptor descriptor = this.jdbcValueDescriptors.get(i);
            if (!descriptor.getColumnName().equals(columnName) || descriptor.getUsage() != usage) continue;
            return descriptor;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performMutation(JdbcValueBindings jdbcValueBindings, ValuesAnalysis incomingValuesAnalysis, SharedSessionContractImplementor session) {
        UpdateValuesAnalysis valuesAnalysis = (UpdateValuesAnalysis)incomingValuesAnalysis;
        if (!valuesAnalysis.getTablesNeedingUpdate().contains(this.tableMapping)) {
            return;
        }
        try {
            if (!valuesAnalysis.getTablesWithNonNullValues().contains(this.tableMapping)) {
                if (valuesAnalysis.getTablesWithPreviousNonNullValues().contains(this.tableMapping)) {
                    this.performDelete(jdbcValueBindings, session);
                }
            } else {
                boolean wasUpdated = valuesAnalysis.getTablesWithPreviousNonNullValues().contains(this.tableMapping) ? this.performUpdate(jdbcValueBindings, session) : false;
                if (!wasUpdated) {
                    ModelMutationLogging.MODEL_MUTATION_LOGGER.debugf("Upsert update altered no rows - inserting : %s", (Object)this.tableMapping.getTableName());
                    this.performInsert(jdbcValueBindings, session);
                }
            }
        }
        finally {
            jdbcValueBindings.afterStatement(this.tableMapping, session);
        }
    }

    private void performDelete(JdbcValueBindings jdbcValueBindings, SharedSessionContractImplementor session) {
        JdbcDeleteMutation jdbcDelete = this.createJdbcDelete(session);
        PreparedStatement deleteStatement = OptionalTableUpdateOperation.createStatementDetails(jdbcDelete, session);
        session.getJdbcServices().getSqlStatementLogger().logStatement(jdbcDelete.getSqlString());
        this.bindKeyValues(jdbcValueBindings, deleteStatement, jdbcDelete, session);
        session.getJdbcCoordinator().getResultSetReturn().executeUpdate(deleteStatement, jdbcDelete.getSqlString());
    }

    private void bindKeyValues(JdbcValueBindings jdbcValueBindings, PreparedStatement statement, JdbcDeleteMutation jdbcDelete, SharedSessionContractImplementor session) {
        BindingGroup bindingGroup = jdbcValueBindings.getBindingGroup(this.tableMapping.getTableName());
        if (bindingGroup == null) {
            throw new IllegalStateException(String.format(Locale.ROOT, "No value bindings for table on insert : %s", this.tableMapping.getTableName()));
        }
        int jdbcBindingPosition = 1;
        boolean foundKeyBindings = false;
        Set<Binding> bindings = bindingGroup.getBindings();
        Iterator<ColumnValueBinding> keyBindingsItr = this.keyBindings.iterator();
        block0: for (Binding binding : bindings) {
            JdbcValueDescriptorImpl valueDescriptor = this.jdbcValueDescriptors.get(binding.getPosition() - 1);
            if (valueDescriptor.getUsage() != ParameterUsage.RESTRICT) continue;
            while (keyBindingsItr.hasNext()) {
                ColumnValueBinding valueBinding = keyBindingsItr.next();
                if (Objects.equals(valueBinding.getColumnReference().getColumnExpression(), binding.getColumnName())) {
                    foundKeyBindings = true;
                    this.bindKeyValue(jdbcBindingPosition++, binding, valueDescriptor, statement, jdbcDelete.getSqlString(), session);
                    continue block0;
                }
                if (!foundKeyBindings) continue;
                break block0;
            }
        }
    }

    private void bindKeyValue(int jdbcPosition, Binding binding, JdbcValueDescriptorImpl valueDescriptor, PreparedStatement statement, String sql, SharedSessionContractImplementor session) {
        try {
            binding.getValueBinder().bind(statement, binding.getValue(), jdbcPosition, (WrapperOptions)session);
        }
        catch (SQLException e) {
            throw session.getJdbcServices().getSqlExceptionHelper().convert(e, String.format(Locale.ROOT, "Unable to bind parameter for upsert insert : %s.%s", this.tableMapping.getTableName(), valueDescriptor.getColumnName()), sql);
        }
    }

    private JdbcDeleteMutation createJdbcDelete(SharedSessionContractImplementor session) {
        AbstractTableDelete tableDelete = this.tableMapping.getDeleteDetails() != null && this.tableMapping.getDeleteDetails().getCustomSql() != null ? new TableDeleteCustomSql(new MutatingTableReference(this.tableMapping), this.getMutationTarget(), "upsert delete for " + this.mutationTarget.getRolePath(), this.keyBindings, this.optimisticLockBindings, this.parameters) : new TableDeleteStandard(new MutatingTableReference(this.tableMapping), this.getMutationTarget(), "upsert delete for " + this.mutationTarget.getRolePath(), this.keyBindings, this.optimisticLockBindings, this.parameters);
        SessionFactoryImplementor factory = session.getSessionFactory();
        SqlAstTranslatorFactory sqlAstTranslatorFactory = factory.getJdbcServices().getJdbcEnvironment().getSqlAstTranslatorFactory();
        SqlAstTranslator<JdbcDeleteMutation> translator = sqlAstTranslatorFactory.buildModelMutationTranslator(tableDelete, factory);
        return translator.translate(null, MutationQueryOptions.INSTANCE);
    }

    private boolean performUpdate(JdbcValueBindings jdbcValueBindings, SharedSessionContractImplementor session) {
        ModelMutationLogging.MODEL_MUTATION_LOGGER.tracef("#performUpdate(%s)", (Object)this.tableMapping.getTableName());
        AbstractTableUpdate tableUpdate = this.tableMapping.getUpdateDetails() != null && this.tableMapping.getUpdateDetails().getCustomSql() != null ? new TableUpdateCustomSql(new MutatingTableReference(this.tableMapping), this.mutationTarget, "upsert update for " + this.mutationTarget.getRolePath(), this.valueBindings, this.keyBindings, this.optimisticLockBindings, this.parameters) : new TableUpdateStandard(new MutatingTableReference(this.tableMapping), this.mutationTarget, "upsert update for " + this.mutationTarget.getRolePath(), this.valueBindings, this.keyBindings, this.optimisticLockBindings, this.parameters);
        SqlAstTranslator<JdbcMutationOperation> translator = session.getJdbcServices().getJdbcEnvironment().getSqlAstTranslatorFactory().buildModelMutationTranslator(tableUpdate, session.getFactory());
        JdbcMutationOperation jdbcUpdate = translator.translate(null, MutationQueryOptions.INSTANCE);
        PreparedStatementGroupSingleTable statementGroup = new PreparedStatementGroupSingleTable(jdbcUpdate, session);
        PreparedStatementDetails statementDetails = statementGroup.resolvePreparedStatementDetails(this.tableMapping.getTableName());
        try {
            PreparedStatement updateStatement = statementDetails.resolveStatement();
            session.getJdbcServices().getSqlStatementLogger().logStatement(statementDetails.getSqlString());
            jdbcValueBindings.beforeStatement(statementDetails, session);
            int rowCount = session.getJdbcCoordinator().getResultSetReturn().executeUpdate(updateStatement, statementDetails.getSqlString());
            if (rowCount == 0) {
                return false;
            }
            this.expectation.verifyOutcome(rowCount, updateStatement, -1, statementDetails.getSqlString());
            return true;
        }
        catch (SQLException e) {
            throw session.getJdbcServices().getSqlExceptionHelper().convert(e, "Unable to execute mutation PreparedStatement against table `" + this.tableMapping.getTableName() + "`", statementDetails.getSqlString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performInsert(JdbcValueBindings jdbcValueBindings, SharedSessionContractImplementor session) {
        JdbcInsertMutation jdbcInsert = this.createJdbcInsert(session);
        PreparedStatement insertStatement = OptionalTableUpdateOperation.createStatementDetails(jdbcInsert, session);
        try {
            session.getJdbcServices().getSqlStatementLogger().logStatement(jdbcInsert.getSqlString());
            BindingGroup bindingGroup = jdbcValueBindings.getBindingGroup(this.tableMapping.getTableName());
            if (bindingGroup != null) {
                bindingGroup.forEachBinding(binding -> {
                    try {
                        binding.getValueBinder().bind(insertStatement, binding.getValue(), binding.getPosition(), (WrapperOptions)session);
                    }
                    catch (SQLException e) {
                        throw session.getJdbcServices().getSqlExceptionHelper().convert(e, "Unable to bind parameter for upsert insert", jdbcInsert.getSqlString());
                    }
                });
            }
            session.getJdbcCoordinator().getResultSetReturn().executeUpdate(insertStatement, jdbcInsert.getSqlString());
        }
        finally {
            session.getJdbcCoordinator().getLogicalConnection().getResourceRegistry().release(insertStatement);
        }
    }

    private JdbcInsertMutation createJdbcInsert(SharedSessionContractImplementor session) {
        AbstractTableInsert tableInsert = this.tableMapping.getInsertDetails() != null && this.tableMapping.getInsertDetails().getCustomSql() != null ? new TableInsertCustomSql(new MutatingTableReference(this.tableMapping), this.getMutationTarget(), CollectionHelper.combine(this.valueBindings, this.keyBindings), this.parameters) : new TableInsertStandard(new MutatingTableReference(this.tableMapping), this.getMutationTarget(), CollectionHelper.combine(this.valueBindings, this.keyBindings), Collections.emptyList(), this.parameters);
        SessionFactoryImplementor factory = session.getSessionFactory();
        SqlAstTranslatorFactory sqlAstTranslatorFactory = factory.getJdbcServices().getJdbcEnvironment().getSqlAstTranslatorFactory();
        SqlAstTranslator<JdbcInsertMutation> translator = sqlAstTranslatorFactory.buildModelMutationTranslator(tableInsert, factory);
        return translator.translate(null, MutationQueryOptions.INSTANCE);
    }

    private static PreparedStatement createStatementDetails(PreparableMutationOperation operation, SharedSessionContractImplementor session) {
        JdbcCoordinator jdbcCoordinator = session.getJdbcCoordinator();
        MutationStatementPreparer statementPreparer = jdbcCoordinator.getMutationStatementPreparer();
        PreparedStatement statement = statementPreparer.prepareStatement(operation.getSqlString(), false);
        session.getJdbcCoordinator().getLogicalConnection().getResourceRegistry().register(null, statement);
        return statement;
    }

    public String toString() {
        return "OptionalTableUpdateOperation(" + this.tableMapping + ")";
    }
}

