/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal;

import java.util.Map;
import java.util.Objects;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.graph.AttributeNode;
import org.hibernate.graph.GraphSemantic;
import org.hibernate.graph.spi.GraphImplementor;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.internal.EntityCollectionPart;
import org.hibernate.sql.results.graph.EntityGraphTraversalState;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.Fetchable;

public class StandardEntityGraphTraversalStateImpl
implements EntityGraphTraversalState {
    private final GraphSemantic graphSemantic;
    private GraphImplementor currentGraphContext;

    public StandardEntityGraphTraversalStateImpl(GraphSemantic graphSemantic, RootGraphImplementor rootGraphImplementor) {
        Objects.requireNonNull(graphSemantic, "graphSemantic cannot be null");
        Objects.requireNonNull(rootGraphImplementor, "rootGraphImplementor cannot be null");
        this.graphSemantic = graphSemantic;
        this.currentGraphContext = rootGraphImplementor;
    }

    @Override
    public void backtrack(EntityGraphTraversalState.TraversalResult previousContext) {
        this.currentGraphContext = previousContext.getGraph();
    }

    @Override
    public EntityGraphTraversalState.TraversalResult traverse(FetchParent fetchParent, Fetchable fetchable, boolean exploreKeySubgraph) {
        assert (!(fetchable instanceof CollectionPart));
        GraphImplementor previousContextRoot = this.currentGraphContext;
        AttributeNode attributeNode = null;
        if (this.appliesTo(fetchParent)) {
            attributeNode = this.currentGraphContext.findAttributeNode(fetchable.getFetchableName());
        }
        this.currentGraphContext = null;
        FetchTiming fetchTiming = null;
        boolean joined = false;
        if (attributeNode != null) {
            Class<?> subgraphMapKey;
            Map subgraphMap;
            fetchTiming = FetchTiming.IMMEDIATE;
            joined = true;
            if (fetchable instanceof PluralAttributeMapping) {
                PluralAttributeMapping pluralAttributeMapping = (PluralAttributeMapping)fetchable;
                if (exploreKeySubgraph) {
                    subgraphMap = attributeNode.getKeySubGraphMap();
                    subgraphMapKey = this.getEntityCollectionPartJavaClass(pluralAttributeMapping.getIndexDescriptor());
                } else {
                    subgraphMap = attributeNode.getSubGraphMap();
                    subgraphMapKey = this.getEntityCollectionPartJavaClass(pluralAttributeMapping.getElementDescriptor());
                }
            } else {
                assert (!exploreKeySubgraph);
                subgraphMap = attributeNode.getSubGraphMap();
                subgraphMapKey = fetchable.getJavaType().getJavaTypeClass();
            }
            if (subgraphMap != null && subgraphMapKey != null) {
                this.currentGraphContext = subgraphMap.get(subgraphMapKey);
            }
        }
        if (fetchTiming == null) {
            if (this.graphSemantic == GraphSemantic.FETCH) {
                fetchTiming = FetchTiming.DELAYED;
                joined = false;
            } else {
                fetchTiming = fetchable.getMappedFetchOptions().getTiming();
                joined = fetchable.getMappedFetchOptions().getStyle() == FetchStyle.JOIN;
            }
        }
        return new EntityGraphTraversalState.TraversalResult(previousContextRoot, fetchTiming, joined);
    }

    private Class<?> getEntityCollectionPartJavaClass(CollectionPart collectionPart) {
        if (collectionPart instanceof EntityCollectionPart) {
            EntityCollectionPart entityCollectionPart = (EntityCollectionPart)collectionPart;
            return entityCollectionPart.getEntityMappingType().getJavaType().getJavaTypeClass();
        }
        return null;
    }

    private boolean appliesTo(FetchParent fetchParent) {
        if (this.currentGraphContext == null) {
            return false;
        }
        return fetchParent.appliesTo(this.currentGraphContext);
    }
}

